/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlException;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.shaded.com.google.inject.Singleton;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.javax.ws.rs.Consumes;
import org.apache.hadoop.shaded.javax.ws.rs.DELETE;
import org.apache.hadoop.shaded.javax.ws.rs.DefaultValue;
import org.apache.hadoop.shaded.javax.ws.rs.FormParam;
import org.apache.hadoop.shaded.javax.ws.rs.GET;
import org.apache.hadoop.shaded.javax.ws.rs.POST;
import org.apache.hadoop.shaded.javax.ws.rs.PUT;
import org.apache.hadoop.shaded.javax.ws.rs.Path;
import org.apache.hadoop.shaded.javax.ws.rs.PathParam;
import org.apache.hadoop.shaded.javax.ws.rs.Produces;
import org.apache.hadoop.shaded.javax.ws.rs.QueryParam;
import org.apache.hadoop.shaded.javax.ws.rs.core.Context;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.shaded.org.apache.commons.lang3.EnumUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.nodelabels.RMNodeLabel;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NodeLabelsUtils;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigValidator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.ApplicationsRequestBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.DeSelectFields;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodeIDsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWSConsts;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebAppUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServiceProtocol;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppPriority;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationStatisticsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.BulkActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterUserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ConfigVersionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DelegationToken;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FifoSchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LabelsToNodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NewApplication;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NewReservation;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntry;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntryList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.PartitionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.RMQueueAclInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDefinitionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDeleteRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDeleteResponseInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationListInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationRequestsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationSubmissionRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationUpdateRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationUpdateResponseInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceOptionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerOverviewInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerTypeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.StatisticsItemInfo;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.webapp.WebServices;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.util.AdHocLogDumper;
import org.apache.hadoop.yarn.util.AppsCacheKey;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.LRUCache;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.dao.ConfInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/ws/v1/cluster")
public class RMWebServices
extends WebServices
implements RMWebServiceProtocol {
    private static final Logger LOG = LoggerFactory.getLogger((String)RMWebServices.class.getName());
    private final ResourceManager rm;
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final Configuration conf;
    @Context
    private HttpServletResponse response;
    public static final String DEFAULT_QUEUE = "default";
    public static final String DEFAULT_RESERVATION_ID = "";
    public static final String DEFAULT_START_TIME = "0";
    public static final String DEFAULT_END_TIME = "-1";
    public static final String DEFAULT_INCLUDE_RESOURCE = "false";
    public static final String DEFAULT_SUMMARIZE = "false";
    public static final String DEFAULT_ACTIVITIES_COUNT = "10";
    public static final int MAX_ACTIVITIES_COUNT = 500;
    private static final String ERROR_MSG = "Not Capacity Scheduler";
    @VisibleForTesting
    boolean isCentralizedNodeLabelConfiguration = true;
    private boolean filterAppsByUser = false;
    private boolean filterInvalidXMLChars = false;
    private boolean enableRestAppSubmissions = true;
    private LRUCache<AppsCacheKey, AppsInfo> appsLRUCache;
    private AtomicLong getAppsSuccessTimes = new AtomicLong(0L);
    private AtomicLong hitAppsCacheTimes = new AtomicLong(0L);
    private boolean enableAppsCache = false;
    public static final String DELEGATION_TOKEN_HEADER = "Hadoop-YARN-RM-Delegation-Token";

    @Inject
    public RMWebServices(ResourceManager rm, Configuration conf) {
        super(null);
        this.rm = rm;
        this.conf = conf;
        this.isCentralizedNodeLabelConfiguration = YarnConfiguration.isCentralizedNodeLabelConfiguration((Configuration)conf);
        this.filterAppsByUser = conf.getBoolean("yarn.webapp.filter-entity-list-by-user", false);
        this.filterInvalidXMLChars = conf.getBoolean("yarn.webapp.filter-invalid-xml-chars", false);
        this.enableRestAppSubmissions = conf.getBoolean("yarn.webapp.enable-rest-app-submissions", true);
        this.enableAppsCache = this.conf.getBoolean("yarn.apps.cache.enable", false);
        if (this.enableAppsCache) {
            int cacheSize = this.conf.getInt("yarn.apps.cache.size", 1000);
            long appsCacheTimeMs = this.conf.getTimeDuration("yarn.apps.cache.expire", "30s", TimeUnit.MILLISECONDS);
            this.appsLRUCache = new LRUCache(cacheSize, appsCacheTimeMs);
        }
    }

    RMWebServices(ResourceManager rm, Configuration conf, HttpServletResponse response) {
        this(rm, conf);
        this.response = response;
    }

    protected Boolean hasAccess(RMApp app, HttpServletRequest hsr) {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        List<String> forwardedAddresses = null;
        String forwardedFor = hsr.getHeader("X-Forwarded-For");
        if (forwardedFor != null) {
            forwardedAddresses = Arrays.asList(forwardedFor.split(","));
        }
        if (callerUGI != null && !this.rm.getApplicationACLsManager().checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, app.getUser(), app.getApplicationId()) && !this.rm.getQueueACLsManager().checkAccess(callerUGI, QueueACL.ADMINISTER_QUEUE, app, hsr.getRemoteAddr(), forwardedAddresses)) {
            return false;
        }
        return true;
    }

    private void initForReadableEndpoints() {
        this.response.setContentType(null);
    }

    private void initForWritableEndpoints(UserGroupInformation callerUGI, boolean doAdminACLsCheck) throws AuthorizationException {
        ApplicationACLsManager aclsManager;
        this.response.setContentType(null);
        if (callerUGI == null) {
            String msg = "Unable to obtain user name, user not authenticated";
            throw new AuthorizationException(msg);
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            throw new ForbiddenException(msg);
        }
        if (doAdminACLsCheck && (aclsManager = this.rm.getApplicationACLsManager()).areACLsEnabled() && !aclsManager.isAdmin(callerUGI)) {
            String msg = "Only admins can carry out this operation.";
            throw new ForbiddenException(msg);
        }
    }

    @Override
    @GET
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ClusterInfo get() {
        return this.getClusterInfo();
    }

    @Override
    @GET
    @Path(value="/info")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ClusterInfo getClusterInfo() {
        this.initForReadableEndpoints();
        return new ClusterInfo(this.rm);
    }

    @Override
    @GET
    @Path(value="/userinfo")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ClusterUserInfo getClusterUserInfo(@Context HttpServletRequest hsr) {
        this.initForReadableEndpoints();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        return new ClusterUserInfo(this.rm, callerUGI);
    }

    @Override
    @GET
    @Path(value="/metrics")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ClusterMetricsInfo getClusterMetricsInfo() {
        this.initForReadableEndpoints();
        return new ClusterMetricsInfo(this.rm);
    }

    @Override
    @GET
    @Path(value="/scheduler")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public SchedulerTypeInfo getSchedulerInfo() {
        SchedulerInfo sinfo;
        this.initForReadableEndpoints();
        ResourceScheduler rs = this.rm.getResourceScheduler();
        if (rs instanceof CapacityScheduler) {
            CapacityScheduler cs = (CapacityScheduler)rs;
            CSQueue root = cs.getRootQueue();
            sinfo = new CapacitySchedulerInfo(root, cs);
        } else if (rs instanceof FairScheduler) {
            FairScheduler fs = (FairScheduler)rs;
            sinfo = new FairSchedulerInfo(fs);
        } else if (rs instanceof FifoScheduler) {
            sinfo = new FifoSchedulerInfo(this.rm);
        } else {
            throw new NotFoundException("Unknown scheduler configured");
        }
        return new SchedulerTypeInfo(sinfo);
    }

    @Override
    @POST
    @Path(value="/scheduler/logs")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public String dumpSchedulerLogs(@FormParam(value="time") String time, @Context HttpServletRequest hsr) throws IOException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, true);
        ResourceScheduler rs = this.rm.getResourceScheduler();
        int period = Integer.parseInt(time);
        if (period <= 0) {
            throw new BadRequestException("Period must be greater than 0");
        }
        String logHierarchy = "org.apache.hadoop.yarn.server.resourcemanager.scheduler";
        String logfile = "yarn-scheduler-debug.log";
        if (rs instanceof CapacityScheduler) {
            logfile = "yarn-capacity-scheduler-debug.log";
        } else if (rs instanceof FairScheduler) {
            logfile = "yarn-fair-scheduler-debug.log";
        }
        AdHocLogDumper dumper = new AdHocLogDumper("org.apache.hadoop.yarn.server.resourcemanager.scheduler", logfile);
        dumper.dumpLogs("DEBUG", period * 1000);
        return "Capacity scheduler logs are being created.";
    }

    @Override
    @GET
    @Path(value="/nodes")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodesInfo getNodes(@QueryParam(value="states") String states) {
        EnumSet<NodeState> acceptedStates;
        this.initForReadableEndpoints();
        ResourceScheduler sched = this.rm.getResourceScheduler();
        if (sched == null) {
            throw new NotFoundException("Null ResourceScheduler instance");
        }
        if (states == null) {
            acceptedStates = EnumSet.allOf(NodeState.class);
        } else {
            acceptedStates = EnumSet.noneOf(NodeState.class);
            for (String stateStr : states.split(",")) {
                acceptedStates.add(NodeState.valueOf((String)StringUtils.toUpperCase((String)stateStr)));
            }
        }
        List<RMNode> rmNodes = RMServerUtils.queryRMNodes(this.rm.getRMContext(), acceptedStates);
        NodesInfo nodesInfo = new NodesInfo();
        for (RMNode rmNode : rmNodes) {
            NodeInfo nodeInfo = new NodeInfo(rmNode, sched);
            if (rmNode.getState().isInactiveState()) {
                nodeInfo.setNodeHTTPAddress(DEFAULT_RESERVATION_ID);
            }
            nodesInfo.add(nodeInfo);
        }
        return nodesInfo;
    }

    @Override
    @GET
    @Path(value="/nodes/{nodeId}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodeInfo getNode(@PathParam(value="nodeId") String nodeId) {
        this.initForReadableEndpoints();
        if (nodeId == null || nodeId.isEmpty()) {
            throw new NotFoundException("nodeId, " + nodeId + ", is empty or null");
        }
        ResourceScheduler sched = this.rm.getResourceScheduler();
        if (sched == null) {
            throw new NotFoundException("Null ResourceScheduler instance");
        }
        NodeId nid = NodeId.fromString((String)nodeId);
        RMNode ni = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        boolean isInactive = false;
        if (ni == null) {
            ni = (RMNode)this.rm.getRMContext().getInactiveRMNodes().get(nid);
            if (ni == null) {
                throw new NotFoundException("nodeId, " + nodeId + ", is not found");
            }
            isInactive = true;
        }
        NodeInfo nodeInfo = new NodeInfo(ni, sched);
        if (isInactive) {
            nodeInfo.setNodeHTTPAddress(DEFAULT_RESERVATION_ID);
        }
        return nodeInfo;
    }

    @Override
    @POST
    @Path(value="/nodes/{nodeId}/resource")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ResourceInfo updateNodeResource(@Context HttpServletRequest hsr, @PathParam(value="nodeId") String nodeId, ResourceOptionInfo resourceOption) throws AuthorizationException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        RMNode rmNode = this.getRMNode(nodeId);
        Map<NodeId, ResourceOption> nodeResourceMap = Collections.singletonMap(rmNode.getNodeID(), resourceOption.getResourceOption());
        UpdateNodeResourceRequest updateRequest = UpdateNodeResourceRequest.newInstance(nodeResourceMap);
        try {
            RMContext rmContext = this.rm.getRMContext();
            AdminService admin = rmContext.getRMAdminService();
            admin.updateNodeResource(updateRequest);
        }
        catch (YarnException e) {
            String message = "Failed to update the node resource " + rmNode.getNodeID() + ".";
            LOG.error(message, (Throwable)e);
            throw new YarnRuntimeException(message, (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Failed to update the node resource {}.", (Object)rmNode.getNodeID(), (Object)e);
        }
        return new ResourceInfo(rmNode.getTotalCapability());
    }

    private RMNode getRMNode(String nodeId) {
        if (nodeId == null || nodeId.isEmpty()) {
            throw new NotFoundException("nodeId, " + nodeId + ", is empty or null");
        }
        NodeId nid = NodeId.fromString((String)nodeId);
        RMContext rmContext = this.rm.getRMContext();
        RMNode ni = (RMNode)rmContext.getRMNodes().get(nid);
        if (ni == null && (ni = (RMNode)rmContext.getInactiveRMNodes().get(nid)) == null) {
            throw new NotFoundException("nodeId, " + nodeId + ", is not found");
        }
        return ni;
    }

    public static String escapeInvalidXMLCharacters(String str) {
        int cpt;
        StringBuffer out = new StringBuffer();
        int strlen = str.length();
        String substitute = "\ufffd";
        for (int idx = 0; idx < strlen; idx += Character.isSupplementaryCodePoint(cpt = str.codePointAt(idx)) ? 2 : 1) {
            if (cpt == 9 || cpt == 10 || cpt == 13 || cpt >= 32 && cpt <= 55295 || cpt >= 57344 && cpt <= 65533 || cpt >= 65536 && cpt <= 0x10FFFF) {
                out.append(Character.toChars(cpt));
                continue;
            }
            out.append("\ufffd");
        }
        return out.toString();
    }

    @Override
    @GET
    @Path(value="/apps")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppsInfo getApps(@Context HttpServletRequest hsr, @QueryParam(value="state") String stateQuery, @QueryParam(value="states") Set<String> statesQuery, @QueryParam(value="finalStatus") String finalStatusQuery, @QueryParam(value="user") String userQuery, @QueryParam(value="queue") String queueQuery, @QueryParam(value="limit") String limit, @QueryParam(value="startedTimeBegin") String startedBegin, @QueryParam(value="startedTimeEnd") String startedEnd, @QueryParam(value="finishedTimeBegin") String finishBegin, @QueryParam(value="finishedTimeEnd") String finishEnd, @QueryParam(value="applicationTypes") Set<String> applicationTypes, @QueryParam(value="applicationTags") Set<String> applicationTags, @QueryParam(value="name") String name, @QueryParam(value="deSelects") Set<String> unselectedFields) {
        String format;
        List appReports;
        AppsCacheKey cacheKey = AppsCacheKey.newInstance((String)stateQuery, new HashSet<String>(statesQuery), (String)finalStatusQuery, (String)userQuery, (String)queueQuery, (String)limit, (String)startedBegin, (String)startedEnd, (String)finishBegin, (String)finishEnd, new HashSet<String>(applicationTypes), new HashSet<String>(applicationTags), (String)name, unselectedFields);
        if (this.enableAppsCache) {
            AppsInfo appsInfo;
            long successTimes = this.getAppsSuccessTimes.incrementAndGet();
            if (successTimes % 1000L == 0L) {
                LOG.debug("hit cache info: getAppsSuccessTimes={}, hitAppsCacheTimes={}", (Object)successTimes, (Object)this.hitAppsCacheTimes.get());
            }
            if ((appsInfo = (AppsInfo)this.appsLRUCache.get((Object)cacheKey)) != null) {
                this.hitAppsCacheTimes.getAndIncrement();
                return appsInfo;
            }
        }
        this.initForReadableEndpoints();
        GetApplicationsRequest request = ApplicationsRequestBuilder.create().withStateQuery(stateQuery).withStatesQuery(statesQuery).withUserQuery(userQuery).withQueueQuery(this.rm, queueQuery).withLimit(limit).withStartedTimeBegin(startedBegin).withStartedTimeEnd(startedEnd).withFinishTimeBegin(finishBegin).withFinishTimeEnd(finishEnd).withApplicationTypes(applicationTypes).withApplicationTags(applicationTags).withName(name).build();
        try {
            appReports = this.rm.getClientRMService().getApplications(request).getApplicationList();
        }
        catch (YarnException e) {
            LOG.error("Unable to retrieve apps from ClientRMService", (Throwable)e);
            throw new YarnRuntimeException("Unable to retrieve apps from ClientRMService", (Throwable)e);
        }
        ConcurrentMap<ApplicationId, RMApp> apps = this.rm.getRMContext().getRMApps();
        AppsInfo allApps = new AppsInfo();
        for (ApplicationReport report : appReports) {
            RMApp rmapp = (RMApp)apps.get(report.getApplicationId());
            if (rmapp == null) continue;
            if (finalStatusQuery != null && !finalStatusQuery.isEmpty()) {
                FinalApplicationStatus.valueOf((String)finalStatusQuery);
                if (!rmapp.getFinalApplicationStatus().toString().equalsIgnoreCase(finalStatusQuery)) continue;
            }
            DeSelectFields deSelectFields = new DeSelectFields();
            deSelectFields.initFields(unselectedFields);
            boolean allowAccess = this.hasAccess(rmapp, hsr);
            if (this.filterAppsByUser && !allowAccess) continue;
            AppInfo app = new AppInfo(this.rm, rmapp, allowAccess, WebAppUtils.getHttpSchemePrefix((Configuration)this.conf), deSelectFields);
            allApps.add(app);
        }
        if (this.filterInvalidXMLChars && (format = hsr.getHeader("Accept")) != null && format.toLowerCase().contains("application/xml")) {
            for (AppInfo appInfo : allApps.getApps()) {
                appInfo.setNote(RMWebServices.escapeInvalidXMLCharacters(appInfo.getNote()));
            }
        }
        if (this.enableAppsCache) {
            this.appsLRUCache.put((Object)cacheKey, (Object)allApps);
            this.getAppsSuccessTimes.getAndIncrement();
        }
        return allApps;
    }

    @Override
    @GET
    @Path(value="/scheduler/activities")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ActivitiesInfo getActivities(@Context HttpServletRequest hsr, @QueryParam(value="nodeId") String nodeId, @QueryParam(value="groupBy") String groupBy) {
        RMWSConsts.ActivitiesGroupBy activitiesGroupBy;
        this.initForReadableEndpoints();
        ActivitiesManager activitiesManager = this.getActivitiesManager();
        if (null == activitiesManager) {
            return new ActivitiesInfo(ERROR_MSG, nodeId);
        }
        try {
            activitiesGroupBy = this.parseActivitiesGroupBy(groupBy);
        }
        catch (IllegalArgumentException e) {
            return new ActivitiesInfo(e.getMessage(), nodeId);
        }
        AbstractYarnScheduler abstractYarnScheduler = (AbstractYarnScheduler)this.rm.getRMContext().getScheduler();
        List nodeList = abstractYarnScheduler.getNodeTracker().getAllNodes();
        boolean illegalInput = false;
        String errMessage = DEFAULT_RESERVATION_ID;
        if (nodeList.size() == 0) {
            illegalInput = true;
            errMessage = "No node manager running in the cluster";
        } else if (nodeId != null) {
            String hostName = nodeId;
            String portName = DEFAULT_RESERVATION_ID;
            if (nodeId.contains(":")) {
                int index = nodeId.indexOf(":");
                hostName = nodeId.substring(0, index);
                portName = nodeId.substring(index + 1);
            }
            boolean correctNodeId = false;
            for (FiCaSchedulerNode node : nodeList) {
                if ((!portName.equals(DEFAULT_RESERVATION_ID) || !node.getRMNode().getHostName().equals(hostName)) && (portName.equals(DEFAULT_RESERVATION_ID) || !node.getRMNode().getHostName().equals(hostName) || !String.valueOf(node.getRMNode().getCommandPort()).equals(portName))) continue;
                correctNodeId = true;
                nodeId = node.getNodeID().toString();
                break;
            }
            if (!correctNodeId) {
                illegalInput = true;
                errMessage = "Cannot find node manager with given node id";
            }
        }
        if (!illegalInput) {
            activitiesManager.recordNextNodeUpdateActivities(nodeId);
            return activitiesManager.getActivitiesInfo(nodeId, activitiesGroupBy);
        }
        return new ActivitiesInfo(errMessage, nodeId);
    }

    @Override
    @GET
    @Path(value="/scheduler/bulk-activities")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public BulkActivitiesInfo getBulkActivities(@Context HttpServletRequest hsr, @QueryParam(value="groupBy") String groupBy, @QueryParam(value="activitiesCount") @DefaultValue(value="10") int activitiesCount) throws InterruptedException {
        RMWSConsts.ActivitiesGroupBy activitiesGroupBy;
        this.initForReadableEndpoints();
        ActivitiesManager activitiesManager = this.getActivitiesManager();
        if (null == activitiesManager) {
            throw new BadRequestException(ERROR_MSG);
        }
        try {
            activitiesGroupBy = this.parseActivitiesGroupBy(groupBy);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
        AbstractYarnScheduler abstractYarnScheduler = (AbstractYarnScheduler)this.rm.getRMContext().getScheduler();
        List nodeList = abstractYarnScheduler.getNodeTracker().getAllNodes();
        if (nodeList.size() == 0) {
            throw new BadRequestException("No node manager running in the cluster");
        }
        if (activitiesCount <= 0) {
            activitiesCount = Integer.parseInt(DEFAULT_ACTIVITIES_COUNT);
        }
        activitiesCount = Math.min(activitiesCount, 500);
        List<ActivitiesInfo> activitiesList = activitiesManager.recordAndGetBulkActivitiesInfo(activitiesCount, activitiesGroupBy);
        BulkActivitiesInfo bulkActivitiesInfo = new BulkActivitiesInfo();
        bulkActivitiesInfo.addAll(activitiesList);
        return bulkActivitiesInfo;
    }

    private ActivitiesManager getActivitiesManager() {
        ResourceScheduler scheduler = this.rm.getRMContext().getScheduler();
        if (scheduler instanceof AbstractYarnScheduler) {
            AbstractYarnScheduler abstractYarnScheduler = (AbstractYarnScheduler)scheduler;
            ActivitiesManager activitiesManager = abstractYarnScheduler.getActivitiesManager();
            return activitiesManager;
        }
        return null;
    }

    @Override
    @GET
    @Path(value="/scheduler/app-activities/{appid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppActivitiesInfo getAppActivities(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId, @QueryParam(value="maxTime") String time, @QueryParam(value="requestPriorities") Set<String> requestPriorities, @QueryParam(value="allocationRequestIds") Set<String> allocationRequestIds, @QueryParam(value="groupBy") String groupBy, @QueryParam(value="limit") String limit, @QueryParam(value="actions") Set<String> actions, @QueryParam(value="summarize") @DefaultValue(value="false") boolean summarize) {
        Set<Long> parsedAllocationRequestIds;
        Set<Integer> parsedRequestPriorities;
        Set<RMWSConsts.AppActivitiesRequiredAction> requiredActions;
        RMWSConsts.ActivitiesGroupBy activitiesGroupBy;
        this.initForReadableEndpoints();
        ActivitiesManager activitiesManager = this.getActivitiesManager();
        if (null == activitiesManager) {
            return new AppActivitiesInfo(ERROR_MSG, appId);
        }
        if (appId == null) {
            String errMessage = "Must provide an application Id";
            return new AppActivitiesInfo(errMessage, null);
        }
        try {
            activitiesGroupBy = this.parseActivitiesGroupBy(groupBy);
        }
        catch (IllegalArgumentException e2) {
            return new AppActivitiesInfo(e2.getMessage(), appId);
        }
        try {
            requiredActions = this.parseAppActivitiesRequiredActions(this.getFlatSet(actions));
        }
        catch (IllegalArgumentException e3) {
            return new AppActivitiesInfo(e3.getMessage(), appId);
        }
        try {
            parsedRequestPriorities = this.getFlatSet(requestPriorities).stream().map(e -> Integer.valueOf(e)).collect(Collectors.toSet());
        }
        catch (NumberFormatException e4) {
            return new AppActivitiesInfo("request priorities must be integers!", appId);
        }
        try {
            parsedAllocationRequestIds = this.getFlatSet(allocationRequestIds).stream().map(e -> Long.valueOf(e)).collect(Collectors.toSet());
        }
        catch (NumberFormatException e5) {
            return new AppActivitiesInfo("allocation request Ids must be integers!", appId);
        }
        int limitNum = -1;
        if (limit != null) {
            try {
                limitNum = Integer.parseInt(limit);
                if (limitNum <= 0) {
                    return new AppActivitiesInfo("limit must be greater than 0!", appId);
                }
            }
            catch (NumberFormatException e6) {
                return new AppActivitiesInfo("limit must be integer!", appId);
            }
        }
        double maxTime = 3.0;
        if (time != null) {
            maxTime = time.contains(".") ? Double.parseDouble(time) : Double.parseDouble(time + ".0");
        }
        try {
            ApplicationId applicationId = ApplicationId.fromString((String)appId);
            if (requiredActions.contains((Object)RMWSConsts.AppActivitiesRequiredAction.REFRESH)) {
                activitiesManager.turnOnAppActivitiesRecording(applicationId, maxTime);
            }
            if (requiredActions.contains((Object)RMWSConsts.AppActivitiesRequiredAction.GET)) {
                AppActivitiesInfo appActivitiesInfo = activitiesManager.getAppActivitiesInfo(applicationId, parsedRequestPriorities, parsedAllocationRequestIds, activitiesGroupBy, limitNum, summarize, maxTime);
                return appActivitiesInfo;
            }
            return new AppActivitiesInfo("Successfully received " + (actions.size() == 1 ? "action: " : "actions: ") + StringUtils.join((char)',', actions), appId);
        }
        catch (Exception e7) {
            String errMessage = "Cannot find application with given appId";
            LOG.error(errMessage, (Throwable)e7);
            return new AppActivitiesInfo(errMessage, appId);
        }
    }

    private Set<String> getFlatSet(Set<String> set) {
        if (set == null) {
            return null;
        }
        return set.stream().flatMap(e -> Arrays.asList(e.split(",")).stream()).collect(Collectors.toSet());
    }

    private Set<RMWSConsts.AppActivitiesRequiredAction> parseAppActivitiesRequiredActions(Set<String> actions) {
        HashSet<RMWSConsts.AppActivitiesRequiredAction> requiredActions = new HashSet<RMWSConsts.AppActivitiesRequiredAction>();
        if (actions == null || actions.isEmpty()) {
            requiredActions.add(RMWSConsts.AppActivitiesRequiredAction.REFRESH);
            requiredActions.add(RMWSConsts.AppActivitiesRequiredAction.GET);
        } else {
            for (String action : actions) {
                if (!EnumUtils.isValidEnum(RMWSConsts.AppActivitiesRequiredAction.class, (String)action.toUpperCase())) {
                    String errMessage = "Got invalid action: " + action + ", valid actions: " + Arrays.asList(RMWSConsts.AppActivitiesRequiredAction.values());
                    throw new IllegalArgumentException(errMessage);
                }
                requiredActions.add(RMWSConsts.AppActivitiesRequiredAction.valueOf(action.toUpperCase()));
            }
        }
        return requiredActions;
    }

    private RMWSConsts.ActivitiesGroupBy parseActivitiesGroupBy(String groupBy) {
        if (groupBy != null) {
            if (!EnumUtils.isValidEnum(RMWSConsts.ActivitiesGroupBy.class, (String)groupBy.toUpperCase())) {
                String errMessage = "Got invalid groupBy: " + groupBy + ", valid groupBy types: " + Arrays.asList(RMWSConsts.ActivitiesGroupBy.values());
                throw new IllegalArgumentException(errMessage);
            }
            return RMWSConsts.ActivitiesGroupBy.valueOf(groupBy.toUpperCase());
        }
        return null;
    }

    @Override
    @GET
    @Path(value="/appstatistics")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ApplicationStatisticsInfo getAppStatistics(@Context HttpServletRequest hsr, @QueryParam(value="states") Set<String> stateQueries, @QueryParam(value="applicationTypes") Set<String> typeQueries) {
        this.initForReadableEndpoints();
        Set<String> states = RMWebServices.parseQueries(stateQueries, true);
        Set<String> types = RMWebServices.parseQueries(typeQueries, false);
        if (types.size() == 0) {
            types.add("*");
        } else if (types.size() != 1) {
            throw new BadRequestException("# of applicationTypes = " + types.size() + ", we temporarily support at most one applicationType");
        }
        if (states.size() == 0) {
            for (YarnApplicationState state : YarnApplicationState.values()) {
                states.add(StringUtils.toLowerCase((String)state.toString()));
            }
        }
        Map<YarnApplicationState, Map<String, Long>> scoreboard = RMWebServices.buildScoreboard(states, types);
        ConcurrentMap<ApplicationId, RMApp> apps = this.rm.getRMContext().getRMApps();
        for (RMApp rmapp : apps.values()) {
            YarnApplicationState state = rmapp.createApplicationState();
            String type = StringUtils.toLowerCase((String)rmapp.getApplicationType().trim());
            if (!states.contains(StringUtils.toLowerCase((String)state.toString()))) continue;
            if (types.contains("*")) {
                RMWebServices.countApp(scoreboard, state, "*");
                continue;
            }
            if (!types.contains(type)) continue;
            RMWebServices.countApp(scoreboard, state, type);
        }
        ApplicationStatisticsInfo appStatInfo = new ApplicationStatisticsInfo();
        for (Map.Entry<YarnApplicationState, Map<String, Long>> partScoreboard : scoreboard.entrySet()) {
            for (Map.Entry<String, Long> statEntry : partScoreboard.getValue().entrySet()) {
                StatisticsItemInfo statItem = new StatisticsItemInfo(partScoreboard.getKey(), statEntry.getKey(), statEntry.getValue());
                appStatInfo.add(statItem);
            }
        }
        return appStatInfo;
    }

    private static Map<YarnApplicationState, Map<String, Long>> buildScoreboard(Set<String> states, Set<String> types) {
        HashMap<YarnApplicationState, Map<String, Long>> scoreboard = new HashMap<YarnApplicationState, Map<String, Long>>();
        assert (!states.isEmpty());
        for (String state : states) {
            HashMap<String, Long> partScoreboard = new HashMap<String, Long>();
            scoreboard.put(YarnApplicationState.valueOf((String)StringUtils.toUpperCase((String)state)), partScoreboard);
            for (String type : types) {
                partScoreboard.put(type, 0L);
            }
        }
        return scoreboard;
    }

    private static void countApp(Map<YarnApplicationState, Map<String, Long>> scoreboard, YarnApplicationState state, String type) {
        Map<String, Long> partScoreboard = scoreboard.get(state);
        Long count = partScoreboard.get(type);
        partScoreboard.put(type, count + 1L);
    }

    @Override
    @GET
    @Path(value="/apps/{appid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppInfo getApp(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId, @QueryParam(value="deSelects") Set<String> unselectedFields) {
        String format;
        this.initForReadableEndpoints();
        ApplicationId id = WebAppUtils.parseApplicationId((RecordFactory)recordFactory, (String)appId);
        RMApp app = (RMApp)this.rm.getRMContext().getRMApps().get(id);
        if (app == null) {
            throw new NotFoundException("app with id: " + appId + " not found");
        }
        DeSelectFields deSelectFields = new DeSelectFields();
        deSelectFields.initFields(unselectedFields);
        AppInfo appInfo = new AppInfo(this.rm, app, this.hasAccess(app, hsr), hsr.getScheme() + "://", deSelectFields);
        if (this.filterInvalidXMLChars && (format = hsr.getHeader("Accept")) != null && format.toLowerCase().contains("application/xml")) {
            appInfo.setNote(RMWebServices.escapeInvalidXMLCharacters(appInfo.getNote()));
        }
        return appInfo;
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/appattempts")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppAttemptsInfo getAppAttempts(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) {
        this.initForReadableEndpoints();
        ApplicationId id = WebAppUtils.parseApplicationId((RecordFactory)recordFactory, (String)appId);
        RMApp app = (RMApp)this.rm.getRMContext().getRMApps().get(id);
        if (app == null) {
            throw new NotFoundException("app with id: " + appId + " not found");
        }
        AppAttemptsInfo appAttemptsInfo = new AppAttemptsInfo();
        for (RMAppAttempt attempt : app.getAppAttempts().values()) {
            AppAttemptInfo attemptInfo = new AppAttemptInfo(this.rm, attempt, this.hasAccess(app, hsr), app.getUser(), hsr.getScheme() + "://");
            appAttemptsInfo.add(attemptInfo);
        }
        return appAttemptsInfo;
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo getAppAttempt(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.initForReadableEndpoints(res);
        return super.getAppAttempt(req, res, appId, appAttemptId);
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainersInfo getContainers(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.initForReadableEndpoints(res);
        return super.getContainers(req, res, appId, appAttemptId);
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers/{containerid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainerInfo getContainer(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId, @PathParam(value="containerid") String containerId) {
        this.initForReadableEndpoints(res);
        return super.getContainer(req, res, appId, appAttemptId, containerId);
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/state")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppState getAppState(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException {
        this.initForReadableEndpoints();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        String userName = DEFAULT_RESERVATION_ID;
        if (callerUGI != null) {
            userName = callerUGI.getUserName();
        }
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Get Application State", "UNKNOWN", "RMWebService", "Trying to get state of an absent application " + appId);
            throw e;
        }
        AppState ret = new AppState();
        ret.setState(app.getState().toString());
        return ret;
    }

    @Override
    @PUT
    @Path(value="/apps/{appid}/state")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public Response updateAppState(AppState targetState, @Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        String userName = callerUGI.getUserName();
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Kill Application Request", "UNKNOWN", "RMWebService", "Trying to kill an absent application " + appId);
            throw e;
        }
        if (!app.getState().toString().equals(targetState.getState())) {
            if (targetState.getState().equals(YarnApplicationState.KILLED.toString())) {
                return this.killApp(app, callerUGI, hsr, targetState.getDiagnostics());
            }
            throw new BadRequestException("Only '" + YarnApplicationState.KILLED.toString() + "' is allowed as a target state.");
        }
        AppState ret = new AppState();
        ret.setState(app.getState().toString());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ret).build();
    }

    @Override
    @GET
    @Path(value="/get-node-to-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodeToLabelsInfo getNodeToLabels(@Context HttpServletRequest hsr) throws IOException {
        this.initForReadableEndpoints();
        NodeToLabelsInfo ntl = new NodeToLabelsInfo();
        HashMap<String, NodeLabelsInfo> ntlMap = ntl.getNodeToLabels();
        Map nodeIdToLabels = this.rm.getRMContext().getNodeLabelManager().getNodeLabelsInfo();
        for (Map.Entry nitle : nodeIdToLabels.entrySet()) {
            ArrayList<NodeLabel> labels = new ArrayList<NodeLabel>((Collection)nitle.getValue());
            ntlMap.put(((NodeId)nitle.getKey()).toString(), new NodeLabelsInfo((List<NodeLabel>)labels));
        }
        return ntl;
    }

    @Override
    @GET
    @Path(value="/label-mappings")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public LabelsToNodesInfo getLabelsToNodes(@QueryParam(value="labels") Set<String> labels) throws IOException {
        this.initForReadableEndpoints();
        LabelsToNodesInfo lts = new LabelsToNodesInfo();
        Map<NodeLabelInfo, NodeIDsInfo> ltsMap = lts.getLabelsToNodes();
        Map labelsToNodeId = null;
        labelsToNodeId = labels == null || labels.size() == 0 ? this.rm.getRMContext().getNodeLabelManager().getLabelsInfoToNodes() : this.rm.getRMContext().getNodeLabelManager().getLabelsInfoToNodes(labels);
        for (Map.Entry entry : labelsToNodeId.entrySet()) {
            ArrayList<String> nodeIdStrList = new ArrayList<String>();
            for (NodeId nodeId : (Set)entry.getValue()) {
                nodeIdStrList.add(nodeId.toString());
            }
            Resource resource = this.rm.getRMContext().getNodeLabelManager().getResourceByLabel(((NodeLabel)entry.getKey()).getName(), Resources.none());
            ltsMap.put(new NodeLabelInfo((NodeLabel)entry.getKey()), new NodeIDsInfo(nodeIdStrList, resource));
        }
        return lts;
    }

    @Override
    @POST
    @Path(value="/replace-node-to-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response replaceLabelsOnNodes(NodeToLabelsEntryList newNodeToLabels, @Context HttpServletRequest hsr) throws IOException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        HashMap<NodeId, Set<String>> nodeIdToLabels = new HashMap<NodeId, Set<String>>();
        for (NodeToLabelsEntry nitle : newNodeToLabels.getNodeToLabels()) {
            nodeIdToLabels.put(ConverterUtils.toNodeIdWithDefaultPort((String)nitle.getNodeId()), new HashSet<String>(nitle.getNodeLabels()));
        }
        return this.replaceLabelsOnNode(nodeIdToLabels, hsr, "/replace-node-to-labels");
    }

    @Override
    @POST
    @Path(value="/nodes/{nodeId}/replace-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response replaceLabelsOnNode(@QueryParam(value="labels") Set<String> newNodeLabelsName, @Context HttpServletRequest hsr, @PathParam(value="nodeId") String nodeId) throws Exception {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        NodeId nid = ConverterUtils.toNodeIdWithDefaultPort((String)nodeId);
        HashMap<NodeId, Set<String>> newLabelsForNode = new HashMap<NodeId, Set<String>>();
        newLabelsForNode.put(nid, new HashSet<String>(newNodeLabelsName));
        return this.replaceLabelsOnNode(newLabelsForNode, hsr, "/nodes/nodeid/replace-labels");
    }

    private Response replaceLabelsOnNode(Map<NodeId, Set<String>> newLabelsForNode, HttpServletRequest hsr, String operation) throws IOException {
        NodeLabelsUtils.verifyCentralizedNodeLabelConfEnabled("replaceLabelsOnNode", this.isCentralizedNodeLabelConfiguration);
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            String msg = "Unable to obtain user name, user not authenticated for post to ..." + operation;
            throw new AuthorizationException(msg);
        }
        if (!this.rm.getRMContext().getNodeLabelManager().checkAccess(callerUGI)) {
            String msg = "User " + callerUGI.getShortUserName() + " not authorized for post to ..." + operation;
            throw new AuthorizationException(msg);
        }
        try {
            this.rm.getRMContext().getNodeLabelManager().replaceLabelsOnNode(newLabelsForNode);
        }
        catch (IOException e) {
            throw new BadRequestException((Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    @GET
    @Path(value="/get-node-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodeLabelsInfo getClusterNodeLabels(@Context HttpServletRequest hsr) throws IOException {
        this.initForReadableEndpoints();
        List nodeLabels = this.rm.getRMContext().getNodeLabelManager().getClusterNodeLabels();
        ArrayList<NodeLabelInfo> nodeLabelsInfo = new ArrayList<NodeLabelInfo>();
        for (NodeLabel label : nodeLabels) {
            Resource resource = this.rm.getRMContext().getNodeLabelManager().getResourceByLabel(label.getName(), Resources.none());
            PartitionInfo partitionInfo = new PartitionInfo(new ResourceInfo(resource));
            nodeLabelsInfo.add(new NodeLabelInfo(label, partitionInfo));
        }
        return new NodeLabelsInfo(nodeLabelsInfo);
    }

    @Override
    @GET
    @Path(value="/get-rm-node-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodeLabelsInfo getRMNodeLabels(@Context HttpServletRequest hsr) throws IOException {
        this.initForReadableEndpoints();
        RMNodeLabelsManager nlm = this.rm.getRMContext().getNodeLabelManager();
        ArrayList<NodeLabelInfo> nodeLabelsInfo = new ArrayList<NodeLabelInfo>();
        for (RMNodeLabel info : nlm.pullRMNodeLabelsInfo()) {
            String labelName = info.getLabelName().isEmpty() ? "<DEFAULT_PARTITION>" : info.getLabelName();
            int activeNMs = info.getNumActiveNMs();
            PartitionInfo partitionInfo = new PartitionInfo(new ResourceInfo(info.getResource()));
            NodeLabel nodeLabel = NodeLabel.newInstance((String)labelName, (boolean)info.getIsExclusive());
            NodeLabelInfo nodeLabelInfo = new NodeLabelInfo(nodeLabel, partitionInfo);
            nodeLabelInfo.setActiveNMs(activeNMs);
            nodeLabelsInfo.add(nodeLabelInfo);
        }
        return new NodeLabelsInfo(nodeLabelsInfo);
    }

    @Override
    @POST
    @Path(value="/add-node-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response addToClusterNodeLabels(NodeLabelsInfo newNodeLabels, @Context HttpServletRequest hsr) throws Exception {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        if (!this.rm.getRMContext().getNodeLabelManager().checkAccess(callerUGI)) {
            String msg = "User " + callerUGI.getShortUserName() + " not authorized for post to .../add-node-labels ";
            throw new AuthorizationException(msg);
        }
        try {
            this.rm.getRMContext().getNodeLabelManager().addToCluserNodeLabels(newNodeLabels.getNodeLabels());
        }
        catch (IOException e) {
            throw new BadRequestException((Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    @POST
    @Path(value="/remove-node-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response removeFromClusterNodeLabels(@QueryParam(value="labels") Set<String> oldNodeLabels, @Context HttpServletRequest hsr) throws Exception {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        if (!this.rm.getRMContext().getNodeLabelManager().checkAccess(callerUGI)) {
            String msg = "User " + callerUGI.getShortUserName() + " not authorized for post to .../remove-node-labels ";
            throw new AuthorizationException(msg);
        }
        try {
            this.rm.getRMContext().getNodeLabelManager().removeFromClusterNodeLabels(new HashSet<String>(oldNodeLabels));
        }
        catch (IOException e) {
            throw new BadRequestException((Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    @GET
    @Path(value="/nodes/{nodeId}/get-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodeLabelsInfo getLabelsOnNode(@Context HttpServletRequest hsr, @PathParam(value="nodeId") String nodeId) throws IOException {
        this.initForReadableEndpoints();
        NodeId nid = ConverterUtils.toNodeIdWithDefaultPort((String)nodeId);
        ArrayList<NodeLabel> labels = new ArrayList<NodeLabel>(this.rm.getRMContext().getNodeLabelManager().getLabelsInfoByNode(nid));
        return new NodeLabelsInfo((List<NodeLabel>)labels);
    }

    protected Response killApp(RMApp app, UserGroupInformation callerUGI, HttpServletRequest hsr, final String diagnostic) throws IOException, InterruptedException {
        if (app == null) {
            throw new IllegalArgumentException("app cannot be null");
        }
        String userName = callerUGI.getUserName();
        final ApplicationId appid = app.getApplicationId();
        KillApplicationResponse resp = null;
        try {
            resp = (KillApplicationResponse)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KillApplicationResponse>(){

                @Override
                public KillApplicationResponse run() throws IOException, YarnException {
                    KillApplicationRequest req = KillApplicationRequest.newInstance((ApplicationId)appid);
                    if (diagnostic != null) {
                        req.setDiagnostics(diagnostic);
                    }
                    return RMWebServices.this.rm.getClientRMService().forceKillApplication(req);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                YarnException ye = (YarnException)ue.getCause();
                if (ye.getCause() instanceof AccessControlException) {
                    String appId = app.getApplicationId().toString();
                    String msg = "Unauthorized attempt to kill appid " + appId + " by remote user " + userName;
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
                }
                throw ue;
            }
            throw ue;
        }
        AppState ret = new AppState();
        ret.setState(app.getState().toString());
        if (!resp.getIsKillCompleted()) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)ret).header("Location", (Object)hsr.getRequestURL()).build();
        }
        RMAuditLogger.logSuccess(userName, "Kill Application Request", "RMWebService", app.getApplicationId());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ret).build();
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/priority")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppPriority getAppPriority(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException {
        this.initForReadableEndpoints();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        String userName = "UNKNOWN-USER";
        if (callerUGI != null) {
            userName = callerUGI.getUserName();
        }
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Get Application Priority", "UNKNOWN", "RMWebService", "Trying to get priority of an absent application " + appId);
            throw e;
        }
        AppPriority ret = new AppPriority();
        ret.setPriority(app.getApplicationPriority().getPriority());
        return ret;
    }

    @Override
    @PUT
    @Path(value="/apps/{appid}/priority")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public Response updateApplicationPriority(AppPriority targetPriority, @Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        if (targetPriority == null) {
            throw new YarnException("Target Priority cannot be null");
        }
        String userName = callerUGI.getUserName();
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Update Application Priority", "UNKNOWN", "RMWebService", "Trying to update priority an absent application " + appId);
            throw e;
        }
        Priority priority = app.getApplicationPriority();
        if (priority == null || priority.getPriority() != targetPriority.getPriority()) {
            return this.modifyApplicationPriority(app, callerUGI, targetPriority.getPriority());
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)targetPriority).build();
    }

    private Response modifyApplicationPriority(final RMApp app, UserGroupInformation callerUGI, final int appPriority) throws IOException, InterruptedException {
        String userName = callerUGI.getUserName();
        try {
            callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, YarnException {
                    Priority priority = Priority.newInstance((int)appPriority);
                    UpdateApplicationPriorityRequest request = UpdateApplicationPriorityRequest.newInstance((ApplicationId)app.getApplicationId(), (Priority)priority);
                    RMWebServices.this.rm.getClientRMService().updateApplicationPriority(request);
                    return null;
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                YarnException ye = (YarnException)ue.getCause();
                if (ye.getCause() instanceof AccessControlException) {
                    String appId = app.getApplicationId().toString();
                    String msg = "Unauthorized attempt to change priority of appid " + appId + " by remote user " + userName;
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
                }
                if (ye.getMessage().startsWith("Application in") && ye.getMessage().endsWith("state cannot be update priority.")) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ye.getMessage()).build();
                }
                throw ue;
            }
            throw ue;
        }
        AppPriority ret = new AppPriority(app.getApplicationPriority().getPriority());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ret).build();
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/queue")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppQueue getAppQueue(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException {
        this.initForReadableEndpoints();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        String userName = "UNKNOWN-USER";
        if (callerUGI != null) {
            userName = callerUGI.getUserName();
        }
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Get Application Queue", "UNKNOWN", "RMWebService", "Trying to get queue of an absent application " + appId);
            throw e;
        }
        AppQueue ret = new AppQueue();
        ret.setQueue(app.getQueue());
        return ret;
    }

    @Override
    @PUT
    @Path(value="/apps/{appid}/queue")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public Response updateAppQueue(AppQueue targetQueue, @Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        String userName = callerUGI.getUserName();
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Move Application Request", "UNKNOWN", "RMWebService", "Trying to move an absent application " + appId);
            throw e;
        }
        if (!app.getQueue().equals(targetQueue.getQueue())) {
            return this.moveApp(app, callerUGI, targetQueue.getQueue());
        }
        AppQueue ret = new AppQueue();
        ret.setQueue(app.getQueue());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ret).build();
    }

    protected Response moveApp(RMApp app, UserGroupInformation callerUGI, String targetQueue) throws IOException, InterruptedException {
        if (app == null) {
            throw new IllegalArgumentException("app cannot be null");
        }
        String userName = callerUGI.getUserName();
        final ApplicationId appid = app.getApplicationId();
        final String reqTargetQueue = targetQueue;
        try {
            callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, YarnException {
                    MoveApplicationAcrossQueuesRequest req = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)appid, (String)reqTargetQueue);
                    RMWebServices.this.rm.getClientRMService().moveApplicationAcrossQueues(req);
                    return null;
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                YarnException ye = (YarnException)ue.getCause();
                if (ye.getCause() instanceof AccessControlException) {
                    String appId = app.getApplicationId().toString();
                    String msg = "Unauthorized attempt to move appid " + appId + " by remote user " + userName;
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
                }
                if (ye.getMessage().startsWith("App in") && ye.getMessage().endsWith("state cannot be moved.")) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ye.getMessage()).build();
                }
                throw ue;
            }
            throw ue;
        }
        AppQueue ret = new AppQueue();
        ret.setQueue(app.getQueue());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ret).build();
    }

    private RMApp getRMAppForAppId(String appId) {
        ApplicationId id = WebAppUtils.parseApplicationId((RecordFactory)recordFactory, (String)appId);
        RMApp app = (RMApp)this.rm.getRMContext().getRMApps().get(id);
        if (app == null) {
            throw new NotFoundException("app with id: " + appId + " not found");
        }
        return app;
    }

    private UserGroupInformation getCallerUserGroupInformation(HttpServletRequest hsr, boolean usePrincipal) {
        String remoteUser = hsr.getRemoteUser();
        if (usePrincipal) {
            Principal princ = hsr.getUserPrincipal();
            remoteUser = princ == null ? null : princ.getName();
        }
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return callerUGI;
    }

    private boolean isStaticUser(UserGroupInformation callerUGI) {
        String staticUser = this.conf.get("hadoop.http.staticuser.user", "dr.who");
        return staticUser.equals(callerUGI.getUserName());
    }

    @Override
    @POST
    @Path(value="/apps/new-application")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response createNewApplication(@Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        if (!this.enableRestAppSubmissions) {
            String msg = "App submission via REST is disabled.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
        }
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        NewApplication appId = this.createNewApplication();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)appId).build();
    }

    @Override
    @POST
    @Path(value="/apps")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public Response submitApplication(ApplicationSubmissionContextInfo newApp, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        if (!this.enableRestAppSubmissions) {
            String msg = "App submission via REST is disabled.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
        }
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        ApplicationSubmissionContext appContext = RMWebAppUtil.createAppSubmissionContext(newApp, this.conf);
        final SubmitApplicationRequest req = SubmitApplicationRequest.newInstance((ApplicationSubmissionContext)appContext);
        try {
            callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SubmitApplicationResponse>(){

                @Override
                public SubmitApplicationResponse run() throws IOException, YarnException {
                    return RMWebServices.this.rm.getClientRMService().submitApplication(req);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                throw new BadRequestException(ue.getCause().getMessage());
            }
            LOG.info("Submit app request failed", (Throwable)ue);
            throw ue;
        }
        String url = hsr.getRequestURL() + "/" + newApp.getApplicationId();
        return Response.status((Response.Status)Response.Status.ACCEPTED).header("Location", (Object)url).build();
    }

    private NewApplication createNewApplication() {
        GetNewApplicationResponse resp;
        GetNewApplicationRequest req = (GetNewApplicationRequest)recordFactory.newRecordInstance(GetNewApplicationRequest.class);
        try {
            resp = this.rm.getClientRMService().getNewApplication(req);
        }
        catch (YarnException e) {
            String msg = "Unable to create new app from RM web service";
            LOG.error(msg, (Throwable)e);
            throw new YarnRuntimeException(msg, (Throwable)e);
        }
        NewApplication appId = new NewApplication(resp.getApplicationId().toString(), new ResourceInfo(resp.getMaximumResourceCapability()));
        return appId;
    }

    private void createKerberosUserGroupInformation(HttpServletRequest hsr, UserGroupInformation callerUGI) throws AuthorizationException, YarnException {
        String authType = hsr.getAuthType();
        if (!"kerberos".equalsIgnoreCase(authType)) {
            String msg = "Delegation token operations can only be carried out on a Kerberos authenticated channel. Expected auth type is kerberos, got type " + authType;
            throw new YarnException(msg);
        }
        if (hsr.getAttribute("hadoop.security.delegation-token.ugi") != null) {
            String msg = "Delegation token operations cannot be carried out using delegation token authentication.";
            throw new YarnException(msg);
        }
    }

    @Override
    @POST
    @Path(value="/delegation-token")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public Response postDelegationToken(DelegationToken tokenData, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        try {
            this.createKerberosUserGroupInformation(hsr, callerUGI);
            callerUGI.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        }
        catch (YarnException ye) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ye.getMessage()).build();
        }
        return this.createDelegationToken(tokenData, hsr, callerUGI);
    }

    @Override
    @POST
    @Path(value="/delegation-token/expiration")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public Response postDelegationTokenExpiration(@Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        try {
            this.createKerberosUserGroupInformation(hsr, callerUGI);
            callerUGI.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        }
        catch (YarnException ye) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ye.getMessage()).build();
        }
        DelegationToken requestToken = new DelegationToken();
        requestToken.setToken(this.extractToken(hsr).encodeToUrlString());
        return this.renewDelegationToken(requestToken, hsr, callerUGI);
    }

    private Response createDelegationToken(DelegationToken tokenData, HttpServletRequest hsr, UserGroupInformation callerUGI) throws AuthorizationException, IOException, InterruptedException, Exception {
        GetDelegationTokenResponse resp;
        final String renewer = tokenData.getRenewer();
        try {
            resp = (GetDelegationTokenResponse)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<GetDelegationTokenResponse>(){

                @Override
                public GetDelegationTokenResponse run() throws IOException, YarnException {
                    GetDelegationTokenRequest createReq = GetDelegationTokenRequest.newInstance((String)renewer);
                    return RMWebServices.this.rm.getClientRMService().getDelegationToken(createReq);
                }
            });
        }
        catch (Exception e) {
            LOG.info("Create delegation token request failed", (Throwable)e);
            throw e;
        }
        Token tk = new Token(resp.getRMDelegationToken().getIdentifier().array(), resp.getRMDelegationToken().getPassword().array(), new Text(resp.getRMDelegationToken().getKind()), new Text(resp.getRMDelegationToken().getService()));
        RMDelegationTokenIdentifier identifier = (RMDelegationTokenIdentifier)tk.decodeIdentifier();
        long currentExpiration = this.rm.getRMContext().getRMDelegationTokenSecretManager().getRenewDate(identifier);
        DelegationToken respToken = new DelegationToken(tk.encodeToUrlString(), renewer, identifier.getOwner().toString(), tk.getKind().toString(), currentExpiration, identifier.getMaxDate());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)respToken).build();
    }

    private Response renewDelegationToken(DelegationToken tokenData, HttpServletRequest hsr, UserGroupInformation callerUGI) throws AuthorizationException, IOException, InterruptedException, Exception {
        RenewDelegationTokenResponse resp;
        Token<RMDelegationTokenIdentifier> token = this.extractToken(tokenData.getToken());
        org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken(token.getIdentifier(), token.getKind().toString(), token.getPassword(), token.getService().toString());
        final RenewDelegationTokenRequest req = RenewDelegationTokenRequest.newInstance((org.apache.hadoop.yarn.api.records.Token)dToken);
        try {
            resp = (RenewDelegationTokenResponse)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RenewDelegationTokenResponse>(){

                @Override
                public RenewDelegationTokenResponse run() throws YarnException {
                    return RMWebServices.this.rm.getClientRMService().renewDelegationToken(req);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                if (ue.getCause().getCause() instanceof SecretManager.InvalidToken) {
                    throw new BadRequestException(ue.getCause().getCause().getMessage());
                }
                if (ue.getCause().getCause() instanceof org.apache.hadoop.security.AccessControlException) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ue.getCause().getCause().getMessage()).build();
                }
                LOG.info("Renew delegation token request failed", (Throwable)ue);
                throw ue;
            }
            LOG.info("Renew delegation token request failed", (Throwable)ue);
            throw ue;
        }
        catch (Exception e) {
            LOG.info("Renew delegation token request failed", (Throwable)e);
            throw e;
        }
        long renewTime = resp.getNextExpirationTime();
        DelegationToken respToken = new DelegationToken();
        respToken.setNextExpirationTime(renewTime);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)respToken).build();
    }

    @Override
    @DELETE
    @Path(value="/delegation-token")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response cancelDelegationToken(@Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        try {
            this.createKerberosUserGroupInformation(hsr, callerUGI);
            callerUGI.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        }
        catch (YarnException ye) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ye.getMessage()).build();
        }
        Token<RMDelegationTokenIdentifier> token = this.extractToken(hsr);
        org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken(token.getIdentifier(), token.getKind().toString(), token.getPassword(), token.getService().toString());
        final CancelDelegationTokenRequest req = CancelDelegationTokenRequest.newInstance((org.apache.hadoop.yarn.api.records.Token)dToken);
        try {
            callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<CancelDelegationTokenResponse>(){

                @Override
                public CancelDelegationTokenResponse run() throws IOException, YarnException {
                    return RMWebServices.this.rm.getClientRMService().cancelDelegationToken(req);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                if (ue.getCause().getCause() instanceof SecretManager.InvalidToken) {
                    throw new BadRequestException(ue.getCause().getCause().getMessage());
                }
                if (ue.getCause().getCause() instanceof org.apache.hadoop.security.AccessControlException) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ue.getCause().getCause().getMessage()).build();
                }
                LOG.info("Renew delegation token request failed", (Throwable)ue);
                throw ue;
            }
            LOG.info("Renew delegation token request failed", (Throwable)ue);
            throw ue;
        }
        catch (Exception e) {
            LOG.info("Renew delegation token request failed", (Throwable)e);
            throw e;
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private Token<RMDelegationTokenIdentifier> extractToken(HttpServletRequest request) {
        String encodedToken = request.getHeader(DELEGATION_TOKEN_HEADER);
        if (encodedToken == null) {
            String msg = "Header 'Hadoop-YARN-RM-Delegation-Token' containing encoded token not found";
            throw new BadRequestException(msg);
        }
        return this.extractToken(encodedToken);
    }

    private Token<RMDelegationTokenIdentifier> extractToken(String encodedToken) {
        Token token = new Token();
        try {
            token.decodeFromUrlString(encodedToken);
        }
        catch (Exception ie) {
            String msg = "Could not decode encoded token";
            throw new BadRequestException(msg);
        }
        return token;
    }

    @Override
    @POST
    @Path(value="/reservation/new-reservation")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response createNewReservation(@Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        NewReservation reservationId = this.createNewReservation();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)reservationId).build();
    }

    private NewReservation createNewReservation() throws IOException {
        GetNewReservationResponse resp;
        GetNewReservationRequest req = (GetNewReservationRequest)recordFactory.newRecordInstance(GetNewReservationRequest.class);
        try {
            resp = this.rm.getClientRMService().getNewReservation(req);
        }
        catch (YarnException e) {
            String msg = "Unable to create new reservation from RM web service";
            LOG.error(msg, (Throwable)e);
            throw new YarnRuntimeException(msg, (Throwable)e);
        }
        NewReservation reservationId = new NewReservation(resp.getReservationId().toString());
        return reservationId;
    }

    @Override
    @POST
    @Path(value="/reservation/submit")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public Response submitReservation(ReservationSubmissionRequestInfo resContext, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        final ReservationSubmissionRequest reservation = this.createReservationSubmissionRequest(resContext);
        try {
            callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ReservationSubmissionResponse>(){

                @Override
                public ReservationSubmissionResponse run() throws IOException, YarnException {
                    return RMWebServices.this.rm.getClientRMService().submitReservation(reservation);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                throw new BadRequestException(ue.getCause().getMessage());
            }
            LOG.info("Submit reservation request failed", (Throwable)ue);
            throw ue;
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    private ReservationSubmissionRequest createReservationSubmissionRequest(ReservationSubmissionRequestInfo resContext) throws IOException {
        if (resContext == null) {
            throw new BadRequestException("Input ReservationSubmissionContext should not be null");
        }
        ReservationDefinitionInfo resInfo = resContext.getReservationDefinition();
        if (resInfo == null) {
            throw new BadRequestException("Input ReservationDefinition should not be null");
        }
        ReservationRequestsInfo resReqsInfo = resInfo.getReservationRequests();
        if (resReqsInfo == null || resReqsInfo.getReservationRequest() == null || resReqsInfo.getReservationRequest().size() == 0) {
            throw new BadRequestException("The ReservationDefinition should contain at least one ReservationRequest");
        }
        ReservationRequestInterpreter[] values = ReservationRequestInterpreter.values();
        ReservationRequestInterpreter resInt = values[resReqsInfo.getReservationRequestsInterpreter()];
        ArrayList<ReservationRequest> list = new ArrayList<ReservationRequest>();
        for (ReservationRequestInfo resReqInfo : resReqsInfo.getReservationRequest()) {
            ResourceInfo rInfo = resReqInfo.getCapability();
            Resource capability = Resource.newInstance((long)rInfo.getMemorySize(), (int)rInfo.getvCores());
            int numContainers = resReqInfo.getNumContainers();
            int minConcurrency = resReqInfo.getMinConcurrency();
            long duration = resReqInfo.getDuration();
            ReservationRequest rr = ReservationRequest.newInstance((Resource)capability, (int)numContainers, (int)minConcurrency, (long)duration);
            list.add(rr);
        }
        ReservationRequests reqs = ReservationRequests.newInstance(list, (ReservationRequestInterpreter)resInt);
        ReservationDefinition rDef = ReservationDefinition.newInstance((long)resInfo.getArrival(), (long)resInfo.getDeadline(), (ReservationRequests)reqs, (String)resInfo.getReservationName(), (String)resInfo.getRecurrenceExpression(), (Priority)Priority.newInstance((int)resInfo.getPriority()));
        ReservationId reservationId = ReservationId.parseReservationId((String)resContext.getReservationId());
        ReservationSubmissionRequest request = ReservationSubmissionRequest.newInstance((ReservationDefinition)rDef, (String)resContext.getQueue(), (ReservationId)reservationId);
        return request;
    }

    @Override
    @POST
    @Path(value="/reservation/update")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public Response updateReservation(ReservationUpdateRequestInfo resContext, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        ReservationUpdateResponseInfo resRespInfo;
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        final ReservationUpdateRequest reservation = this.createReservationUpdateRequest(resContext);
        try {
            resRespInfo = (ReservationUpdateResponseInfo)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ReservationUpdateResponseInfo>(){

                @Override
                public ReservationUpdateResponseInfo run() throws IOException, YarnException {
                    RMWebServices.this.rm.getClientRMService().updateReservation(reservation);
                    return new ReservationUpdateResponseInfo();
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                throw new BadRequestException(ue.getCause().getMessage());
            }
            LOG.info("Update reservation request failed", (Throwable)ue);
            throw ue;
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)resRespInfo).build();
    }

    private ReservationUpdateRequest createReservationUpdateRequest(ReservationUpdateRequestInfo resContext) throws IOException {
        if (resContext == null) {
            throw new BadRequestException("Input ReservationSubmissionContext should not be null");
        }
        ReservationDefinitionInfo resInfo = resContext.getReservationDefinition();
        if (resInfo == null) {
            throw new BadRequestException("Input ReservationDefinition should not be null");
        }
        ReservationRequestsInfo resReqsInfo = resInfo.getReservationRequests();
        if (resReqsInfo == null || resReqsInfo.getReservationRequest() == null || resReqsInfo.getReservationRequest().size() == 0) {
            throw new BadRequestException("The ReservationDefinition should contain at least one ReservationRequest");
        }
        if (resContext.getReservationId() == null) {
            throw new BadRequestException("Update operations must specify an existing ReservationId");
        }
        ReservationRequestInterpreter[] values = ReservationRequestInterpreter.values();
        ReservationRequestInterpreter resInt = values[resReqsInfo.getReservationRequestsInterpreter()];
        ArrayList<ReservationRequest> list = new ArrayList<ReservationRequest>();
        for (ReservationRequestInfo resReqInfo : resReqsInfo.getReservationRequest()) {
            ResourceInfo rInfo = resReqInfo.getCapability();
            Resource capability = Resource.newInstance((long)rInfo.getMemorySize(), (int)rInfo.getvCores());
            int numContainers = resReqInfo.getNumContainers();
            int minConcurrency = resReqInfo.getMinConcurrency();
            long duration = resReqInfo.getDuration();
            ReservationRequest rr = ReservationRequest.newInstance((Resource)capability, (int)numContainers, (int)minConcurrency, (long)duration);
            list.add(rr);
        }
        ReservationRequests reqs = ReservationRequests.newInstance(list, (ReservationRequestInterpreter)resInt);
        ReservationDefinition rDef = ReservationDefinition.newInstance((long)resInfo.getArrival(), (long)resInfo.getDeadline(), (ReservationRequests)reqs, (String)resInfo.getReservationName(), (String)resInfo.getRecurrenceExpression(), (Priority)Priority.newInstance((int)resInfo.getPriority()));
        ReservationUpdateRequest request = ReservationUpdateRequest.newInstance((ReservationDefinition)rDef, (ReservationId)ReservationId.parseReservationId((String)resContext.getReservationId()));
        return request;
    }

    @Override
    @POST
    @Path(value="/reservation/delete")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public Response deleteReservation(ReservationDeleteRequestInfo resContext, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        ReservationDeleteResponseInfo resRespInfo;
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        final ReservationDeleteRequest reservation = this.createReservationDeleteRequest(resContext);
        try {
            resRespInfo = (ReservationDeleteResponseInfo)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ReservationDeleteResponseInfo>(){

                @Override
                public ReservationDeleteResponseInfo run() throws IOException, YarnException {
                    RMWebServices.this.rm.getClientRMService().deleteReservation(reservation);
                    return new ReservationDeleteResponseInfo();
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                throw new BadRequestException(ue.getCause().getMessage());
            }
            LOG.info("Update reservation request failed", (Throwable)ue);
            throw ue;
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)resRespInfo).build();
    }

    private ReservationDeleteRequest createReservationDeleteRequest(ReservationDeleteRequestInfo resContext) throws IOException {
        ReservationDeleteRequest request = ReservationDeleteRequest.newInstance((ReservationId)ReservationId.parseReservationId((String)resContext.getReservationId()));
        return request;
    }

    @Override
    @GET
    @Path(value="/reservation/list")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response listReservation(@QueryParam(value="queue") @DefaultValue(value="default") String queue, @QueryParam(value="reservation-id") @DefaultValue(value="") String reservationId, @QueryParam(value="start-time") @DefaultValue(value="0") long startTime, @QueryParam(value="end-time") @DefaultValue(value="-1") long endTime, @QueryParam(value="include-resource-allocations") @DefaultValue(value="false") boolean includeResourceAllocations, @Context HttpServletRequest hsr) throws Exception {
        ReservationListResponse resRespInfo;
        this.initForReadableEndpoints();
        final ReservationListRequest request = ReservationListRequest.newInstance((String)queue, (String)reservationId, (long)startTime, (long)endTime, (boolean)includeResourceAllocations);
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI == null) {
            throw new AuthorizationException("Unable to obtain user name, user not authenticated");
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
        }
        try {
            resRespInfo = (ReservationListResponse)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ReservationListResponse>(){

                @Override
                public ReservationListResponse run() throws IOException, YarnException {
                    return RMWebServices.this.rm.getClientRMService().listReservations(request);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                throw new BadRequestException(ue.getCause().getMessage());
            }
            LOG.info("List reservation request failed", (Throwable)ue);
            throw ue;
        }
        ReservationListInfo resResponse = new ReservationListInfo(resRespInfo, includeResourceAllocations);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)resResponse).build();
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/timeouts/{type}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppTimeoutInfo getAppTimeout(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId, @PathParam(value="type") String type) throws AuthorizationException {
        this.initForReadableEndpoints();
        RMApp app = this.validateAppTimeoutRequest(hsr, appId);
        ApplicationTimeoutType appTimeoutType = this.parseTimeoutType(type);
        Long timeoutValue = app.getApplicationTimeouts().get(appTimeoutType);
        AppTimeoutInfo timeout = this.constructAppTimeoutDao(appTimeoutType, timeoutValue);
        return timeout;
    }

    private RMApp validateAppTimeoutRequest(HttpServletRequest hsr, String appId) {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        String userName = "UNKNOWN-USER";
        if (callerUGI != null) {
            userName = callerUGI.getUserName();
        }
        if (UserGroupInformation.isSecurityEnabled() && this.isStaticUser(callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            RMAuditLogger.logFailure(userName, "Get Application Timeouts", "UNKNOWN", "RMWebService", msg);
            throw new ForbiddenException(msg);
        }
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Get Application Timeouts", "UNKNOWN", "RMWebService", "Trying to get timeouts of an absent application " + appId);
            throw e;
        }
        return app;
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/timeouts")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppTimeoutsInfo getAppTimeouts(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException {
        this.initForReadableEndpoints();
        RMApp app = this.validateAppTimeoutRequest(hsr, appId);
        AppTimeoutsInfo timeouts = new AppTimeoutsInfo();
        Map<ApplicationTimeoutType, Long> applicationTimeouts = app.getApplicationTimeouts();
        if (applicationTimeouts.isEmpty()) {
            timeouts.add(this.constructAppTimeoutDao(ApplicationTimeoutType.LIFETIME, null));
        } else {
            for (Map.Entry<ApplicationTimeoutType, Long> timeout : app.getApplicationTimeouts().entrySet()) {
                AppTimeoutInfo timeoutInfo = this.constructAppTimeoutDao(timeout.getKey(), timeout.getValue());
                timeouts.add(timeoutInfo);
            }
        }
        return timeouts;
    }

    private ApplicationTimeoutType parseTimeoutType(String type) {
        try {
            return ApplicationTimeoutType.valueOf((String)StringUtils.toUpperCase((String)type.trim()));
        }
        catch (RuntimeException e) {
            Object[] typeArray = ApplicationTimeoutType.values();
            String allAppTimeoutTypes = Arrays.toString(typeArray);
            throw new BadRequestException("Invalid application-state " + type.trim() + " specified. It should be one of " + allAppTimeoutTypes);
        }
    }

    private AppTimeoutInfo constructAppTimeoutDao(ApplicationTimeoutType type, Long timeoutInMillis) {
        AppTimeoutInfo timeout = new AppTimeoutInfo();
        timeout.setTimeoutType(type);
        if (timeoutInMillis != null) {
            timeout.setExpiryTime(Times.formatISO8601((long)timeoutInMillis));
            timeout.setRemainingTime(Math.max((timeoutInMillis - System.currentTimeMillis()) / 1000L, 0L));
        }
        return timeout;
    }

    @Override
    @PUT
    @Path(value="/apps/{appid}/timeout")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public Response updateApplicationTimeout(AppTimeoutInfo appTimeout, @Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        String userName = callerUGI.getUserName();
        RMApp app = null;
        try {
            app = this.getRMAppForAppId(appId);
        }
        catch (NotFoundException e) {
            RMAuditLogger.logFailure(userName, "Update Application Timeouts", "UNKNOWN", "RMWebService", "Trying to update timeout of an absent application " + appId);
            throw e;
        }
        return this.updateApplicationTimeouts(app, callerUGI, appTimeout);
    }

    private Response updateApplicationTimeouts(final RMApp app, UserGroupInformation callerUGI, final AppTimeoutInfo appTimeout) throws IOException, InterruptedException {
        if (appTimeout.getTimeoutType() == null || appTimeout.getExpireTime() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Timeout type or ExpiryTime is null.").build();
        }
        String userName = callerUGI.getUserName();
        try {
            callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, YarnException {
                    UpdateApplicationTimeoutsRequest request = UpdateApplicationTimeoutsRequest.newInstance((ApplicationId)app.getApplicationId(), Collections.singletonMap(appTimeout.getTimeoutType(), appTimeout.getExpireTime()));
                    RMWebServices.this.rm.getClientRMService().updateApplicationTimeouts(request);
                    return null;
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                YarnException ye = (YarnException)ue.getCause();
                if (ye.getCause() instanceof AccessControlException) {
                    String appId = app.getApplicationId().toString();
                    String msg = "Unauthorized attempt to change timeout of app " + appId + " by remote user " + userName;
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
                }
                if (ye.getCause() instanceof ParseException) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ye.getMessage()).build();
                }
                throw ue;
            }
            throw ue;
        }
        AppTimeoutInfo timeout = this.constructAppTimeoutDao(appTimeout.getTimeoutType(), app.getApplicationTimeouts().get(appTimeout.getTimeoutType()));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)timeout).build();
    }

    @Override
    protected ApplicationReport getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getApplicationReport(request).getApplicationReport();
    }

    @Override
    protected List<ApplicationReport> getApplicationsReport(GetApplicationsRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getApplications(request).getApplicationList();
    }

    @Override
    protected ApplicationAttemptReport getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getApplicationAttemptReport(request).getApplicationAttemptReport();
    }

    @Override
    protected List<ApplicationAttemptReport> getApplicationAttemptsReport(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getApplicationAttempts(request).getApplicationAttemptList();
    }

    @Override
    protected ContainerReport getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getContainerReport(request).getContainerReport();
    }

    @Override
    protected List<ContainerReport> getContainersReport(GetContainersRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getContainers(request).getContainerList();
    }

    @GET
    @Path(value="/scheduler-conf/format")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response formatSchedulerConfiguration(@Context HttpServletRequest hsr) throws AuthorizationException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, true);
        ResourceScheduler scheduler = this.rm.getResourceScheduler();
        if (this.isConfigurationMutable(scheduler)) {
            try {
                MutableConfigurationProvider mutableConfigurationProvider = ((MutableConfScheduler)scheduler).getMutableConfProvider();
                mutableConfigurationProvider.formatConfigurationInStore(this.conf);
                try {
                    this.rm.getRMContext().getRMAdminService().refreshQueues();
                }
                catch (IOException | YarnException e) {
                    LOG.error("Exception thrown when formatting configuration.", e);
                    mutableConfigurationProvider.revertToOldConfig(this.conf);
                    throw e;
                }
                return Response.status((Response.Status)Response.Status.OK).entity((Object)"Configuration under store successfully formatted.").build();
            }
            catch (Exception e) {
                LOG.error("Exception thrown when formatting configuration", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Scheduler Configuration format only supported by " + MutableConfScheduler.class.getSimpleName())).build();
    }

    @POST
    @Path(value="/scheduler-conf/validate")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public synchronized Response validateAndGetSchedulerConfiguration(SchedConfUpdateInfo mutationInfo, @Context HttpServletRequest hsr) throws AuthorizationException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, true);
        ResourceScheduler scheduler = this.rm.getResourceScheduler();
        if (this.isConfigurationMutable(scheduler)) {
            try {
                MutableConfigurationProvider mutableConfigurationProvider = ((MutableConfScheduler)scheduler).getMutableConfProvider();
                Configuration schedulerConf = mutableConfigurationProvider.getConfiguration();
                Configuration newSchedulerConf = mutableConfigurationProvider.applyChanges(schedulerConf, mutationInfo);
                Configuration yarnConf = ((CapacityScheduler)scheduler).getConf();
                Configuration newConfig = new Configuration(yarnConf);
                Iterator iter = newSchedulerConf.iterator();
                Map.Entry e = null;
                while (iter.hasNext()) {
                    e = (Map.Entry)iter.next();
                    newConfig.set((String)e.getKey(), (String)e.getValue());
                }
                CapacitySchedulerConfigValidator.validateCSConfiguration(yarnConf, newConfig, this.rm.getRMContext());
                return Response.status((Response.Status)Response.Status.OK).entity((Object)new ConfInfo(newSchedulerConf)).build();
            }
            catch (Exception e) {
                String errorMsg = "CapacityScheduler configuration validation failed:" + e.toString();
                LOG.warn(errorMsg);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMsg).build();
            }
        }
        String errorMsg = String.format("Configuration change validation only supported by %s.", MutableConfScheduler.class.getSimpleName());
        LOG.warn(errorMsg);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMsg).build();
    }

    @Override
    @PUT
    @Path(value="/scheduler-conf")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public synchronized Response updateSchedulerConfiguration(SchedConfUpdateInfo mutationInfo, @Context HttpServletRequest hsr) throws AuthorizationException, InterruptedException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, true);
        ResourceScheduler scheduler = this.rm.getResourceScheduler();
        if (!(scheduler instanceof MutableConfScheduler)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Configuration change only supported by MutableConfScheduler.").build();
        }
        if (!((MutableConfScheduler)scheduler).isConfigurationMutable()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Configuration change only supported by mutable configuration store.").build();
        }
        try {
            callerUGI.doAs(() -> {
                MutableConfigurationProvider provider = ((MutableConfScheduler)scheduler).getMutableConfProvider();
                YarnConfigurationStore.LogMutation logMutation = this.applyMutation(provider, callerUGI, mutationInfo);
                return this.refreshQueues(provider, logMutation);
            });
        }
        catch (IOException e) {
            LOG.error("Exception thrown when modifying configuration.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Configuration change successfully applied.").build();
    }

    private Void refreshQueues(MutableConfigurationProvider provider, YarnConfigurationStore.LogMutation logMutation) throws Exception {
        try {
            this.rm.getRMContext().getRMAdminService().refreshQueues();
        }
        catch (IOException | YarnException e) {
            provider.confirmPendingMutation(logMutation, false);
            throw e;
        }
        provider.confirmPendingMutation(logMutation, true);
        return null;
    }

    private YarnConfigurationStore.LogMutation applyMutation(MutableConfigurationProvider provider, UserGroupInformation callerUGI, SchedConfUpdateInfo mutationInfo) throws Exception {
        if (!provider.getAclMutationPolicy().isMutationAllowed(callerUGI, mutationInfo)) {
            throw new org.apache.hadoop.security.AccessControlException("User is not admin of all modified queues.");
        }
        return provider.logAndApplyMutation(callerUGI, mutationInfo);
    }

    private boolean isConfigurationMutable(ResourceScheduler scheduler) {
        return scheduler instanceof MutableConfScheduler && ((MutableConfScheduler)scheduler).isConfigurationMutable();
    }

    @Override
    @GET
    @Path(value="/scheduler-conf")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response getSchedulerConfiguration(@Context HttpServletRequest hsr) throws AuthorizationException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, true);
        ResourceScheduler scheduler = this.rm.getResourceScheduler();
        if (this.isConfigurationMutable(scheduler)) {
            MutableConfigurationProvider mutableConfigurationProvider = ((MutableConfScheduler)scheduler).getMutableConfProvider();
            Configuration schedulerConf = mutableConfigurationProvider.getConfiguration();
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new ConfInfo(schedulerConf)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("This API only supports to retrieve scheduler configuration from a mutable-conf scheduler, underneath scheduler %s is not an instance of %s", scheduler.getClass().getSimpleName(), MutableConfScheduler.class.getSimpleName())).build();
    }

    @GET
    @Path(value="/scheduler-conf/version")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response getSchedulerConfigurationVersion(@Context HttpServletRequest hsr) throws AuthorizationException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, true);
        ResourceScheduler scheduler = this.rm.getResourceScheduler();
        if (this.isConfigurationMutable(scheduler)) {
            MutableConfigurationProvider mutableConfigurationProvider = ((MutableConfScheduler)scheduler).getMutableConfProvider();
            try {
                long configVersion = mutableConfigurationProvider.getConfigVersion();
                return Response.status((Response.Status)Response.Status.OK).entity((Object)new ConfigVersionInfo(configVersion)).build();
            }
            catch (Exception e) {
                LOG.error("Exception thrown when fetching configuration version.", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Configuration Version only supported by %s.", MutableConfScheduler.class.getSimpleName())).build();
    }

    @Override
    @GET
    @Path(value="/queues/{queue}/access")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public RMQueueAclInfo checkUserAccessToQueue(@PathParam(value="queue") String queue, @QueryParam(value="user") String username, @QueryParam(value="queue-acl-type") @DefaultValue(value="SUBMIT_APPLICATIONS") String queueAclType, @Context HttpServletRequest hsr) throws AuthorizationException {
        QueueACL queueACL;
        this.initForReadableEndpoints();
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        if (callerUGI != null && !this.rm.getResourceScheduler().checkAccess(callerUGI, QueueACL.ADMINISTER_QUEUE, queue)) {
            throw new ForbiddenException("User=" + callerUGI.getUserName() + " doesn't haven access to queue=" + queue + " so it cannot check ACLs for other users.");
        }
        UserGroupInformation user = UserGroupInformation.createRemoteUser((String)username);
        if (user == null) {
            throw new ForbiddenException("Failed to retrieve UserGroupInformation for user=" + username);
        }
        try {
            queueACL = QueueACL.valueOf((String)queueAclType);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Specified queueAclType=" + queueAclType + " is not a valid type, valid queue acl types={SUBMIT_APPLICATIONS/ADMINISTER_QUEUE}");
        }
        if (!this.rm.getResourceScheduler().checkAccess(user, queueACL, queue)) {
            return new RMQueueAclInfo(false, user.getUserName(), "User=" + username + " doesn't have access to queue=" + queue + " with acl-type=" + queueAclType);
        }
        return new RMQueueAclInfo(true, user.getUserName(), DEFAULT_RESERVATION_ID);
    }

    @Override
    @POST
    @Path(value="/containers/{containerid}/signal/{command}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response signalToContainer(@PathParam(value="containerid") String containerId, @PathParam(value="command") String command, @Context HttpServletRequest hsr) throws AuthorizationException {
        UserGroupInformation callerUGI = this.getCallerUserGroupInformation(hsr, true);
        this.initForWritableEndpoints(callerUGI, false);
        if (!EnumUtils.isValidEnum(SignalContainerCommand.class, (String)command.toUpperCase())) {
            String errMsg = "Invalid command: " + command.toUpperCase() + ", valid commands are: " + Arrays.asList(SignalContainerCommand.values());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        try {
            ContainerId containerIdObj = ContainerId.fromString((String)containerId);
            this.rm.getClientRMService().signalToContainer(SignalContainerRequest.newInstance((ContainerId)containerIdObj, (SignalContainerCommand)SignalContainerCommand.valueOf((String)command.toUpperCase())));
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/scheduler-overview")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public SchedulerOverviewInfo getSchedulerOverview() {
        this.initForReadableEndpoints();
        ResourceScheduler rs = this.rm.getResourceScheduler();
        return new SchedulerOverviewInfo(rs);
    }

    @VisibleForTesting
    public LRUCache<AppsCacheKey, AppsInfo> getAppsLRUCache() {
        return this.appsLRUCache;
    }
}

