/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { moduleFor, test } from 'ember-qunit';
import Ember from 'ember';

moduleFor('route:yarn-node-apps', 'Unit | Route | NodeApps', {
});

test('Basic creation test', function(assert) {
  let route = this.subject();
  assert.ok(route);
  assert.ok(route.model);
});

test('Test getting apps on a node', function(assert) {
  var response = [
      {id:"application_1456251210105_0001", state:"FINISHED", user:"root"},
      {id:"application_1456251210105_0002", state:"RUNNING",user:"root",
      containerids:["container_e38_1456251210105_0002_01_000001",
      "container_e38_1456251210105_0002_01_000002"]}];
  var store = {
    query: function() {
      return new Ember.RSVP.Promise(function(resolve) {
        resolve(response.slice());
      });
    }
  };
  assert.expect(8);
  var route = this.subject();
  route.set('store', store);
  route.model({node_id:"localhost:64318", node_addr:"localhost:8042"})
    .then(
      function(value){
        assert.ok(value);
        assert.ok(value.apps);
        assert.equal(value.apps.length, 2);
        assert.deepEqual(response[0], value.apps[0]);
        assert.deepEqual(response[1], value.apps[1]);
        assert.ok(value.nodeInfo);
        assert.equal(value.nodeInfo.addr, 'localhost:8042');
        assert.equal(value.nodeInfo.id, 'localhost:64318');
      }
    );
});
