/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl.streams;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.apache.hadoop.fs.FileRange;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.VectoredReadUtils;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecretOperations;
import org.apache.hadoop.fs.s3a.impl.streams.AnalyticsRequestCallback;
import org.apache.hadoop.fs.s3a.impl.streams.InputStreamType;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStream;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectReadParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.S3SeekableInputStream;
import software.amazon.s3.analyticsaccelerator.S3SeekableInputStreamFactory;
import software.amazon.s3.analyticsaccelerator.common.ObjectRange;
import software.amazon.s3.analyticsaccelerator.request.EncryptionSecrets;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.request.StreamAuditContext;
import software.amazon.s3.analyticsaccelerator.util.InputPolicy;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;
import software.amazon.s3.analyticsaccelerator.util.RequestCallback;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

public class AnalyticsStream
extends ObjectInputStream
implements StreamCapabilities {
    private S3SeekableInputStream inputStream;
    private long lastReadCurrentPos = 0L;
    private volatile boolean closed;
    public static final Logger LOG = LoggerFactory.getLogger(AnalyticsStream.class);

    public AnalyticsStream(ObjectReadParameters parameters, S3SeekableInputStreamFactory s3SeekableInputStreamFactory) throws IOException {
        super(InputStreamType.Analytics, parameters);
        S3ObjectAttributes s3Attributes = parameters.getObjectAttributes();
        this.inputStream = s3SeekableInputStreamFactory.createStream(S3URI.of((String)s3Attributes.getBucket(), (String)s3Attributes.getKey()), this.buildOpenStreamInformation(parameters));
        this.getS3AStreamStatistics().streamOpened(InputStreamType.Analytics);
    }

    public int read() throws IOException {
        int bytesRead;
        this.throwIfClosed();
        this.getS3AStreamStatistics().readOperationStarted(this.getPos(), 1L);
        try {
            bytesRead = this.inputStream.read();
        }
        catch (IOException ioe) {
            this.onReadFailure(ioe);
            throw ioe;
        }
        if (bytesRead != -1) {
            this.incrementBytesRead(1L);
        }
        return bytesRead;
    }

    public void seek(long pos) throws IOException {
        this.throwIfClosed();
        if (pos < 0L) {
            throw new EOFException("Cannot seek to a negative offset " + pos);
        }
        this.inputStream.seek(pos);
    }

    public synchronized long getPos() {
        if (!this.closed) {
            this.lastReadCurrentPos = this.inputStream.getPos();
        }
        return this.lastReadCurrentPos;
    }

    public int readTail(byte[] buf, int off, int len) throws IOException {
        int bytesRead;
        this.throwIfClosed();
        this.getS3AStreamStatistics().readOperationStarted(this.getPos(), len);
        try {
            bytesRead = this.inputStream.readTail(buf, off, len);
        }
        catch (IOException ioe) {
            this.onReadFailure(ioe);
            throw ioe;
        }
        if (bytesRead > 0) {
            this.incrementBytesRead(bytesRead);
        }
        return bytesRead;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int bytesRead;
        this.throwIfClosed();
        this.getS3AStreamStatistics().readOperationStarted(this.getPos(), len);
        try {
            bytesRead = this.inputStream.read(buf, off, len);
        }
        catch (IOException ioe) {
            this.onReadFailure(ioe);
            throw ioe;
        }
        if (bytesRead > 0) {
            this.incrementBytesRead(bytesRead);
        }
        return bytesRead;
    }

    public void readVectored(List<? extends FileRange> ranges, IntFunction<ByteBuffer> allocate) throws IOException {
        this.readVectored(ranges, allocate, VectoredReadUtils.LOG_BYTE_BUFFER_RELEASED);
    }

    public void readVectored(List<? extends FileRange> ranges, IntFunction<ByteBuffer> allocate, Consumer<ByteBuffer> release) throws IOException {
        LOG.debug("AAL: Starting vectored read on path {} for ranges {} ", (Object)this.getPathStr(), ranges);
        this.throwIfClosed();
        ArrayList<ObjectRange> objectRanges = new ArrayList<ObjectRange>();
        for (FileRange fileRange : ranges) {
            CompletableFuture result = new CompletableFuture();
            ObjectRange objectRange = new ObjectRange(result, fileRange.getOffset(), fileRange.getLength());
            objectRanges.add(objectRange);
            fileRange.setData(result);
        }
        this.inputStream.readVectored(objectRanges, allocate, release);
    }

    public boolean seekToNewSource(long l) throws IOException {
        return false;
    }

    public int available() throws IOException {
        this.throwIfClosed();
        return super.available();
    }

    @Override
    protected boolean isStreamOpen() {
        return !this.isClosed();
    }

    protected boolean isClosed() {
        return this.inputStream == null;
    }

    @Override
    protected void abortInFinalizer() {
        this.getS3AStreamStatistics().streamLeaked();
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.inputStream.close();
                this.inputStream = null;
                super.close();
            }
            catch (IOException ioe) {
                LOG.debug("Failure closing stream {}: ", (Object)this.getKey());
                throw ioe;
            }
        }
    }

    private void onReadFailure(IOException ioe) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got exception while trying to read from stream {}, not trying to recover:", (Object)this.getKey(), (Object)ioe);
        } else {
            LOG.info("Got exception while trying to read from stream {}, not trying to recover:", (Object)this.getKey(), (Object)ioe);
        }
        this.close();
    }

    private OpenStreamInformation buildOpenStreamInformation(ObjectReadParameters parameters) {
        AnalyticsRequestCallback requestCallback = new AnalyticsRequestCallback(this.getS3AStreamStatistics());
        OpenStreamInformation.OpenStreamInformationBuilder openStreamInformationBuilder = OpenStreamInformation.builder().inputPolicy(this.mapS3AInputPolicyToAAL(parameters.getContext().getInputPolicy())).requestCallback((RequestCallback)requestCallback);
        if (parameters.getObjectAttributes().getETag() != null) {
            openStreamInformationBuilder.objectMetadata(ObjectMetadata.builder().contentLength(parameters.getObjectAttributes().getLen()).etag(parameters.getObjectAttributes().getETag()).build());
        }
        if (parameters.getEncryptionSecrets().getEncryptionMethod() == S3AEncryptionMethods.SSE_C) {
            EncryptionSecretOperations.getSSECustomerKey(parameters.getEncryptionSecrets()).ifPresent(base64customerKey -> openStreamInformationBuilder.encryptionSecrets(EncryptionSecrets.builder().sseCustomerKey(Optional.of(base64customerKey)).build()));
        }
        openStreamInformationBuilder.streamAuditContext(StreamAuditContext.builder().operationName(parameters.getAuditSpan().getOperationName()).spanId(parameters.getAuditSpan().getSpanId()).build());
        return openStreamInformationBuilder.build();
    }

    private InputPolicy mapS3AInputPolicyToAAL(S3AInputPolicy inputPolicy) {
        switch (inputPolicy) {
            case Sequential: {
                return InputPolicy.Sequential;
            }
        }
        return InputPolicy.None;
    }

    protected void throwIfClosed() throws IOException {
        if (this.closed) {
            throw new IOException(this.getKey() + ": " + "Stream is closed!");
        }
    }

    private void incrementBytesRead(long bytesRead) {
        this.getS3AStreamStatistics().bytesRead(bytesRead);
        if (this.getContext().getStats() != null && bytesRead > 0L) {
            this.getContext().getStats().incrementBytesRead(bytesRead);
        }
    }
}

