/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import java.io.PrintWriter;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class TestServiceOperations {
    @Mock
    private Service service;
    @Mock
    private RuntimeException e;

    @Test
    public void testStopQuietlyWhenServiceStopThrowsException() throws Exception {
        Logger logger = LoggerFactory.getLogger(TestServiceOperations.class);
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs(logger);
        ((Service)Mockito.doThrow((Throwable[])new Throwable[]{this.e}).when((Object)this.service)).stop();
        ServiceOperations.stopQuietly((Logger)logger, (Service)this.service);
        Assertions.assertThat((String)logCapturer.getOutput()).contains(new CharSequence[]{"When stopping the service " + this.service.getName()});
        ((RuntimeException)Mockito.verify((Object)this.e, (VerificationMode)Mockito.times((int)1))).printStackTrace((PrintWriter)Mockito.any(PrintWriter.class));
    }
}

