/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogAsync;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.EditLogTailer;
import org.apache.hadoop.test.Whitebox;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public final class NameNodeAdapterMockitoUtil {
    private NameNodeAdapterMockitoUtil() {
    }

    public static BlockManager spyOnBlockManager(NameNode nn) {
        BlockManager bmSpy = (BlockManager)Mockito.spy((Object)nn.getNamesystem().getBlockManager());
        nn.getNamesystem().setBlockManagerForTesting(bmSpy);
        return bmSpy;
    }

    public static ReentrantReadWriteLock spyOnFsLock(FSNamesystem fsn) {
        ReentrantReadWriteLock spy = (ReentrantReadWriteLock)Mockito.spy((Object)fsn.getFsLockForTests());
        fsn.setFsLockForTests(spy);
        return spy;
    }

    public static FSImage spyOnFsImage(NameNode nn1) {
        FSNamesystem fsn = nn1.getNamesystem();
        FSImage spy = (FSImage)Mockito.spy((Object)fsn.getFSImage());
        Whitebox.setInternalState((Object)fsn, (String)"fsImage", (Object)spy);
        return spy;
    }

    public static JournalSet spyOnJournalSet(NameNode nn) {
        FSEditLog editLog = nn.getFSImage().getEditLog();
        JournalSet js = (JournalSet)Mockito.spy((Object)editLog.getJournalSet());
        editLog.setJournalSetForTesting(js);
        return js;
    }

    public static FSNamesystem spyOnNamesystem(NameNode nn) {
        FSNamesystem fsnSpy = (FSNamesystem)Mockito.spy((Object)nn.getNamesystem());
        FSNamesystem fsnOld = nn.namesystem;
        fsnOld.writeLock();
        fsnSpy.writeLock();
        nn.namesystem = fsnSpy;
        try {
            FieldUtils.writeDeclaredField((Object)nn.getRpcServer(), (String)"namesystem", (Object)fsnSpy, (boolean)true);
            FieldUtils.writeDeclaredField((Object)fsnSpy.getBlockManager(), (String)"namesystem", (Object)fsnSpy, (boolean)true);
            FieldUtils.writeDeclaredField((Object)fsnSpy.getLeaseManager(), (String)"fsnamesystem", (Object)fsnSpy, (boolean)true);
            FieldUtils.writeDeclaredField((Object)fsnSpy.getBlockManager().getDatanodeManager(), (String)"namesystem", (Object)fsnSpy, (boolean)true);
            FieldUtils.writeDeclaredField((Object)BlockManagerTestUtil.getHeartbeatManager(fsnSpy.getBlockManager()), (String)"namesystem", (Object)fsnSpy, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot set spy FSNamesystem", e);
        }
        finally {
            fsnSpy.writeUnlock();
            fsnOld.writeUnlock();
        }
        return fsnSpy;
    }

    public static FSEditLog spyOnEditLog(NameNode nn) {
        FSEditLog spyEditLog = (FSEditLog)Mockito.spy((Object)nn.getNamesystem().getFSImage().getEditLog());
        DFSTestUtil.setEditLogForTesting(nn.getNamesystem(), spyEditLog);
        EditLogTailer tailer = nn.getNamesystem().getEditLogTailer();
        if (tailer != null) {
            tailer.setEditLog(spyEditLog);
        }
        return spyEditLog;
    }

    public static FSEditLog spyDelayMkDirTransaction(NameNode nn, long delay) {
        FSEditLog realEditLog = nn.getFSImage().getEditLog();
        FSEditLogAsync spyEditLog = (FSEditLogAsync)Mockito.spy((Object)realEditLog);
        DFSTestUtil.setEditLogForTesting(nn.getNamesystem(), (FSEditLog)spyEditLog);
        Answer ans = invocation -> {
            Thread.sleep(delay);
            return (Boolean)invocation.callRealMethod();
        };
        ArgumentMatcher am = argument -> argument.opCode == FSEditLogOpCodes.OP_MKDIR;
        ((FSEditLogAsync)Mockito.doAnswer((Answer)ans).when((Object)spyEditLog)).doEditTransaction((FSEditLogOp)ArgumentMatchers.argThat((ArgumentMatcher)am));
        return spyEditLog;
    }
}

