/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.web.SimpleHttpProxyHandler;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.WebHdfsHandler;

class URLDispatcher
extends SimpleChannelInboundHandler<HttpRequest> {
    private final InetSocketAddress proxyHost;
    private final Configuration conf;
    private final Configuration confForCreate;
    private final boolean isSecure;

    URLDispatcher(InetSocketAddress proxyHost, Configuration conf, Configuration confForCreate, boolean isSecure) {
        this.proxyHost = proxyHost;
        this.conf = conf;
        this.confForCreate = confForCreate;
        this.isSecure = isSecure;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        String uri = req.uri();
        ChannelPipeline p = ctx.pipeline();
        if (uri.startsWith("/webhdfs/v1")) {
            WebHdfsHandler h = new WebHdfsHandler(this.conf, this.confForCreate);
            p.replace((ChannelHandler)this, WebHdfsHandler.class.getSimpleName(), (ChannelHandler)h);
            h.channelRead0(ctx, req);
        } else {
            SimpleHttpProxyHandler h = new SimpleHttpProxyHandler(this.proxyHost, this.isSecure);
            p.replace((ChannelHandler)this, SimpleHttpProxyHandler.class.getSimpleName(), (ChannelHandler)h);
            h.channelRead0(ctx, req);
        }
    }
}

