/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.kson;

import java.util.Stack;
import org.apache.hadoop.shaded.org.nustaq.kson.KsonCharInput;
import org.apache.hadoop.shaded.org.nustaq.kson.KsonDeserializer;

public class KsonStringCharInput
implements KsonCharInput {
    CharSequence s;
    int pos;
    int end;
    Stack<KsonDeserializer.ParseStep> stack;

    public KsonStringCharInput(CharSequence s) {
        this.s = s;
        this.pos = 0;
        this.end = s.length();
    }

    public KsonStringCharInput(String s, int pos, int len) {
        this.s = s;
        this.pos = pos;
        this.end = pos + len;
    }

    @Override
    public int readChar() {
        if (this.pos >= this.end) {
            return -1;
        }
        return this.s.charAt(this.pos++);
    }

    @Override
    public int peekChar() {
        if (this.pos >= this.end) {
            return -1;
        }
        return this.s.charAt(this.pos);
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public int back(int num) {
        this.pos -= num;
        return this.pos;
    }

    @Override
    public boolean isEof() {
        return this.pos >= this.s.length();
    }

    @Override
    public String getString(int pos, int length) {
        return this.s.subSequence(Math.max(0, pos), Math.min(this.s.length(), pos + length)).toString();
    }
}

