/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.internal.operators.BackpressureUtils;
import rx.internal.util.atomic.SpscAtomicArrayQueue;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.plugins.RxJavaHooks;

public final class ObservableSplit
implements Observable.OnSubscribe<String> {
    final Observable<String> source;
    final Pattern pattern;
    final int bufferSize;

    public ObservableSplit(Observable<String> source, Pattern pattern, int bufferSize) {
        this.source = source;
        this.pattern = pattern;
        this.bufferSize = bufferSize;
    }

    public void call(Subscriber<? super String> t) {
        SplitSubscriber parent = new SplitSubscriber(t, this.pattern, this.bufferSize);
        t.add((Subscription)parent.requested);
        t.setProducer((Producer)parent.requested);
        this.source.unsafeSubscribe((Subscriber)parent);
    }

    static final class SplitSubscriber
    extends Subscriber<String> {
        final Subscriber<? super String> actual;
        final Pattern pattern;
        final Requested requested;
        final AtomicInteger wip;
        final int limit;
        final Queue<String[]> queue;
        String[] current;
        String leftOver;
        int index;
        int produced;
        int empty;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;

        SplitSubscriber(Subscriber<? super String> actual, Pattern pattern, int bufferSize) {
            this.actual = actual;
            this.pattern = pattern;
            this.limit = bufferSize - (bufferSize >> 2);
            this.requested = new Requested();
            this.wip = new AtomicInteger();
            this.queue = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue(bufferSize) : new SpscAtomicArrayQueue(bufferSize);
            this.request(bufferSize);
        }

        public void onNext(String t) {
            String[] a;
            String lo = this.leftOver;
            try {
                a = lo == null || lo.isEmpty() ? this.pattern.split(t, -1) : this.pattern.split(lo + t, -1);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.unsubscribe();
                this.onError(ex);
                return;
            }
            if (a.length == 0) {
                this.leftOver = null;
                this.request(1L);
                return;
            }
            if (a.length == 1) {
                this.leftOver = a[0];
                this.request(1L);
                return;
            }
            this.leftOver = a[a.length - 1];
            this.queue.offer(a);
            this.drain();
        }

        public void onError(Throwable e) {
            if (this.done) {
                RxJavaHooks.onError((Throwable)e);
                return;
            }
            String lo = this.leftOver;
            if (lo != null && !lo.isEmpty()) {
                this.leftOver = null;
                this.queue.offer(new String[]{lo, null});
            }
            this.error = e;
            this.done = true;
            this.drain();
        }

        public void onCompleted() {
            if (!this.done) {
                this.done = true;
                String lo = this.leftOver;
                if (lo != null && !lo.isEmpty()) {
                    this.leftOver = null;
                    this.queue.offer(new String[]{lo, null});
                }
                this.drain();
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            Queue<String[]> q = this.queue;
            int missed = 1;
            int consumed = this.produced;
            String[] array = this.current;
            int idx = this.index;
            int emptyCount = this.empty;
            Subscriber<? super String> a = this.actual;
            do {
                Throwable ex;
                boolean empty;
                boolean d;
                long r = this.requested.get();
                long e = 0L;
                while (e != r) {
                    if (this.cancelled) {
                        this.current = null;
                        q.clear();
                        return;
                    }
                    d = this.done;
                    if (array == null && (array = q.poll()) != null) {
                        this.current = array;
                        if (++consumed == this.limit) {
                            consumed = 0;
                            this.request(this.limit);
                        }
                    }
                    boolean bl = empty = array == null;
                    if (d && empty) {
                        this.current = null;
                        ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onCompleted();
                        }
                        return;
                    }
                    if (empty) break;
                    if (array.length == idx + 1) {
                        array = null;
                        this.current = null;
                        idx = 0;
                        continue;
                    }
                    String v = array[idx];
                    if (v.isEmpty()) {
                        ++emptyCount;
                        ++idx;
                        continue;
                    }
                    while (emptyCount != 0 && e != r) {
                        if (this.cancelled) {
                            this.current = null;
                            q.clear();
                            return;
                        }
                        a.onNext((Object)"");
                        ++e;
                        --emptyCount;
                    }
                    if (e == r || emptyCount != 0) continue;
                    a.onNext((Object)v);
                    ++e;
                    ++idx;
                }
                if (e == r) {
                    if (this.cancelled) {
                        this.current = null;
                        q.clear();
                        return;
                    }
                    d = this.done;
                    if (array == null && (array = q.poll()) != null) {
                        this.current = array;
                        if (++consumed == this.limit) {
                            consumed = 0;
                            this.request(this.limit);
                        }
                    }
                    boolean bl = empty = array == null;
                    if (d && empty) {
                        this.current = null;
                        ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onCompleted();
                        }
                        return;
                    }
                }
                if (e != 0L) {
                    BackpressureUtils.produced((AtomicLong)this.requested, (long)e);
                }
                this.empty = emptyCount;
                this.produced = consumed;
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        void cancel() {
            this.cancelled = true;
            this.unsubscribe();
            if (this.wip.getAndIncrement() == 0) {
                this.current = null;
                this.queue.clear();
            }
        }

        boolean isCancelled() {
            return this.isUnsubscribed();
        }

        final class Requested
        extends AtomicLong
        implements Producer,
        Subscription {
            private static final long serialVersionUID = 3399839515828647345L;

            Requested() {
            }

            public void request(long n) {
                if (n > 0L) {
                    BackpressureUtils.getAndAddRequest((AtomicLong)this, (long)n);
                    SplitSubscriber.this.drain();
                } else if (n < 0L) {
                    throw new IllegalArgumentException("n >= 0 required but it was " + n);
                }
            }

            public boolean isUnsubscribed() {
                return SplitSubscriber.this.isCancelled();
            }

            public void unsubscribe() {
                SplitSubscriber.this.cancel();
            }
        }
    }
}

