/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.CopyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexpInConfigurationFilter
extends CopyFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RegexpInConfigurationFilter.class);
    private String excludeFileRegex;
    private List<Pattern> filters = new ArrayList<Pattern>();

    protected RegexpInConfigurationFilter(Configuration conf) {
        this.excludeFileRegex = conf.getTrimmed("distcp.exclude-file-regex", "");
        if (!this.excludeFileRegex.isEmpty()) {
            Pattern pattern = Pattern.compile(this.excludeFileRegex);
            this.filters.add(pattern);
        }
    }

    @Override
    public boolean shouldCopy(Path path) {
        for (Pattern filter : this.filters) {
            if (!filter.matcher(path.toString()).matches()) continue;
            LOG.debug("Skipping {} as it matches the filter regex", (Object)path.toString());
            return false;
        }
        return true;
    }
}

