/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ginq.transform;

import groovy.ginq.transform.GQ;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.groovy.ginq.GinqGroovyMethods;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class GinqASTTransformation
extends AbstractASTTransformation {
    private static final String VALUE = "value";
    private static final ClassNode GQ_CLASS_NODE = ClassHelper.make(GQ.class);
    private static final ClassNode DEFAULT_RESULT_TYPE = ClassHelper.makeWithoutCaching((Class)((Class)GinqASTTransformation.getDefaultOptionValue("value")));
    private static final Map<String, Expression> DEFAULT_OPTION_MAP = Collections.unmodifiableMap(GinqGroovyMethods.CONF_LIST.stream().collect(Collectors.toMap(c -> c, c -> GeneralUtils.constX((Object)GinqASTTransformation.getDefaultOptionValue(c)))));

    public void visit(ASTNode[] nodes, SourceUnit sourceUnit) {
        this.init(nodes, sourceUnit);
        AnnotatedNode annotatedNode = (AnnotatedNode)nodes[1];
        AnnotationNode annotationNode = (AnnotationNode)nodes[0];
        if (!GQ_CLASS_NODE.equals((Object)annotationNode.getClassNode())) {
            return;
        }
        if (annotatedNode instanceof MethodNode) {
            ClassNode type;
            MethodNode methodNode = (MethodNode)annotatedNode;
            if (methodNode.isAbstract()) {
                this.addError("Error during " + GQ_CLASS_NODE.getName() + " processing: annotation not allowed on abstract method '" + methodNode.getName() + "'", (ASTNode)methodNode);
                return;
            }
            BlockStatement origCode = (BlockStatement)methodNode.getCode();
            MapExpression ginqConfigurationMapExpression = this.makeGinqConfigurationMapExpression(annotationNode);
            Expression valueExpression = annotationNode.getMember(VALUE);
            ClassNode targetType = DEFAULT_RESULT_TYPE;
            if (valueExpression instanceof ClassExpression && !targetType.equals((Object)(type = valueExpression.getType()))) {
                targetType = type;
            }
            Expression resultExpression = GinqGroovyMethods.transformGinqCode(sourceUnit, ginqConfigurationMapExpression, (Statement)origCode);
            if (!DEFAULT_RESULT_TYPE.equals((Object)targetType)) {
                if (ClassHelper.LIST_TYPE.equals((Object)targetType)) {
                    resultExpression = GeneralUtils.callX((Expression)resultExpression, (String)"toList");
                } else {
                    CastExpression castExpression = GeneralUtils.castX((ClassNode)targetType, (Expression)resultExpression);
                    castExpression.setCoerce(true);
                    resultExpression = castExpression;
                }
            }
            BlockStatement newCode = GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.stmt((Expression)resultExpression)});
            newCode.setSourcePosition((ASTNode)origCode);
            methodNode.setCode((Statement)newCode);
            VariableScopeVisitor variableScopeVisitor = new VariableScopeVisitor(sourceUnit);
            variableScopeVisitor.visitClass(methodNode.getDeclaringClass());
        }
    }

    private MapExpression makeGinqConfigurationMapExpression(AnnotationNode annotationNode) {
        HashMap<String, Expression> resultMembers = new HashMap<String, Expression>(DEFAULT_OPTION_MAP);
        HashMap currentMembers = new HashMap(annotationNode.getMembers());
        resultMembers.putAll(currentMembers);
        resultMembers.remove(VALUE);
        return GeneralUtils.mapX(resultMembers.entrySet().stream().map(e -> new MapEntryExpression((Expression)GeneralUtils.constX(e.getKey()), (Expression)GeneralUtils.constX((Object)((Expression)e.getValue()).getText()))).collect(Collectors.toList()));
    }

    private static Object getDefaultOptionValue(String optionName) {
        try {
            return GQ_CLASS_NODE.getTypeClass().getMethod(optionName, new Class[0]).getDefaultValue();
        }
        catch (NoSuchMethodException e) {
            throw new GroovyBugError("Unknown GINQ option: " + optionName, (Exception)e);
        }
    }
}

