/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.rest.RESTRequest;

public class TagsAssociateRequest
implements RESTRequest {
    @JsonProperty(value="tagsToAdd")
    private final String[] tagsToAdd;
    @JsonProperty(value="tagsToRemove")
    private final String[] tagsToRemove;

    public TagsAssociateRequest(String[] tagsToAdd, String[] tagsToRemove) {
        this.tagsToAdd = tagsToAdd;
        this.tagsToRemove = tagsToRemove;
    }

    public TagsAssociateRequest() {
        this(null, null);
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument((this.tagsToAdd != null || this.tagsToRemove != null ? 1 : 0) != 0, (Object)"tagsToAdd and tagsToRemove cannot both be null");
        if (this.tagsToAdd != null) {
            for (String tag : this.tagsToAdd) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tag), (Object)"tagsToAdd must not contain null or empty tag names");
            }
        }
        if (this.tagsToRemove != null) {
            for (String tag : this.tagsToRemove) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tag), (Object)"tagsToRemove must not contain null or empty tag names");
            }
        }
    }

    public String[] getTagsToAdd() {
        return this.tagsToAdd;
    }

    public String[] getTagsToRemove() {
        return this.tagsToRemove;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagsAssociateRequest)) {
            return false;
        }
        TagsAssociateRequest other = (TagsAssociateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTagsToAdd(), other.getTagsToAdd())) {
            return false;
        }
        return Arrays.deepEquals(this.getTagsToRemove(), other.getTagsToRemove());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TagsAssociateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getTagsToAdd());
        result = result * 59 + Arrays.deepHashCode(this.getTagsToRemove());
        return result;
    }

    public String toString() {
        return "TagsAssociateRequest(tagsToAdd=" + Arrays.deepToString(this.getTagsToAdd()) + ", tagsToRemove=" + Arrays.deepToString(this.getTagsToRemove()) + ")";
    }
}

