/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class PolicyMetadataObjectRelPO {
    private Long policyId;
    private Long metadataObjectId;
    private String metadataObjectType;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolicyMetadataObjectRelPO)) {
            return false;
        }
        PolicyMetadataObjectRelPO policyRelPO = (PolicyMetadataObjectRelPO)o;
        return Objects.equal((Object)this.policyId, (Object)policyRelPO.policyId) && Objects.equal((Object)this.metadataObjectId, (Object)policyRelPO.metadataObjectId) && Objects.equal((Object)this.metadataObjectType, (Object)policyRelPO.metadataObjectType) && Objects.equal((Object)this.auditInfo, (Object)policyRelPO.auditInfo) && Objects.equal((Object)this.currentVersion, (Object)policyRelPO.currentVersion) && Objects.equal((Object)this.lastVersion, (Object)policyRelPO.lastVersion) && Objects.equal((Object)this.deletedAt, (Object)policyRelPO.deletedAt);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.policyId, this.metadataObjectId, this.metadataObjectType, this.auditInfo, this.currentVersion, this.lastVersion, this.deletedAt});
    }

    public Long getPolicyId() {
        return this.policyId;
    }

    public Long getMetadataObjectId() {
        return this.metadataObjectId;
    }

    public String getMetadataObjectType() {
        return this.metadataObjectType;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public static class Builder {
        private final PolicyMetadataObjectRelPO policyRelPO = new PolicyMetadataObjectRelPO();

        private Builder() {
        }

        public Builder withPolicyId(Long policyId) {
            this.policyRelPO.policyId = policyId;
            return this;
        }

        public Builder withMetadataObjectId(Long metadataObjectId) {
            this.policyRelPO.metadataObjectId = metadataObjectId;
            return this;
        }

        public Builder withMetadataObjectType(String metadataObjectType) {
            this.policyRelPO.metadataObjectType = metadataObjectType;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.policyRelPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.policyRelPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.policyRelPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.policyRelPO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.policyRelPO.policyId != null ? 1 : 0) != 0, (Object)"Policy id is required");
            Preconditions.checkArgument((this.policyRelPO.metadataObjectId != null ? 1 : 0) != 0, (Object)"Metadata object id is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.policyRelPO.metadataObjectType), (Object)"Metadata object type should not be empty");
            Preconditions.checkArgument((this.policyRelPO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.policyRelPO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.policyRelPO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.policyRelPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public PolicyMetadataObjectRelPO build() {
            this.validate();
            return this.policyRelPO;
        }
    }
}

