/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.iceberg.service.IcebergRESTUtils;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.listener.api.event.IcebergTableEvent;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.responses.LoadTableResponse;

@DeveloperApi
public class IcebergRegisterTableEvent
extends IcebergTableEvent {
    private final RegisterTableRequest registerTableRequest;
    private final LoadTableResponse loadTableResponse;

    public IcebergRegisterTableEvent(IcebergRequestContext icebergRequestContext, NameIdentifier resourceIdentifier, RegisterTableRequest registerTableRequest, LoadTableResponse loadTableResponse) {
        super(icebergRequestContext, resourceIdentifier);
        this.registerTableRequest = IcebergRESTUtils.cloneIcebergRESTObject(registerTableRequest, RegisterTableRequest.class);
        this.loadTableResponse = IcebergRESTUtils.cloneIcebergRESTObject(loadTableResponse, LoadTableResponse.class);
    }

    public RegisterTableRequest registerTableRequest() {
        return this.registerTableRequest;
    }

    public LoadTableResponse loadTableResponse() {
        return this.loadTableResponse;
    }

    public OperationType operationType() {
        return OperationType.REGISTER_TABLE;
    }
}

