/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.abs.fs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.gravitino.abs.fs.AzureSasCredentialsProvider;
import org.apache.gravitino.abs.fs.AzureStorageUtils;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemProvider;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemUtils;
import org.apache.gravitino.catalog.hadoop.fs.SupportsCredentialVending;
import org.apache.gravitino.credential.ADLSTokenCredential;
import org.apache.gravitino.credential.AzureAccountKeyCredential;
import org.apache.gravitino.credential.Credential;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.services.AuthType;

public class AzureFileSystemProvider
implements FileSystemProvider,
SupportsCredentialVending {
    @VisibleForTesting
    public static final String ABS_PROVIDER_SCHEME = "abfss";
    @VisibleForTesting
    public static final String ABS_PROVIDER_NAME = "abs";
    private static final String ABFS_IMPL = "org.apache.hadoop.fs.azurebfs.SecureAzureBlobFileSystem";
    private static final String ABFS_IMPL_KEY = "fs.abfss.impl";

    public FileSystem getFileSystem(@Nonnull Path path, @Nonnull Map<String, String> config) throws IOException {
        Map<String, String> hadoopConfMap = FileSystemUtils.toHadoopConfigMap(config, (Map)ImmutableMap.of());
        if (config.containsKey("azure-storage-account-name") && config.containsKey("azure-storage-account-key")) {
            hadoopConfMap.put(String.format("fs.azure.account.key.%s.dfs.core.windows.net", config.get("azure-storage-account-name")), config.get("azure-storage-account-key"));
        }
        if (!hadoopConfMap.containsKey(ABFS_IMPL_KEY)) {
            hadoopConfMap.put(ABFS_IMPL_KEY, ABFS_IMPL);
        }
        hadoopConfMap = this.additionalAzureConfig(hadoopConfMap);
        Configuration configuration = FileSystemUtils.createConfiguration(hadoopConfMap);
        return FileSystem.newInstance((URI)path.toUri(), (Configuration)configuration);
    }

    public Map<String, String> getFileSystemCredentialConf(Credential[] credentials) {
        Credential credential = AzureStorageUtils.getSuitableCredential(credentials);
        HashMap result = Maps.newHashMap();
        if (credential instanceof ADLSTokenCredential) {
            ADLSTokenCredential adlsTokenCredential = (ADLSTokenCredential)credential;
            String accountName = String.format("%s.dfs.core.windows.net", adlsTokenCredential.accountName());
            result.put("fs.azure.account.auth.type." + accountName, AuthType.SAS.name());
            result.put("fs.azure.sas.token.provider.type." + accountName, AzureSasCredentialsProvider.class.getName());
            result.put("fs.azure.account.hns.enabled", "true");
        } else if (credential instanceof AzureAccountKeyCredential) {
            AzureAccountKeyCredential azureAccountKeyCredential = (AzureAccountKeyCredential)credential;
            result.put(String.format("fs.azure.account.key.%s.dfs.core.windows.net", azureAccountKeyCredential.accountName()), azureAccountKeyCredential.accountKey());
        }
        return result;
    }

    public String scheme() {
        return ABS_PROVIDER_SCHEME;
    }

    public String name() {
        return ABS_PROVIDER_NAME;
    }

    private Map<String, String> additionalAzureConfig(Map<String, String> configs) {
        HashMap additionalConfigs = Maps.newHashMap(configs);
        if (!configs.containsKey("fs.azure.io.retry.max.retries")) {
            additionalConfigs.put("fs.azure.io.retry.max.retries", "2");
        }
        return ImmutableMap.copyOf((Map)additionalConfigs);
    }
}

