/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.meta.GenericEntity;
import org.apache.gravitino.meta.TagEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.TagMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.po.TagMetadataObjectRelPO;
import org.apache.gravitino.storage.relational.po.TagPO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.service.MetadataObjectService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class TagMetaService {
    private static final TagMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ Annotation ajc$anno$9;

    public static TagMetaService getInstance() {
        return INSTANCE;
    }

    private TagMetaService() {
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listTagsByNamespace")
    public List<TagEntity> listTagsByNamespace(Namespace ns) {
        Namespace namespace = ns;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)namespace);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TagMetaService.class.getDeclaredMethod("listTagsByNamespace", Namespace.class).getAnnotation(Monitored.class);
        }
        return (List)TagMetaService.listTagsByNamespace_aroundBody1$advice(this, namespace, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getTagByIdentifier")
    public TagEntity getTagByIdentifier(NameIdentifier ident) {
        NameIdentifier nameIdentifier = ident;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TagMetaService.class.getDeclaredMethod("getTagByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (TagEntity)TagMetaService.getTagByIdentifier_aroundBody3$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertTag")
    public void insertTag(TagEntity tagEntity, boolean overwritten) throws IOException {
        TagEntity tagEntity2 = tagEntity;
        boolean bl = overwritten;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)tagEntity2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TagMetaService.class.getDeclaredMethod("insertTag", TagEntity.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        TagMetaService.insertTag_aroundBody5$advice(this, tagEntity2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updateTag")
    public <E extends Entity & HasIdentifier> TagEntity updateTag(NameIdentifier identifier, Function<E, E> updater) throws IOException {
        NameIdentifier nameIdentifier = identifier;
        Function<E, E> function = updater;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)nameIdentifier, function);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = TagMetaService.class.getDeclaredMethod("updateTag", NameIdentifier.class, Function.class).getAnnotation(Monitored.class);
        }
        return (TagEntity)TagMetaService.updateTag_aroundBody7$advice(this, nameIdentifier, function, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteTag")
    public boolean deleteTag(NameIdentifier identifier) {
        NameIdentifier nameIdentifier = identifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = TagMetaService.class.getDeclaredMethod("deleteTag", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)TagMetaService.deleteTag_aroundBody9$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listTagsForMetadataObject")
    public List<TagEntity> listTagsForMetadataObject(NameIdentifier objectIdent, Entity.EntityType objectType) throws NoSuchTagException, IOException {
        NameIdentifier nameIdentifier = objectIdent;
        Entity.EntityType entityType = objectType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)nameIdentifier, (Object)((Object)entityType));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = TagMetaService.class.getDeclaredMethod("listTagsForMetadataObject", NameIdentifier.class, Entity.EntityType.class).getAnnotation(Monitored.class);
        }
        return (List)TagMetaService.listTagsForMetadataObject_aroundBody11$advice(this, nameIdentifier, entityType, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getTagForMetadataObject")
    public TagEntity getTagForMetadataObject(NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier tagIdent) throws NoSuchEntityException, IOException {
        NameIdentifier nameIdentifier = objectIdent;
        Entity.EntityType entityType = objectType;
        NameIdentifier nameIdentifier2 = tagIdent;
        Object[] objectArray = new Object[]{nameIdentifier, entityType, nameIdentifier2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = TagMetaService.class.getDeclaredMethod("getTagForMetadataObject", NameIdentifier.class, Entity.EntityType.class, NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (TagEntity)TagMetaService.getTagForMetadataObject_aroundBody13$advice(this, nameIdentifier, entityType, nameIdentifier2, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listAssociatedMetadataObjectsForTag")
    public List<GenericEntity> listAssociatedMetadataObjectsForTag(NameIdentifier tagIdent) throws IOException {
        NameIdentifier nameIdentifier = tagIdent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = TagMetaService.class.getDeclaredMethod("listAssociatedMetadataObjectsForTag", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (List)TagMetaService.listAssociatedMetadataObjectsForTag_aroundBody15$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="associateTagsWithMetadataObject")
    public List<TagEntity> associateTagsWithMetadataObject(NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier[] tagsToAdd, NameIdentifier[] tagsToRemove) throws NoSuchEntityException, EntityAlreadyExistsException, IOException {
        NameIdentifier nameIdentifier = objectIdent;
        Entity.EntityType entityType = objectType;
        NameIdentifier[] nameIdentifierArray = tagsToAdd;
        NameIdentifier[] nameIdentifierArray2 = tagsToRemove;
        Object[] objectArray = new Object[]{nameIdentifier, entityType, nameIdentifierArray, nameIdentifierArray2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = TagMetaService.class.getDeclaredMethod("associateTagsWithMetadataObject", NameIdentifier.class, Entity.EntityType.class, NameIdentifier[].class, NameIdentifier[].class).getAnnotation(Monitored.class);
        }
        return (List)TagMetaService.associateTagsWithMetadataObject_aroundBody17$advice(this, nameIdentifier, entityType, nameIdentifierArray, nameIdentifierArray2, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteTagMetasByLegacyTimeline")
    public int deleteTagMetasByLegacyTimeline(long legacyTimeline, int limit) {
        long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = TagMetaService.class.getDeclaredMethod("deleteTagMetasByLegacyTimeline", Long.TYPE, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)TagMetaService.deleteTagMetasByLegacyTimeline_aroundBody19$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    private TagPO getTagPOByMetalakeAndName(String metalakeName, String tagName) {
        TagPO tagPO = SessionUtils.getWithoutCommit(TagMetaMapper.class, mapper -> mapper.selectTagMetaByMetalakeAndName(metalakeName, tagName));
        if (tagPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.TAG.name().toLowerCase(), tagName});
        }
        return tagPO;
    }

    public Long getTagIdByTagName(Long metalakeId, String tagName) {
        return SessionUtils.getWithoutCommit(TagMetaMapper.class, mapper -> mapper.selectTagMetaByMetalakeIdAndName(metalakeId, tagName)).getTagId();
    }

    private List<TagPO> getTagPOsByMetalakeAndNames(String metalakeName, List<String> tagNames) {
        return SessionUtils.getWithoutCommit(TagMetaMapper.class, mapper -> mapper.listTagPOsByMetalakeAndTagNames(metalakeName, tagNames));
    }

    static {
        TagMetaService.ajc$preClinit();
        INSTANCE = new TagMetaService();
    }

    private static final /* synthetic */ List listTagsByNamespace_aroundBody0(TagMetaService ajc$this, Namespace ns, JoinPoint joinPoint) {
        String metalakeName = ns.level(0);
        List tagPOs = SessionUtils.getWithoutCommit(TagMetaMapper.class, mapper -> mapper.listTagPOsByMetalake(metalakeName));
        return tagPOs.stream().map(tagPO -> POConverters.fromTagPO(tagPO, ns)).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listTagsByNamespace_aroundBody1$advice(TagMetaService ajc$this, Namespace ns, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.listTagsByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.listTagsByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = TagMetaService.listTagsByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ TagEntity getTagByIdentifier_aroundBody2(TagMetaService ajc$this, NameIdentifier ident, JoinPoint joinPoint) {
        String metalakeName = ident.namespace().level(0);
        TagPO tagPO = ajc$this.getTagPOByMetalakeAndName(metalakeName, ident.name());
        return POConverters.fromTagPO(tagPO, ident.namespace());
    }

    private static final /* synthetic */ Object getTagByIdentifier_aroundBody3$advice(TagMetaService ajc$this, NameIdentifier ident, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        TagEntity tagEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.getTagByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.getTagByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TagEntity result = TagMetaService.getTagByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                tagEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return tagEntity;
    }

    private static final /* synthetic */ void insertTag_aroundBody4(TagMetaService ajc$this, TagEntity tagEntity, boolean overwritten, JoinPoint joinPoint) {
        Namespace ns = tagEntity.namespace();
        String metalakeName = ns.level(0);
        try {
            Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(metalakeName);
            TagPO.Builder builder = TagPO.builder().withMetalakeId(metalakeId);
            TagPO tagPO = POConverters.initializeTagPOWithVersion(tagEntity, builder);
            SessionUtils.doWithCommit(TagMetaMapper.class, mapper -> {
                if (overwritten) {
                    mapper.insertTagMetaOnDuplicateKeyUpdate(tagPO);
                } else {
                    mapper.insertTagMeta(tagPO);
                }
            });
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.TAG, tagEntity.toString());
            throw e;
        }
    }

    private static final /* synthetic */ Object insertTag_aroundBody5$advice(TagMetaService ajc$this, TagEntity tagEntity, boolean overwritten, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TagMetaService.insertTag_aroundBody4(ajc$this, tagEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TagMetaService.insertTag_aroundBody4(ajc$this, tagEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TagMetaService.insertTag_aroundBody4(ajc$this, tagEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ TagEntity updateTag_aroundBody6(TagMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint joinPoint) {
        String metalakeName = identifier.namespace().level(0);
        try {
            TagPO tagPO = ajc$this.getTagPOByMetalakeAndName(metalakeName, identifier.name());
            TagEntity oldTagEntity = POConverters.fromTagPO(tagPO, identifier.namespace());
            TagEntity updatedTagEntity = (TagEntity)updater.apply(oldTagEntity);
            Preconditions.checkArgument((boolean)Objects.equals(oldTagEntity.id(), updatedTagEntity.id()), (String)"The updated tag entity id: %s must have the same id as the old entity id %s", (Object)updatedTagEntity.id(), (Object)oldTagEntity.id());
            Integer result = SessionUtils.doWithCommitAndFetchResult(TagMetaMapper.class, mapper -> mapper.updateTagMeta(POConverters.updateTagPOWithVersion(tagPO, updatedTagEntity), tagPO));
            if (result == null || result == 0) {
                throw new IOException("Failed to update the entity: " + String.valueOf(identifier));
            }
            return updatedTagEntity;
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.TAG, identifier.toString());
            throw e;
        }
    }

    private static final /* synthetic */ Object updateTag_aroundBody7$advice(TagMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        TagEntity tagEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.updateTag_aroundBody6(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.updateTag_aroundBody6(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TagEntity result = TagMetaService.updateTag_aroundBody6(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                tagEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return tagEntity;
    }

    private static final /* synthetic */ boolean deleteTag_aroundBody8(TagMetaService ajc$this, NameIdentifier identifier, JoinPoint joinPoint) {
        String metalakeName = identifier.namespace().level(0);
        int[] tagDeletedCount = new int[]{0};
        int[] tagMetadataObjectRelDeletedCount = new int[]{0};
        SessionUtils.doMultipleWithCommit(() -> {
            tagDeletedCount[0] = SessionUtils.getWithoutCommit(TagMetaMapper.class, mapper -> mapper.softDeleteTagMetaByMetalakeAndTagName(metalakeName, identifier.name()));
        }, () -> {
            tagMetadataObjectRelDeletedCount[0] = SessionUtils.getWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByMetalakeAndTagName(metalakeName, identifier.name()));
        });
        return tagDeletedCount[0] + tagMetadataObjectRelDeletedCount[0] > 0;
    }

    private static final /* synthetic */ Object deleteTag_aroundBody9$advice(TagMetaService ajc$this, NameIdentifier identifier, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)TagMetaService.deleteTag_aroundBody8(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)TagMetaService.deleteTag_aroundBody8(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)TagMetaService.deleteTag_aroundBody8(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ List listTagsForMetadataObject_aroundBody10(TagMetaService ajc$this, NameIdentifier objectIdent, Entity.EntityType objectType, JoinPoint joinPoint) {
        MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject(objectIdent, objectType);
        String metalake = objectIdent.namespace().level(0);
        List tagPOs = null;
        try {
            Long metadataObjectId = EntityIdService.getEntityId(objectIdent, objectType);
            tagPOs = SessionUtils.getWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.listTagPOsByMetadataObjectIdAndType(metadataObjectId, metadataObject.type().toString()));
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.TAG, objectIdent.toString());
            throw e;
        }
        return tagPOs.stream().map(tagPO -> POConverters.fromTagPO(tagPO, NamespaceUtil.ofTag(metalake))).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listTagsForMetadataObject_aroundBody11$advice(TagMetaService ajc$this, NameIdentifier objectIdent, Entity.EntityType objectType, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.listTagsForMetadataObject_aroundBody10(ajc$this, objectIdent, objectType, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.listTagsForMetadataObject_aroundBody10(ajc$this, objectIdent, objectType, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = TagMetaService.listTagsForMetadataObject_aroundBody10(ajc$this, objectIdent, objectType, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ TagEntity getTagForMetadataObject_aroundBody12(TagMetaService ajc$this, NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier tagIdent, JoinPoint joinPoint) {
        MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject(objectIdent, objectType);
        String metalake = objectIdent.namespace().level(0);
        TagPO tagPO = null;
        try {
            Long metadataObjectId = EntityIdService.getEntityId(objectIdent, objectType);
            tagPO = SessionUtils.getWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.getTagPOsByMetadataObjectAndTagName(metadataObjectId, metadataObject.type().toString(), tagIdent.name()));
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.TAG, tagIdent.toString());
            throw e;
        }
        if (tagPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.TAG.name().toLowerCase(), tagIdent.name()});
        }
        return POConverters.fromTagPO(tagPO, NamespaceUtil.ofTag(metalake));
    }

    private static final /* synthetic */ Object getTagForMetadataObject_aroundBody13$advice(TagMetaService ajc$this, NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier tagIdent, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        TagEntity tagEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.getTagForMetadataObject_aroundBody12(ajc$this, objectIdent, objectType, tagIdent, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.getTagForMetadataObject_aroundBody12(ajc$this, objectIdent, objectType, tagIdent, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TagEntity result = TagMetaService.getTagForMetadataObject_aroundBody12(ajc$this, objectIdent, objectType, tagIdent, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                tagEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return tagEntity;
    }

    private static final /* synthetic */ List listAssociatedMetadataObjectsForTag_aroundBody14(TagMetaService ajc$this, NameIdentifier tagIdent, JoinPoint joinPoint) {
        String metalakeName = tagIdent.namespace().level(0);
        String tagName = tagIdent.name();
        try {
            List tagMetadataObjectRelPOs = SessionUtils.doWithCommitAndFetchResult(TagMetadataObjectRelMapper.class, mapper -> mapper.listTagMetadataObjectRelsByMetalakeAndTagName(metalakeName, tagName));
            ArrayList metadataObjects = Lists.newArrayList();
            Map<String, List<TagMetadataObjectRelPO>> tagMetadataObjectRelPOsByType = tagMetadataObjectRelPOs.stream().collect(Collectors.groupingBy(TagMetadataObjectRelPO::getMetadataObjectType));
            for (Map.Entry<String, List<TagMetadataObjectRelPO>> entry : tagMetadataObjectRelPOsByType.entrySet()) {
                String metadataObjectType = entry.getKey();
                List<TagMetadataObjectRelPO> rels = entry.getValue();
                List metadataObjectIds = rels.stream().map(TagMetadataObjectRelPO::getMetadataObjectId).collect(Collectors.toList());
                Map<Long, String> metadataObjectNames = MetadataObjectService.TYPE_TO_FULLNAME_FUNCTION_MAP.get(MetadataObject.Type.valueOf((String)metadataObjectType)).apply(metadataObjectIds);
                for (Map.Entry<Long, String> metadataObjectName : metadataObjectNames.entrySet()) {
                    String fullName = metadataObjectName.getValue();
                    if (fullName == null) continue;
                    metadataObjects.add(GenericEntity.builder().withName(fullName).withEntityType(Entity.EntityType.valueOf(metadataObjectType)).withId(metadataObjectName.getKey()).build());
                }
            }
            return metadataObjects;
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.TAG, tagIdent.toString());
            throw e;
        }
    }

    private static final /* synthetic */ Object listAssociatedMetadataObjectsForTag_aroundBody15$advice(TagMetaService ajc$this, NameIdentifier tagIdent, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.listAssociatedMetadataObjectsForTag_aroundBody14(ajc$this, tagIdent, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.listAssociatedMetadataObjectsForTag_aroundBody14(ajc$this, tagIdent, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = TagMetaService.listAssociatedMetadataObjectsForTag_aroundBody14(ajc$this, tagIdent, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ List associateTagsWithMetadataObject_aroundBody16(TagMetaService ajc$this, NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier[] tagsToAdd, NameIdentifier[] tagsToRemove, JoinPoint joinPoint) {
        MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject(objectIdent, objectType);
        String metalake = objectIdent.namespace().level(0);
        try {
            Long metadataObjectId = EntityIdService.getEntityId(objectIdent, objectType);
            List<String> tagNamesToAdd = Arrays.stream(tagsToAdd).map(NameIdentifier::name).collect(Collectors.toList());
            List tagPOsToAdd = tagNamesToAdd.isEmpty() ? Collections.emptyList() : ajc$this.getTagPOsByMetalakeAndNames(metalake, tagNamesToAdd);
            List<String> tagNamesToRemove = Arrays.stream(tagsToRemove).map(NameIdentifier::name).collect(Collectors.toList());
            List tagPOsToRemove = tagNamesToRemove.isEmpty() ? Collections.emptyList() : ajc$this.getTagPOsByMetalakeAndNames(metalake, tagNamesToRemove);
            SessionUtils.doMultipleWithCommit(() -> {
                if (tagPOsToAdd.isEmpty()) {
                    return;
                }
                List tagRelsToAdd = tagPOsToAdd.stream().map(tagPO -> POConverters.initializeTagMetadataObjectRelPOWithVersion(tagPO.getTagId(), metadataObjectId, metadataObject.type().toString())).collect(Collectors.toList());
                SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.batchInsertTagMetadataObjectRels(tagRelsToAdd));
            }, () -> {
                if (tagPOsToRemove.isEmpty()) {
                    return;
                }
                List tagIdsToRemove = tagPOsToRemove.stream().map(TagPO::getTagId).collect(Collectors.toList());
                SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.batchDeleteTagMetadataObjectRelsByTagIdsAndMetadataObject(metadataObjectId, metadataObject.type().toString(), tagIdsToRemove));
            });
            List tagPOs = SessionUtils.getWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.listTagPOsByMetadataObjectIdAndType(metadataObjectId, metadataObject.type().toString()));
            return tagPOs.stream().map(tagPO -> POConverters.fromTagPO(tagPO, NamespaceUtil.ofTag(metalake))).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.TAG, objectIdent.toString());
            throw e;
        }
    }

    private static final /* synthetic */ Object associateTagsWithMetadataObject_aroundBody17$advice(TagMetaService ajc$this, NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier[] tagsToAdd, NameIdentifier[] tagsToRemove, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.associateTagsWithMetadataObject_aroundBody16(ajc$this, objectIdent, objectType, tagsToAdd, tagsToRemove, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TagMetaService.associateTagsWithMetadataObject_aroundBody16(ajc$this, objectIdent, objectType, tagsToAdd, tagsToRemove, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = TagMetaService.associateTagsWithMetadataObject_aroundBody16(ajc$this, objectIdent, objectType, tagsToAdd, tagsToRemove, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ int deleteTagMetasByLegacyTimeline_aroundBody18(TagMetaService ajc$this, long legacyTimeline, int limit, JoinPoint joinPoint) {
        int[] tagDeletedCount = new int[]{0};
        int[] tagMetadataObjectRelDeletedCount = new int[]{0};
        SessionUtils.doMultipleWithCommit(() -> {
            tagDeletedCount[0] = SessionUtils.getWithoutCommit(TagMetaMapper.class, mapper -> mapper.deleteTagMetasByLegacyTimeline(legacyTimeline, limit));
        }, () -> {
            tagMetadataObjectRelDeletedCount[0] = SessionUtils.getWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.deleteTagEntityRelsByLegacyTimeline(legacyTimeline, limit));
        });
        return tagDeletedCount[0] + tagMetadataObjectRelDeletedCount[0];
    }

    private static final /* synthetic */ Object deleteTagMetasByLegacyTimeline_aroundBody19$advice(TagMetaService ajc$this, long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)TagMetaService.deleteTagMetasByLegacyTimeline_aroundBody18(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)TagMetaService.deleteTagMetasByLegacyTimeline_aroundBody18(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)TagMetaService.deleteTagMetasByLegacyTimeline_aroundBody18(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TagMetaService.java", TagMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listTagsByNamespace", "org.apache.gravitino.storage.relational.service.TagMetaService", "org.apache.gravitino.Namespace", "ns", "", "java.util.List"), 68);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTagByIdentifier", "org.apache.gravitino.storage.relational.service.TagMetaService", "org.apache.gravitino.NameIdentifier", "ident", "", "org.apache.gravitino.meta.TagEntity"), 81);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertTag", "org.apache.gravitino.storage.relational.service.TagMetaService", "org.apache.gravitino.meta.TagEntity:boolean", "tagEntity:overwritten", "java.io.IOException", "void"), 88);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTag", "org.apache.gravitino.storage.relational.service.TagMetaService", "org.apache.gravitino.NameIdentifier:java.util.function.Function", "identifier:updater", "java.io.IOException", "org.apache.gravitino.meta.TagEntity"), 115);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTag", "org.apache.gravitino.storage.relational.service.TagMetaService", "org.apache.gravitino.NameIdentifier", "identifier", "", "boolean"), 148);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listTagsForMetadataObject", "org.apache.gravitino.storage.relational.service.TagMetaService", "org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType", "objectIdent:objectType", "org.apache.gravitino.exceptions.NoSuchTagException:java.io.IOException", "java.util.List"), 177);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTagForMetadataObject", "org.apache.gravitino.storage.relational.service.TagMetaService", "org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType:org.apache.gravitino.NameIdentifier", "objectIdent:objectType:tagIdent", "org.apache.gravitino.exceptions.NoSuchEntityException:java.io.IOException", "org.apache.gravitino.meta.TagEntity"), 206);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listAssociatedMetadataObjectsForTag", "org.apache.gravitino.storage.relational.service.TagMetaService", "org.apache.gravitino.NameIdentifier", "tagIdent", "java.io.IOException", "java.util.List"), 239);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "associateTagsWithMetadataObject", "org.apache.gravitino.storage.relational.service.TagMetaService", "org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType:[Lorg.apache.gravitino.NameIdentifier;:[Lorg.apache.gravitino.NameIdentifier;", "objectIdent:objectType:tagsToAdd:tagsToRemove", "org.apache.gravitino.exceptions.NoSuchEntityException:org.apache.gravitino.EntityAlreadyExistsException:java.io.IOException", "java.util.List"), 300);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTagMetasByLegacyTimeline", "org.apache.gravitino.storage.relational.service.TagMetaService", "long:int", "legacyTimeline:limit", "", "int"), 379);
    }
}

