/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.util.Args;

public abstract class AbstractClientContextBuilder<T extends HttpClientContext> {
    private final SchemePortResolver schemePortResolver;
    private Lookup<CookieSpecFactory> cookieSpecRegistry;
    private Lookup<AuthSchemeFactory> authSchemeRegistry;
    private CookieStore cookieStore;
    private CredentialsProvider credentialsProvider;
    private AuthCache authCache;
    private Map<HttpHost, AuthScheme> authSchemeMap;

    protected AbstractClientContextBuilder(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public AbstractClientContextBuilder<T> useCookieSpecRegistry(Lookup<CookieSpecFactory> cookieSpecRegistry) {
        this.cookieSpecRegistry = cookieSpecRegistry;
        return this;
    }

    public AbstractClientContextBuilder<T> useAuthSchemeRegistry(Lookup<AuthSchemeFactory> authSchemeRegistry) {
        this.authSchemeRegistry = authSchemeRegistry;
        return this;
    }

    public AbstractClientContextBuilder<T> useCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public AbstractClientContextBuilder<T> useCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public AbstractClientContextBuilder<T> useAuthCache(AuthCache authCache) {
        this.authCache = authCache;
        return this;
    }

    public AbstractClientContextBuilder<T> preemptiveAuth(HttpHost host, AuthScheme authScheme) {
        Args.notNull(host, "HTTP host");
        if (this.authSchemeMap == null) {
            this.authSchemeMap = new HashMap<HttpHost, AuthScheme>();
        }
        this.authSchemeMap.put(RoutingSupport.normalize(host, this.schemePortResolver), authScheme);
        return this;
    }

    public AbstractClientContextBuilder<T> preemptiveBasicAuth(HttpHost host, UsernamePasswordCredentials credentials) {
        Args.notNull(host, "HTTP host");
        BasicScheme authScheme = new BasicScheme();
        authScheme.initPreemptive(credentials);
        this.preemptiveAuth(host, authScheme);
        return this;
    }

    protected abstract T createContext();

    public T build() {
        T context = this.createContext();
        ((HttpClientContext)context).setCookieSpecRegistry(this.cookieSpecRegistry);
        ((HttpClientContext)context).setAuthSchemeRegistry(this.authSchemeRegistry);
        ((HttpClientContext)context).setCookieStore(this.cookieStore);
        ((HttpClientContext)context).setCredentialsProvider(this.credentialsProvider);
        ((HttpClientContext)context).setAuthCache(this.authCache);
        if (this.authSchemeMap != null) {
            for (Map.Entry<HttpHost, AuthScheme> entry : this.authSchemeMap.entrySet()) {
                ((HttpClientContext)context).resetAuthExchange(entry.getKey(), entry.getValue());
            }
        }
        return context;
    }
}

