/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.extension.incubator.trace;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.util.concurrent.Callable;

public final class ExtendedTracer
implements Tracer {
    private final Tracer delegate;

    public static ExtendedTracer create(Tracer delegate) {
        return new ExtendedTracer(delegate);
    }

    private ExtendedTracer(Tracer delegate) {
        this.delegate = delegate;
    }

    public void run(String spanName, Runnable runnable2) {
        Span span = this.delegate.spanBuilder(spanName).startSpan();
        try (Scope scope = span.makeCurrent();){
            runnable2.run();
        }
        catch (Throwable e) {
            span.recordException(e);
            throw e;
        }
        finally {
            span.end();
        }
    }

    public <T> T call(String spanName, Callable<T> callable) throws Exception {
        Span span = this.delegate.spanBuilder(spanName).startSpan();
        try {
            T t;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    t = callable.call();
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        span.recordException(e);
                        throw e;
                    }
                }
                scope.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public SpanBuilder spanBuilder(String spanName) {
        return this.delegate.spanBuilder(spanName);
    }
}

