/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.util;

import io.micronaut.core.util.StringUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.validation.constraints.NotNull;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.grails.forge.client.github.v3.GitHubRepository;
import org.grails.forge.client.github.v3.GitHubUser;

public class GitHubUtil {
    public static final String INIT_COMMIT_MESSAGE = "Initial commit";

    public static void initAndPushToGitHubRepository(@NotNull GitHubRepository repository, @NotNull GitHubUser user, @NotNull Path localPath, @NotNull String authToken) throws IOException {
        try {
            String name = StringUtils.isEmpty(user.getName()) ? user.getLogin() : user.getName();
            String email = StringUtils.isEmpty(user.getEmail()) ? user.getLogin() : user.getEmail();
            Git gitRepo = Git.init().setDirectory(localPath.toFile()).call();
            gitRepo.add().addFilepattern(".").call();
            gitRepo.commit().setMessage(INIT_COMMIT_MESSAGE).setAuthor(name, email).setCommitter(name, email).setSign(false).call();
            Object pushResults = ((PushCommand)gitRepo.push().setRemote(repository.getCloneUrl()).setCredentialsProvider(new UsernamePasswordCredentialsProvider(user.getLogin(), authToken))).call();
            List failedRefUpdates = StreamSupport.stream(pushResults.spliterator(), false).flatMap(pushResult -> pushResult.getRemoteUpdates().stream()).filter(remoteRefUpdate -> remoteRefUpdate.getStatus() != RemoteRefUpdate.Status.OK).collect(Collectors.toList());
            if (!failedRefUpdates.isEmpty()) {
                throw new IOException(String.format("Failed to push to %s repository.", repository.getName()));
            }
        }
        catch (GitAPIException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

