/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.build.gradle;

import jakarta.inject.Singleton;
import java.util.function.Function;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Coordinate;
import org.grails.forge.build.dependencies.CoordinateResolver;
import org.grails.forge.build.dependencies.LookupFailedException;
import org.grails.forge.build.gradle.GradleBuild;
import org.grails.forge.build.gradle.GradleBuildCreator;
import org.grails.forge.feature.build.gradle.GradleSettingsFileFeature;
import org.grails.forge.feature.build.gradle.templates.settingsGradle;
import org.grails.forge.options.BuildTool;
import org.grails.forge.template.RockerTemplate;

@Singleton
public class GradleSettingsFile
implements GradleSettingsFileFeature {
    private final GradleBuildCreator dependencyResolver;
    private final CoordinateResolver resolver;

    public GradleSettingsFile(GradleBuildCreator dependencyResolver, CoordinateResolver resolver) {
        this.dependencyResolver = dependencyResolver;
        this.resolver = resolver;
    }

    @Override
    public String getName() {
        return "gradle-settings-file";
    }

    @Override
    public String getTitle() {
        return "Gradle Settings File";
    }

    @Override
    public String getDescription() {
        return "Add a Gradle settings file for multi-project builds or for applying settings plugins.";
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        BuildTool buildTool = BuildTool.DEFAULT_OPTION;
        GradleBuild build = this.dependencyResolver.create(generatorContext);
        String settingsFile = "settings.gradle";
        Function<String, Coordinate> coordinateResolver = artifactId -> this.resolver.resolve((String)artifactId).orElseThrow(() -> new LookupFailedException((String)artifactId));
        generatorContext.addTemplate("gradleSettings", new RockerTemplate(settingsFile, settingsGradle.template(generatorContext.getProject(), build, coordinateResolver, generatorContext.getFeatures())));
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }
}

