/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;

class BooleanExpressionTransformer {
    private final StaticCompilationTransformer transformer;

    BooleanExpressionTransformer(StaticCompilationTransformer transformer) {
        this.transformer = transformer;
    }

    Expression transformBooleanExpression(BooleanExpression boolX) {
        Expression expr = boolX;
        boolean reverse = false;
        do {
            if (!(expr instanceof NotExpression)) continue;
            boolean bl = reverse = !reverse;
        } while ((expr = ((BooleanExpression)expr).getExpression()) instanceof BooleanExpression);
        if (!(expr instanceof BinaryExpression)) {
            expr = new OptimizingBooleanExpression(this.transformer.transform(expr));
            if (reverse) {
                expr = new NotExpression(expr);
            }
            expr.setSourcePosition(boolX);
            return expr;
        }
        return this.transformer.superTransform(boolX);
    }

    private static class OptimizingBooleanExpression
    extends BooleanExpression {
        OptimizingBooleanExpression(Expression expression) {
            super(expression);
        }

        @Override
        public Expression transformExpression(ExpressionTransformer transformer) {
            OptimizingBooleanExpression opt = new OptimizingBooleanExpression(transformer.transform(this.getExpression()));
            opt.setSourcePosition(this);
            opt.copyNodeMetaData(this);
            return opt;
        }

        @Override
        public void visit(GroovyCodeVisitor visitor) {
            if (visitor instanceof AsmClassGenerator) {
                WriterController controller2 = ((AsmClassGenerator)visitor).getController();
                MethodVisitor mv = controller2.getMethodVisitor();
                OperandStack os = controller2.getOperandStack();
                int mark = os.getStackLength();
                this.getExpression().visit(visitor);
                ClassNode type = os.getTopOperand();
                if (ClassHelper.isPrimitiveType(type)) {
                    BytecodeHelper.convertPrimitiveToBoolean(mv, type);
                } else {
                    mv.visitInsn(89);
                    Label end = new Label();
                    Label asBoolean = new Label();
                    mv.visitJumpInsn(199, asBoolean);
                    mv.visitInsn(87);
                    mv.visitInsn(3);
                    mv.visitJumpInsn(167, end);
                    mv.visitLabel(asBoolean);
                    if (ClassHelper.isWrapperBoolean(type)) {
                        mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                    } else if (OptimizingBooleanExpression.replaceAsBooleanWithCompareToNull(type, controller2.getSourceUnit().getClassLoader())) {
                        mv.visitInsn(87);
                        mv.visitInsn(4);
                    } else {
                        os.castToBool(mark, true);
                    }
                    mv.visitLabel(end);
                }
                os.replace(ClassHelper.boolean_TYPE);
            } else {
                super.visit(visitor);
            }
        }

        private static boolean replaceAsBooleanWithCompareToNull(ClassNode type, ClassLoader dgmProvider) {
            ClassNode selfType;
            MethodNode theAsBoolean;
            List<MethodNode> asBoolean;
            return type.getMethod("asBoolean", Parameter.EMPTY_ARRAY) == null && (Modifier.isFinal(type.getModifiers()) || OptimizingBooleanExpression.isEffectivelyFinal(type.redirect())) && (asBoolean = StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(dgmProvider, type, "asBoolean", ClassNode.EMPTY_ARRAY)).size() == 1 && (theAsBoolean = asBoolean.get(0)) instanceof ExtensionMethodNode && ClassHelper.isObjectType(selfType = ((ExtensionMethodNode)theAsBoolean).getExtensionMethodNode().getParameters()[0].getType());
        }

        private static boolean isEffectivelyFinal(ClassNode type) {
            if (!Modifier.isPrivate(type.getModifiers())) {
                return false;
            }
            List<ClassNode> outers = type.getOuterClasses();
            ClassNode outer = outers.get(outers.size() - 1);
            return !OptimizingBooleanExpression.isExtended(type, outer.getInnerClasses());
        }

        private static boolean isExtended(ClassNode type, Iterator<? extends ClassNode> inners) {
            while (inners.hasNext()) {
                ClassNode next = inners.next();
                if (next != type && next.isDerivedFrom(type)) {
                    return true;
                }
                if (!OptimizingBooleanExpression.isExtended(type, next.getInnerClasses())) continue;
                return true;
            }
            return false;
        }
    }
}

