/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpClientFactory;
import io.micronaut.http.client.ProxyHttpClient;
import io.micronaut.http.client.ProxyHttpClientFactory;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.http.client.StreamingHttpClientFactory;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.client.sse.SseClientFactory;
import io.micronaut.websocket.WebSocketClient;
import io.micronaut.websocket.WebSocketClientFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

@Internal
public class NettyHttpClientFactory
implements HttpClientFactory,
SseClientFactory,
ProxyHttpClientFactory,
StreamingHttpClientFactory,
WebSocketClientFactory {
    @Override
    @NonNull
    public HttpClient createClient(URL url) {
        return this.createNettyClient(url);
    }

    @Override
    @NonNull
    public HttpClient createClient(URL url, @NonNull HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    @Override
    @NonNull
    public ProxyHttpClient createProxyClient(URL url) {
        return this.createNettyClient(url);
    }

    @Override
    @NonNull
    public ProxyHttpClient createProxyClient(URL url, @NonNull HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    @Override
    @NonNull
    public SseClient createSseClient(@Nullable URL url) {
        return this.createNettyClient(url);
    }

    @Override
    @NonNull
    public SseClient createSseClient(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    @Override
    @NonNull
    public StreamingHttpClient createStreamingClient(URL url) {
        return this.createNettyClient(url);
    }

    @Override
    @NonNull
    public StreamingHttpClient createStreamingClient(URL url, @NonNull HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    @Override
    @NonNull
    public WebSocketClient createWebSocketClient(URI uri) {
        return this.createNettyClient(uri);
    }

    @Override
    @NonNull
    public WebSocketClient createWebSocketClient(URI uri, @NonNull HttpClientConfiguration configuration) {
        return this.createNettyClient(uri, configuration);
    }

    private DefaultHttpClient createNettyClient(URL url) {
        try {
            return this.createNettyClient(url != null ? url.toURI() : null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private DefaultHttpClient createNettyClient(URL url, HttpClientConfiguration configuration) {
        try {
            return this.createNettyClient(url != null ? url.toURI() : null, configuration);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private DefaultHttpClient createNettyClient(URI uri) {
        return new DefaultHttpClient(uri);
    }

    private DefaultHttpClient createNettyClient(URI uri, HttpClientConfiguration configuration) {
        return new DefaultHttpClient(uri, configuration);
    }
}

