/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.Named;
import io.micronaut.core.value.ValueResolver;
import java.util.Optional;

@Internal
final class ServiceHttpClientCondition
implements Condition {
    ServiceHttpClientCondition() {
    }

    @Override
    public boolean matches(ConditionContext context) {
        Object component = context.getComponent();
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext) {
            Optional<String> optional;
            Environment env = ((ApplicationContext)beanContext).getEnvironment();
            if (component instanceof ValueResolver && (optional = ((ValueResolver)component).get(Named.class.getName(), String.class)).isPresent()) {
                String serviceName = optional.get();
                String urlProp = "micronaut.http.services." + serviceName + ".url";
                return env.containsProperty(urlProp) || env.containsProperty(urlProp + "s");
            }
        }
        return true;
    }
}

