/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.internal;

import java.util.regex.Pattern;

public class LogMessageRegex {
    private static final String REGEX = "^\\[" + (Object)((Object)Group.LOG_LEVEL) + " " + (Object)((Object)Group.DATE) + " " + (Object)((Object)Group.TIME) + " " + (Object)((Object)Group.TIME_ZONE) + " " + (Object)((Object)Group.MEMBER_NAME) + "[\\s]?" + (Object)((Object)Group.THREAD_NAME) + " " + (Object)((Object)Group.THREAD_ID) + "] " + (Object)((Object)Group.MESSAGE) + "$";

    public static String getRegex() {
        return REGEX;
    }

    public static Pattern getPattern() {
        return Pattern.compile(REGEX);
    }

    public static enum Group {
        LOG_LEVEL(1, "logLevel", "(?<logLevel>[a-z]+)"),
        DATE(2, "date", "(?<date>\\d{4}\\/\\d{2}\\/\\d{2})"),
        TIME(3, "time", "(?<time>\\d{2}:\\d{2}:\\d{2}\\.\\d{3})"),
        TIME_ZONE(4, "timeZone", "(?<timeZone>[^ ]{3})"),
        MEMBER_NAME(5, "memberName", "(?:(?<memberName>(?:[0-9a-zA-Z]*(?:\\s[0-9a-zA-Z]+)?)*)?)"),
        THREAD_NAME(6, "threadName", "(?<threadName>\\<.+\\>)"),
        THREAD_ID(7, "threadId", "(?<threadId>tid=0[xX][0-9a-fA-F]+)"),
        MESSAGE(8, "message", "(?<message>.*)");

        private final int index;
        private final String name;
        private final String regex;

        private Group(int index, String name, String regex) {
            this.index = index;
            this.name = name;
            this.regex = regex;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getRegex() {
            return this.regex;
        }

        public String toString() {
            return this.regex;
        }
    }
}

