/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.TypeInformationRawType;

@Internal
public class RawObjectConverter<T>
implements DataStructureConverter<RawValueData<T>, T> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> serializer;

    private RawObjectConverter(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public RawValueData<T> toInternal(T external) {
        return RawValueData.fromObject(external);
    }

    @Override
    public T toExternal(RawValueData<T> internal) {
        return (T)internal.toObject(this.serializer);
    }

    public static RawObjectConverter<?> create(DataType dataType) {
        LogicalType logicalType = dataType.getLogicalType();
        TypeSerializer serializer = logicalType instanceof TypeInformationRawType ? ((TypeInformationRawType)logicalType).getTypeInformation().createSerializer((SerializerConfig)new SerializerConfigImpl()) : ((RawType)dataType.getLogicalType()).getTypeSerializer();
        return new RawObjectConverter(serializer);
    }
}

