/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.eventmesh.connector.jdbc.utils;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;

import org.junit.jupiter.api.Test;

public class MysqlUtilsTest {

    @Test
    public void testWrapperWithTableId() {
        TableId mockTableId = mock(TableId.class);
        when(mockTableId.getTableName()).thenReturn("test_table");
        when(mockTableId.getCatalogName()).thenReturn("test_table");

        String wrapped = MysqlUtils.wrapper(mockTableId);

        assertEquals("`test_table`.`test_table`", wrapped);
    }

    @Test
    public void testWrapperWithString() {
        String wrapped = MysqlUtils.wrapper("test_string");

        assertEquals("`test_string`", wrapped);
    }
}
