/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.security.auth;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.security.auth.EmptyTokenProviderImpl;
import io.pravega.client.security.auth.JwtTokenProviderImpl;
import io.pravega.client.security.auth.StringTokenProviderImpl;
import io.pravega.client.segment.impl.Segment;
import io.pravega.shared.security.auth.AccessOperation;
import lombok.NonNull;

public class DelegationTokenProviderFactory {
    @VisibleForTesting
    public static DelegationTokenProvider createWithEmptyToken() {
        return new EmptyTokenProviderImpl();
    }

    @VisibleForTesting
    public static DelegationTokenProvider create(Controller controller, String scopeName, String streamName, AccessOperation accessOperation) {
        return DelegationTokenProviderFactory.create(null, controller, scopeName, streamName, accessOperation);
    }

    public static DelegationTokenProvider create(Controller controller, Segment segment, AccessOperation accessOperation) {
        return DelegationTokenProviderFactory.create(null, controller, segment, accessOperation);
    }

    public static DelegationTokenProvider create(String delegationToken, @NonNull Controller controller, @NonNull Segment segment, AccessOperation accessOperation) {
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        return DelegationTokenProviderFactory.create(delegationToken, controller, segment.getScope(), segment.getStreamName(), accessOperation);
    }

    public static DelegationTokenProvider create(String delegationToken, Controller controller, String scopeName, String streamName, AccessOperation accessOperation) {
        if (delegationToken == null) {
            return new JwtTokenProviderImpl(controller, scopeName, streamName, accessOperation);
        }
        if (delegationToken.equals("")) {
            return new EmptyTokenProviderImpl();
        }
        if (delegationToken.split("\\.").length == 3) {
            return new JwtTokenProviderImpl(delegationToken, controller, scopeName, streamName, accessOperation);
        }
        return new StringTokenProviderImpl(delegationToken);
    }
}

