/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.core;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.FieldProxy;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.redisson.RedissonObject;
import org.redisson.RedissonReference;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonSetMultimap;
import org.redisson.api.RLiveObject;
import org.redisson.api.RMap;
import org.redisson.api.RObject;
import org.redisson.api.annotation.REntity;
import org.redisson.api.annotation.RIndex;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.liveobject.core.LiveObjectInterceptor;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.liveobject.misc.Introspectior;
import org.redisson.liveobject.resolver.MapResolver;
import org.redisson.liveobject.resolver.NamingScheme;

public class AccessorInterceptor {
    private static final Pattern GETTER_PATTERN = Pattern.compile("^(get|is)");
    private static final Pattern SETTER_PATTERN = Pattern.compile("^(set)");
    private static final Pattern FIELD_PATTERN = Pattern.compile("^(get|set|is)");
    private final CommandAsyncExecutor commandExecutor;
    private final Class<?> entityClass;
    private final MapResolver mapResolver;
    private static final Set<Class<?>> PRIMITIVE_CLASSES = new HashSet<Class>(Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));

    public AccessorInterceptor(Class<?> entityClass, CommandAsyncExecutor commandExecutor, MapResolver mapResolver) {
        this.entityClass = entityClass;
        this.commandExecutor = commandExecutor;
        this.mapResolver = mapResolver;
    }

    @RuntimeType
    public Object intercept(@Origin Method method, @SuperCall Callable<?> superMethod, @AllArguments Object[] args, @This Object me, @FieldProxy(value="liveObjectLiveMap") LiveObjectInterceptor.Setter mapSetter, @FieldProxy(value="liveObjectLiveMap") LiveObjectInterceptor.Getter mapGetter) throws Exception {
        if (this.isGetter(method, AccessorInterceptor.getREntityIdFieldName(me))) {
            return ((RLiveObject)me).getLiveObjectId();
        }
        if (this.isSetter(method, AccessorInterceptor.getREntityIdFieldName(me))) {
            ((RLiveObject)me).setLiveObjectId(args[0]);
            return null;
        }
        Object id = ((RLiveObject)me).getLiveObjectId();
        RMap liveMap = this.mapResolver.resolve(this.commandExecutor, this.entityClass, id, mapSetter, mapGetter);
        String fieldName = this.getFieldName(me.getClass().getSuperclass(), method);
        Field field = ClassUtils.getDeclaredField(me.getClass().getSuperclass(), fieldName);
        Class<?> fieldType = field.getType();
        if (this.isGetter(method, fieldName)) {
            RObject ar;
            if (Modifier.isTransient(field.getModifiers())) {
                return field.get(me);
            }
            Object result = liveMap.get(fieldName);
            if (result == null && (ar = this.commandExecutor.getObjectBuilder().createObject(((RLiveObject)me).getLiveObjectId(), me.getClass().getSuperclass(), fieldType, fieldName)) != null) {
                this.commandExecutor.getObjectBuilder().store(ar, fieldName, liveMap);
                return ar;
            }
            if (result != null && fieldType.isEnum()) {
                if (result instanceof String) {
                    return Enum.valueOf(fieldType, (String)result);
                }
                return result;
            }
            if (result instanceof RedissonReference) {
                return this.commandExecutor.getObjectBuilder().fromReference((RedissonReference)result, RedissonObjectBuilder.ReferenceType.DEFAULT);
            }
            return result;
        }
        if (this.isSetter(method, fieldName)) {
            Object arg = args[0];
            if (Modifier.isTransient(field.getModifiers())) {
                field.set(me, arg);
                return me;
            }
            if (arg != null && ClassUtils.isAnnotationPresent(arg.getClass(), REntity.class)) {
                throw new IllegalStateException("REntity object should be attached to Redisson first");
            }
            if (arg instanceof RLiveObject) {
                RLiveObject liveObject = (RLiveObject)arg;
                this.removeIndex(liveMap, me, field);
                this.storeIndex(field, me, liveObject.getLiveObjectId());
                if (this.commandExecutor instanceof CommandBatchService) {
                    liveMap.fastPutAsync(fieldName, liveObject);
                } else {
                    liveMap.fastPut(fieldName, liveObject);
                }
                return me;
            }
            if (!(arg instanceof RObject) && (arg instanceof Collection || arg instanceof Map) && REntity.TransformationMode.ANNOTATION_BASED.equals((Object)ClassUtils.getAnnotation(me.getClass().getSuperclass(), REntity.class).fieldTransformation())) {
                RObject rObject = this.commandExecutor.getObjectBuilder().createObject(((RLiveObject)me).getLiveObjectId(), me.getClass().getSuperclass(), arg.getClass(), fieldName);
                if (arg != null) {
                    if (rObject instanceof Collection) {
                        Collection c = (Collection)((Object)rObject);
                        c.clear();
                        c.addAll((Collection)arg);
                    } else {
                        Map m = (Map)((Object)rObject);
                        m.clear();
                        m.putAll((Map)arg);
                    }
                }
                if (rObject != null) {
                    arg = rObject;
                }
            }
            if (arg instanceof RObject) {
                if (this.commandExecutor instanceof CommandBatchService) {
                    this.commandExecutor.getObjectBuilder().storeAsync((RObject)arg, fieldName, liveMap);
                } else {
                    this.commandExecutor.getObjectBuilder().store((RObject)arg, fieldName, liveMap);
                }
                return me;
            }
            this.removeIndex(liveMap, me, field);
            if (arg != null) {
                this.storeIndex(field, me, arg);
                if (this.commandExecutor instanceof CommandBatchService) {
                    liveMap.fastPutAsync(fieldName, arg);
                } else {
                    liveMap.fastPut(fieldName, arg);
                }
            } else if (field.getAnnotation(RIndex.class) == null) {
                if (this.commandExecutor instanceof CommandBatchService) {
                    liveMap.removeAsync(fieldName);
                } else {
                    liveMap.remove(fieldName);
                }
            }
            return me;
        }
        return superMethod.call();
    }

    private void removeIndex(RMap<String, Object> liveMap, Object me, Field field) {
        if (field.getAnnotation(RIndex.class) == null) {
            return;
        }
        NamingScheme namingScheme = this.commandExecutor.getObjectBuilder().getNamingScheme(me.getClass().getSuperclass());
        String indexName = namingScheme.getIndexName(me.getClass().getSuperclass(), field.getName());
        CommandBatchService ce = this.commandExecutor instanceof CommandBatchService ? (CommandBatchService)this.commandExecutor : new CommandBatchService(this.commandExecutor);
        if (Number.class.isAssignableFrom(field.getType()) || PRIMITIVE_CLASSES.contains(field.getType())) {
            RedissonScoredSortedSet<Object> set = new RedissonScoredSortedSet<Object>(namingScheme.getCodec(), ce, indexName, null);
            set.removeAsync(((RLiveObject)me).getLiveObjectId());
        } else if (ClassUtils.isAnnotationPresent(field.getType(), REntity.class) || this.commandExecutor.getServiceManager().getCfg().isClusterConfig()) {
            CompletableFuture<Object> f;
            if (this.commandExecutor instanceof CommandBatchService) {
                f = liveMap.getAsync(field.getName()).toCompletableFuture();
            } else {
                Object value2 = liveMap.get(field.getName());
                f = CompletableFuture.completedFuture(value2);
            }
            f.thenAccept(value -> {
                if (value != null) {
                    RedissonSetMultimap map = new RedissonSetMultimap(namingScheme.getCodec(), ce, indexName);
                    Object k = value;
                    if (ClassUtils.isAnnotationPresent(field.getType(), REntity.class)) {
                        k = ((RLiveObject)value).getLiveObjectId();
                    }
                    map.removeAsync(k, ((RLiveObject)me).getLiveObjectId());
                }
            });
        } else {
            this.removeAsync(ce, indexName, ((RedissonObject)((Object)liveMap)).getRawName(), namingScheme.getCodec(), ((RLiveObject)me).getLiveObjectId(), field.getName());
        }
        if (ce != this.commandExecutor) {
            ce.execute();
        }
    }

    private void removeAsync(CommandBatchService ce, String name, String mapName, Codec codec, Object value, String fieldName) {
        ByteBuf valueState = ce.encodeMapValue(codec, value);
        ce.evalWriteAsync(name, codec, RedisCommands.EVAL_VOID, "local oldArg = redis.call('hget', KEYS[2], ARGV[2]);if oldArg == false then return; end;local hash = redis.call('hget', KEYS[1], oldArg); local setName = KEYS[1] .. ':' .. hash; local res = redis.call('srem', setName, ARGV[1]); if res == 1 and redis.call('scard', setName) == 0 then redis.call('hdel', KEYS[1], oldArg); end; ", Arrays.asList(name, mapName), valueState, ce.encodeMapKey(codec, fieldName));
    }

    private void storeIndex(Field field, Object me, Object arg) {
        CommandBatchService ce;
        if (field.getAnnotation(RIndex.class) == null) {
            return;
        }
        NamingScheme namingScheme = this.commandExecutor.getObjectBuilder().getNamingScheme(me.getClass().getSuperclass());
        String indexName = namingScheme.getIndexName(me.getClass().getSuperclass(), field.getName());
        boolean skipExecution = false;
        if (this.commandExecutor instanceof CommandBatchService) {
            ce = (CommandBatchService)this.commandExecutor;
            skipExecution = true;
        } else {
            ce = new CommandBatchService(this.commandExecutor);
        }
        if (arg instanceof Number) {
            RedissonScoredSortedSet<Object> set = new RedissonScoredSortedSet<Object>(namingScheme.getCodec(), ce, indexName, null);
            set.addAsync(((Number)arg).doubleValue(), ((RLiveObject)me).getLiveObjectId());
        } else {
            RedissonSetMultimap<Object, Object> map = new RedissonSetMultimap<Object, Object>(namingScheme.getCodec(), ce, indexName);
            map.putAsync(arg, ((RLiveObject)me).getLiveObjectId());
        }
        if (!skipExecution) {
            ce.execute();
        }
    }

    private String getFieldName(Class<?> clazz, Method method) {
        String fieldName = FIELD_PATTERN.matcher(method.getName()).replaceFirst("");
        String propName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
        try {
            ClassUtils.getDeclaredField(clazz, propName);
            return propName;
        }
        catch (NoSuchFieldException e) {
            return fieldName;
        }
    }

    private boolean isGetter(Method method, String fieldName) {
        return GETTER_PATTERN.matcher(method.getName()).replaceFirst("").equalsIgnoreCase(fieldName);
    }

    private boolean isSetter(Method method, String fieldName) {
        return SETTER_PATTERN.matcher(method.getName()).replaceFirst("").equalsIgnoreCase(fieldName);
    }

    private static String getREntityIdFieldName(Object o) {
        return Introspectior.getREntityIdFieldName(o.getClass().getSuperclass());
    }
}

