/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.util.concurrent.ThreadLocalRandom;

public class LockOptions {
    public static BackOff defaults() {
        return new ExponentialBackOff();
    }

    public static class ExponentialBackOff
    implements BackOff {
        private long maxDelay = 128L;
        private long initialDelay = 1L;
        private int multiplier = 2;

        @Override
        public BackOffPolicy create() {
            return new ExponentialBackOffPolicy(this.initialDelay, this.maxDelay, this.multiplier);
        }

        public ExponentialBackOff maxDelay(long maxDelay) {
            if (maxDelay <= 0L) {
                throw new IllegalArgumentException("maxDelay should be positive");
            }
            this.maxDelay = maxDelay;
            return this;
        }

        public long getMaxDelay() {
            return this.maxDelay;
        }

        public ExponentialBackOff initialDelay(long initialDelay) {
            if (initialDelay <= 0L) {
                throw new IllegalArgumentException("initialDelay should be positive");
            }
            this.initialDelay = initialDelay;
            return this;
        }

        public long getInitialDelay() {
            return this.initialDelay;
        }

        public ExponentialBackOff multiplier(int multiplier) {
            if (multiplier <= 0) {
                throw new IllegalArgumentException("multiplier should be positive");
            }
            this.multiplier = multiplier;
            return this;
        }

        public int getMultiplier() {
            return this.multiplier;
        }
    }

    private static final class ConstantBackOffPolicy
    implements BackOffPolicy {
        private final long delay;

        private ConstantBackOffPolicy(long delay) {
            this.delay = delay;
        }

        @Override
        public long getNextSleepPeriod() {
            return this.delay;
        }
    }

    public static class ConstantBackOff
    implements BackOff {
        private long delay = 64L;

        @Override
        public BackOffPolicy create() {
            return new ConstantBackOffPolicy(this.delay);
        }

        public ConstantBackOff delay(long delay) {
            if (delay <= 0L) {
                throw new IllegalArgumentException("delay should be positive");
            }
            this.delay = delay;
            return this;
        }

        public long getDelay() {
            return this.delay;
        }
    }

    private static final class ExponentialBackOffPolicy
    implements BackOffPolicy {
        private final long maxDelay;
        private final int multiplier;
        private int fails;
        private long nextSleep;

        private ExponentialBackOffPolicy(long initialDelay, long maxDelay, int multiplier) {
            this.nextSleep = initialDelay;
            this.maxDelay = maxDelay;
            this.multiplier = multiplier;
        }

        @Override
        public long getNextSleepPeriod() {
            if (this.nextSleep == this.maxDelay) {
                return this.maxDelay;
            }
            long result = this.nextSleep;
            this.nextSleep = this.nextSleep * (long)this.multiplier + (long)ThreadLocalRandom.current().nextInt(++this.fails);
            this.nextSleep = Math.min(this.maxDelay, this.nextSleep);
            return result;
        }
    }

    public static interface BackOffPolicy {
        public long getNextSleepPeriod();
    }

    public static interface BackOff {
        public BackOffPolicy create();
    }
}

