/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.objectfactory;

import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.plugin.RequestRecorderFactory;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.DataSourceMonitorRegistry;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.metric.CustomMetricRegistry;
import com.navercorp.pinpoint.profiler.context.monitor.DataSourceMonitorRegistryAdaptor;
import com.navercorp.pinpoint.profiler.context.monitor.DataSourceMonitorRegistryService;
import com.navercorp.pinpoint.profiler.context.monitor.metric.CustomMetricRegistryAdaptor;
import com.navercorp.pinpoint.profiler.context.monitor.metric.CustomMetricRegistryService;
import com.navercorp.pinpoint.profiler.interceptor.factory.AnnotatedInterceptorFactory;
import com.navercorp.pinpoint.profiler.interceptor.factory.ExceptionHandlerFactory;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.objectfactory.ArgumentProvider;
import com.navercorp.pinpoint.profiler.objectfactory.AutoBindingObjectFactory;
import com.navercorp.pinpoint.profiler.objectfactory.InterceptorArgumentProvider;
import java.util.Objects;

public class ObjectBinderFactory {
    private final ProfilerConfig profilerConfig;
    private final Provider<TraceContext> traceContextProvider;
    private final DataSourceMonitorRegistry dataSourceMonitorRegistry;
    private final CustomMetricRegistry customMetricRegistry;
    private final Provider<ApiMetaDataService> apiMetaDataServiceProvider;
    private final ExceptionHandlerFactory exceptionHandlerFactory;
    private final RequestRecorderFactory requestRecorderFactory;

    public ObjectBinderFactory(ProfilerConfig profilerConfig, Provider<TraceContext> traceContextProvider, DataSourceMonitorRegistryService dataSourceMonitorRegistryService, CustomMetricRegistryService customMonitorRegistryService, Provider<ApiMetaDataService> apiMetaDataServiceProvider, ExceptionHandlerFactory exceptionHandlerFactory, RequestRecorderFactory requestRecorderFactory) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.traceContextProvider = Objects.requireNonNull(traceContextProvider, "traceContextProvider");
        Objects.requireNonNull(dataSourceMonitorRegistryService, "dataSourceMonitorRegistryService");
        this.dataSourceMonitorRegistry = new DataSourceMonitorRegistryAdaptor(dataSourceMonitorRegistryService);
        Objects.requireNonNull(customMonitorRegistryService, "customMonitorRegistryService");
        this.customMetricRegistry = new CustomMetricRegistryAdaptor(customMonitorRegistryService);
        this.apiMetaDataServiceProvider = Objects.requireNonNull(apiMetaDataServiceProvider, "apiMetaDataServiceProvider");
        this.exceptionHandlerFactory = Objects.requireNonNull(exceptionHandlerFactory, "exceptionHandlerFactory");
        this.requestRecorderFactory = Objects.requireNonNull(requestRecorderFactory, "requestRecorderFactory");
    }

    public AutoBindingObjectFactory newAutoBindingObjectFactory(InstrumentContext pluginContext, ClassLoader classLoader, ArgumentProvider ... argumentProviders) {
        TraceContext traceContext = (TraceContext)this.traceContextProvider.get();
        return new AutoBindingObjectFactory(this.profilerConfig, traceContext, pluginContext, classLoader, argumentProviders);
    }

    public InterceptorArgumentProvider newInterceptorArgumentProvider() {
        ApiMetaDataService apiMetaDataService = (ApiMetaDataService)this.apiMetaDataServiceProvider.get();
        return new InterceptorArgumentProvider(this.dataSourceMonitorRegistry, this.customMetricRegistry, apiMetaDataService, this.requestRecorderFactory);
    }

    public AnnotatedInterceptorFactory newAnnotatedInterceptorFactory(InstrumentContext pluginContext) {
        TraceContext traceContext = (TraceContext)this.traceContextProvider.get();
        ApiMetaDataService apiMetaDataService = (ApiMetaDataService)this.apiMetaDataServiceProvider.get();
        return new AnnotatedInterceptorFactory(this.profilerConfig, traceContext, this.dataSourceMonitorRegistry, this.customMetricRegistry, apiMetaDataService, pluginContext, this.exceptionHandlerFactory, this.requestRecorderFactory);
    }
}

