/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.transformer;

import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.profiler.instrument.classreading.InternalClassMetadata;
import com.navercorp.pinpoint.profiler.instrument.transformer.DebugTransformer;
import com.navercorp.pinpoint.profiler.instrument.transformer.TransformerRegistry;
import java.lang.instrument.ClassFileTransformer;
import java.util.Objects;

public class DebugTransformerRegistry
implements TransformerRegistry {
    private final Filter<String> debugTargetFilter;
    private final DebugTransformer debugTransformer;

    public DebugTransformerRegistry(Filter<String> debugTargetFilter, DebugTransformer debugTransformer) {
        this.debugTargetFilter = Objects.requireNonNull(debugTargetFilter, "debugTargetFilter");
        this.debugTransformer = Objects.requireNonNull(debugTransformer, "debugTransformer");
    }

    @Override
    public ClassFileTransformer findTransformer(ClassLoader classLoader, String classInternalName, byte[] classFileBuffer) {
        return this.findTransformer(classLoader, classInternalName, classFileBuffer, null);
    }

    @Override
    public ClassFileTransformer findTransformer(ClassLoader classLoader, String classInternalName, byte[] classFileBuffer, InternalClassMetadata classMetadata) {
        Objects.requireNonNull(classInternalName, "classInternalName");
        if (this.debugTargetFilter.filter((Object)classInternalName)) {
            return this.debugTransformer;
        }
        return null;
    }
}

