/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.mapper;

import com.navercorp.pinpoint.grpc.trace.PMonitorInfo;
import com.navercorp.pinpoint.grpc.trace.PThreadDump;
import com.navercorp.pinpoint.grpc.trace.PThreadState;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.MonitorInfoMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.ThreadDumpMetricSnapshot;
import org.mapstruct.AfterMapping;
import org.mapstruct.CollectionMappingStrategy;
import org.mapstruct.EnumMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValueCheckStrategy;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.ValueMapping;

@Mapper(collectionMappingStrategy=CollectionMappingStrategy.ADDER_PREFERRED, nullValueCheckStrategy=NullValueCheckStrategy.ALWAYS, nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE, uses={})
public interface ThreadDumpMapper {
    @Mappings(value={@Mapping(source="threadState", target="threadState"), @Mapping(source="stackTrace", target="stackTrace", ignore=true), @Mapping(source="lockedMonitors", target="lockedMonitor"), @Mapping(source="lockedSynchronizers", target="lockedSynchronizer", ignore=true)})
    public PThreadDump map(ThreadDumpMetricSnapshot var1);

    @AfterMapping
    default public void addAll(ThreadDumpMetricSnapshot snapshot, @MappingTarget PThreadDump.Builder builder) {
        for (String stackTrace : snapshot.getStackTrace()) {
            builder.addStackTrace(stackTrace);
        }
        for (String lockedSynchronizer : snapshot.getLockedSynchronizers()) {
            builder.addLockedSynchronizer(lockedSynchronizer);
        }
    }

    @EnumMapping(nameTransformationStrategy="prefix", configuration="THREAD_STATE_")
    @ValueMapping(source="<ANY_REMAINING>", target="THREAD_STATE_UNKNOWN")
    public PThreadState map(Thread.State var1);

    public PMonitorInfo map(MonitorInfoMetricSnapshot var1);
}

