/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.mapper;

import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.grpc.trace.PException;
import com.navercorp.pinpoint.grpc.trace.PExceptionMetaData;
import com.navercorp.pinpoint.grpc.trace.PStackTraceElement;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionMetaData;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionWrapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.TraceIdMapStructUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mapstruct.CollectionMappingStrategy;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.NullValueCheckStrategy;

@Mapper(collectionMappingStrategy=CollectionMappingStrategy.ADDER_PREFERRED, nullValueCheckStrategy=NullValueCheckStrategy.ALWAYS, uses={TraceIdMapStructUtils.class})
public interface ExceptionMetaDataMapper {
    public static final String EMPTY_STRING = "";
    public static final PExceptionMetaData.Builder pExceptionMetaDataBuilder = PExceptionMetaData.newBuilder();
    public static final PException.Builder pExceptionBuilder = PException.newBuilder();
    public static final PStackTraceElement.Builder pStackTraceElementBuilder = PStackTraceElement.newBuilder();

    default public PExceptionMetaData.Builder getpExceptionMetaDataBuilder() {
        PExceptionMetaData.Builder builder = pExceptionMetaDataBuilder;
        builder.clear();
        return builder;
    }

    default public PException.Builder getpExceptionBuilder() {
        PException.Builder builder = pExceptionBuilder;
        builder.clear();
        return builder;
    }

    default public PStackTraceElement.Builder getpStackTraceElementBuilder() {
        PStackTraceElement.Builder builder = pStackTraceElementBuilder;
        builder.clear();
        return builder;
    }

    @Mappings(value={@Mapping(source="exceptionWrappers", target="exceptions"), @Mapping(source="traceRoot.traceId", target="transactionId", qualifiedBy={TraceIdMapStructUtils.ToTransactionId.class}), @Mapping(source="traceRoot.traceId.spanId", target="spanId"), @Mapping(source="traceRoot.shared.uriTemplate", target="uriTemplate")})
    public PExceptionMetaData toProto(ExceptionMetaData var1);

    default public PException toProto(ExceptionWrapper model) {
        if (model == null) {
            return null;
        }
        PException.Builder pException = PException.newBuilder();
        if (model.getStackTraceElements() != null) {
            pException.addAllStackTraceElement(this.toStackTraceElements(model.getStackTraceElements()));
        }
        if (model.getExceptionClassName() != null) {
            pException.setExceptionClassName(model.getExceptionClassName());
        }
        if (model.getExceptionMessage() != null) {
            pException.setExceptionMessage(model.getExceptionMessage());
        }
        pException.setStartTime(model.getStartTime());
        pException.setExceptionId(model.getExceptionId());
        pException.setExceptionDepth(model.getExceptionDepth());
        return pException.build();
    }

    @Named(value="toStackTraceElements")
    default public List<PStackTraceElement> toStackTraceElements(StackTraceElement[] value) {
        if (ArrayUtils.hasLength((Object[])value)) {
            ArrayList<PStackTraceElement> pStackTraceElements = new ArrayList<PStackTraceElement>();
            for (StackTraceElement stackTraceElement : value) {
                pStackTraceElements.add(this.toProto(stackTraceElement));
            }
            return pStackTraceElements;
        }
        return Collections.emptyList();
    }

    @Mappings(value={@Mapping(source="className", target="className", defaultValue=""), @Mapping(source="fileName", target="fileName", defaultValue=""), @Mapping(source="lineNumber", target="lineNumber", defaultValue=""), @Mapping(source="methodName", target="methodName", defaultValue="")})
    public PStackTraceElement toProto(StackTraceElement var1);
}

