/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.context.CallStack;
import com.navercorp.pinpoint.profiler.context.CloseListener;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.scope.DefaultTraceScopePool;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultTrace
implements Trace {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    private final CallStack<SpanEvent> callStack;
    private final Storage storage;
    private final SpanRecorder spanRecorder;
    private final WrappedSpanEventRecorder wrappedSpanEventRecorder;
    private boolean closed = false;
    private DefaultTraceScopePool scopePool;
    private final Span span;
    private final CloseListener closeListener;

    public DefaultTrace(Span span, CallStack<SpanEvent> callStack, Storage storage, SpanRecorder spanRecorder, WrappedSpanEventRecorder wrappedSpanEventRecorder) {
        this(span, callStack, storage, spanRecorder, wrappedSpanEventRecorder, CloseListener.EMPTY);
    }

    public DefaultTrace(Span span, CallStack<SpanEvent> callStack, Storage storage, SpanRecorder spanRecorder, WrappedSpanEventRecorder wrappedSpanEventRecorder, CloseListener closeListener) {
        this.span = Objects.requireNonNull(span, "span");
        this.callStack = Objects.requireNonNull(callStack, "callStack");
        this.storage = Objects.requireNonNull(storage, "storage");
        this.spanRecorder = Objects.requireNonNull(spanRecorder, "spanRecorder");
        this.wrappedSpanEventRecorder = Objects.requireNonNull(wrappedSpanEventRecorder, "wrappedSpanEventRecorder");
        this.closeListener = closeListener;
        this.setCurrentThread();
    }

    private void setCurrentThread() {
        long threadId = Thread.currentThread().getId();
        this.getTraceRoot().getShared().setThreadId(threadId);
    }

    private TraceRoot getTraceRoot() {
        return this.span.getTraceRoot();
    }

    private SpanEventRecorder wrappedSpanEventRecorder(WrappedSpanEventRecorder wrappedSpanEventRecorder, SpanEvent spanEvent) {
        wrappedSpanEventRecorder.setWrapped(spanEvent);
        return wrappedSpanEventRecorder;
    }

    public SpanEventRecorder traceBlockBegin() {
        return this.traceBlockBegin(-1);
    }

    public SpanEventRecorder traceBlockBegin(int stackId) {
        SpanEvent spanEvent = this.traceBlockBegin0(stackId);
        return this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, spanEvent);
    }

    private SpanEvent traceBlockBegin0(int stackId) {
        if (this.closed) {
            if (this.logger.isWarnEnabled()) {
                this.stackDump("already closed trace");
            }
            return this.dummySpanEvent();
        }
        SpanEvent spanEvent = this.newSpanEvent(stackId);
        this.callStack.push(spanEvent);
        return spanEvent;
    }

    private void stackDump(String caused) {
        PinpointException exception = new PinpointException(caused);
        this.logger.warn("Corrupted call stack found TraceRoot:{}, CallStack:{}", (Object)this.getTraceRoot(), this.callStack, (Object)exception);
    }

    public void traceBlockEnd() {
        this.traceBlockEnd(-1);
    }

    public void traceBlockEnd(int stackId) {
        if (this.closed) {
            if (this.logger.isWarnEnabled()) {
                this.stackDump("already closed trace");
            }
            return;
        }
        SpanEvent spanEvent = this.callStack.pop();
        if (spanEvent == null) {
            if (this.logger.isWarnEnabled()) {
                this.stackDump("call stack is empty.");
            }
            return;
        }
        if (this.isDummySpanEvent(spanEvent)) {
            if (this.isDebug) {
                this.logger.debug("[{}] Skip dummy spanEvent", (Object)this);
            }
            return;
        }
        if (spanEvent.getStackId() != stackId && this.logger.isWarnEnabled()) {
            this.stackDump("not matched stack id. expected=" + stackId + ", current=" + spanEvent.getStackId());
        }
        if (spanEvent.isTimeRecording()) {
            spanEvent.markAfterTime();
        }
        this.logSpan(spanEvent);
        SpanEvent previous = this.callStack.peek();
        this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, previous);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.closed) {
            this.logger.warn("Already closed {}", (Object)this);
            return;
        }
        this.closed = true;
        long afterTime = System.currentTimeMillis();
        if (!this.callStack.empty()) {
            if (this.logger.isWarnEnabled()) {
                this.stackDump("not empty call stack");
            }
        } else {
            if (this.span.isTimeRecording()) {
                this.span.markAfterTime(afterTime);
            }
            this.logSpan();
        }
        this.wrappedSpanEventRecorder.close();
        this.storage.close();
        this.closeListener.close(afterTime);
    }

    protected void flush() {
        this.storage.flush();
        this.closed = true;
    }

    public TraceId getTraceId() {
        return this.getTraceRoot().getTraceId();
    }

    public long getId() {
        return this.getTraceRoot().getLocalTransactionId();
    }

    public long getStartTime() {
        return this.getTraceRoot().getTraceStartTime();
    }

    public boolean canSampled() {
        return true;
    }

    public boolean isRoot() {
        return this.getTraceId().isRoot();
    }

    private void logSpan(SpanEvent spanEvent) {
        this.storage.store(spanEvent);
    }

    private void logSpan() {
        this.storage.store(this.span);
    }

    public boolean isAsync() {
        return false;
    }

    public boolean isRootStack() {
        return this.callStack.empty();
    }

    public SpanRecorder getSpanRecorder() {
        return this.spanRecorder;
    }

    public SpanEventRecorder currentSpanEventRecorder() {
        SpanEvent spanEvent = this.callStack.peek();
        if (spanEvent == null) {
            if (this.logger.isWarnEnabled()) {
                this.stackDump("call stack is empty");
            }
            spanEvent = this.dummySpanEvent();
        }
        return this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, spanEvent);
    }

    private SpanEvent newSpanEvent(int stackId) {
        SpanEvent spanEvent = this.callStack.newInstance();
        spanEvent.markStartTime();
        spanEvent.setStackId(stackId);
        return spanEvent;
    }

    @VisibleForTesting
    SpanEvent dummySpanEvent() {
        return this.callStack.disableInstance();
    }

    @VisibleForTesting
    boolean isDummySpanEvent(SpanEvent spanEvent) {
        return this.callStack.isDisable(spanEvent);
    }

    public int getCallStackFrameId() {
        SpanEvent spanEvent = this.callStack.peek();
        if (spanEvent == null) {
            return 0;
        }
        return spanEvent.getStackId();
    }

    public TraceScope getScope(String name) {
        if (this.scopePool == null) {
            return null;
        }
        return this.scopePool.get(name);
    }

    public TraceScope addScope(String name) {
        if (this.scopePool == null) {
            this.scopePool = new DefaultTraceScopePool();
        }
        return this.scopePool.add(name);
    }

    public String toString() {
        return "DefaultTrace{traceRoot=" + this.getTraceRoot() + '}';
    }
}

