/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.node;

import com.alibaba.druid.pool.ha.PropertiesUtils;
import com.alibaba.druid.pool.ha.node.NodeEventTypeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class NodeEvent {
    private NodeEventTypeEnum type;
    private String nodeName;
    private String url;
    private String username;
    private String password;

    public static List<NodeEvent> getEventsByDiffProperties(Properties previous, Properties next) {
        List<String> prevNames = PropertiesUtils.loadNameList(previous, "");
        List<String> nextNames = PropertiesUtils.loadNameList(next, "");
        ArrayList<String> namesToAdd = new ArrayList<String>();
        ArrayList<String> namesToDel = new ArrayList<String>();
        for (String n : prevNames) {
            if (n == null || n.trim().isEmpty() || nextNames.contains(n)) continue;
            namesToDel.add(n);
        }
        for (String n : nextNames) {
            if (n == null || n.trim().isEmpty() || prevNames.contains(n)) continue;
            namesToAdd.add(n);
        }
        ArrayList<NodeEvent> list = new ArrayList<NodeEvent>();
        list.addAll(NodeEvent.generateEvents(next, namesToAdd, NodeEventTypeEnum.ADD));
        list.addAll(NodeEvent.generateEvents(previous, namesToDel, NodeEventTypeEnum.DELETE));
        return list;
    }

    public static List<NodeEvent> generateEvents(Properties properties, List<String> names, NodeEventTypeEnum type) {
        ArrayList<NodeEvent> list = new ArrayList<NodeEvent>();
        for (String n : names) {
            NodeEvent event = new NodeEvent();
            event.setType(type);
            event.setNodeName(n);
            event.setUrl(properties.getProperty(n + ".url"));
            event.setUsername(properties.getProperty(n + ".username"));
            event.setPassword(properties.getProperty(n + ".password"));
            list.add(event);
        }
        return list;
    }

    public String toString() {
        String str = "NodeEvent{type=" + (Object)((Object)this.type) + ", nodeName='" + this.nodeName + '\'' + ", url='" + this.url + '\'' + ", username='" + this.username + '\'';
        if (this.password != null) {
            str = str + ", password.length=" + this.password.length();
        }
        str = str + '}';
        return str;
    }

    public NodeEventTypeEnum getType() {
        return this.type;
    }

    public void setType(NodeEventTypeEnum type) {
        this.type = type;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

