/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import java.util.Objects;

public abstract class AbstractAsyncContextSpanEventInterceptor {
    protected final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected final boolean isTrace = this.logger.isTraceEnabled();

    public AbstractAsyncContextSpanEventInterceptor(TraceContext traceContext) {
        Objects.requireNonNull(traceContext, "traceContext");
    }

    protected AsyncContext getAsyncContext(Object target, Object[] args) {
        return AsyncContextAccessorUtils.getAsyncContext(target);
    }

    protected AsyncContext getAsyncContext(Object target, Object[] args, Object result, Throwable throwable) {
        return AsyncContextAccessorUtils.getAsyncContext(target);
    }

    protected Trace getAsyncTrace(AsyncContext asyncContext) {
        Trace trace = asyncContext.continueAsyncTraceObject();
        if (trace == null) {
            if (this.isDebug) {
                this.logger.debug("Failed to continue async trace. 'result is null'");
            }
            return null;
        }
        if (this.isDebug) {
            this.logger.debug("getAsyncTrace() trace {}, asyncContext={}", (Object)trace, (Object)asyncContext);
        }
        return trace;
    }

    protected void deleteAsyncContext(Trace trace, AsyncContext asyncContext) {
        if (this.isDebug) {
            this.logger.debug("Delete async trace {}.", (Object)trace);
        }
        trace.close();
        asyncContext.close();
    }
}

