/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.redisson.config.BaseMasterSlaveServersConfig;

public class MasterSlaveServersConfig
extends BaseMasterSlaveServersConfig<MasterSlaveServersConfig> {
    private Set<String> slaveAddresses = new HashSet<String>();
    private String masterAddress;
    private int database = 0;

    public MasterSlaveServersConfig() {
    }

    MasterSlaveServersConfig(MasterSlaveServersConfig config) {
        super(config);
        this.setLoadBalancer(config.getLoadBalancer());
        this.setMasterAddress(config.getMasterAddress());
        this.setSlaveAddresses(config.getSlaveAddresses());
        this.setDatabase(config.getDatabase());
    }

    public MasterSlaveServersConfig setMasterAddress(String masterAddress) {
        this.masterAddress = masterAddress;
        return this;
    }

    public String getMasterAddress() {
        return this.masterAddress;
    }

    public MasterSlaveServersConfig addSlaveAddress(String ... addresses) {
        this.slaveAddresses.addAll(Arrays.asList(addresses));
        return this;
    }

    public MasterSlaveServersConfig addSlaveAddress(String slaveAddress) {
        this.slaveAddresses.add(slaveAddress);
        return this;
    }

    public Set<String> getSlaveAddresses() {
        return this.slaveAddresses;
    }

    public void setSlaveAddresses(Set<String> readAddresses) {
        this.slaveAddresses = readAddresses;
    }

    public MasterSlaveServersConfig setDatabase(int database) {
        this.database = database;
        return this;
    }

    public int getDatabase() {
        return this.database;
    }
}

