/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.api.GeoEntry;
import org.redisson.api.GeoOrder;
import org.redisson.api.GeoPosition;
import org.redisson.api.GeoUnit;
import org.redisson.api.RFuture;
import org.redisson.api.RGeo;
import org.redisson.api.RedissonClient;
import org.redisson.api.geo.GeoSearchArgs;
import org.redisson.api.geo.GeoSearchParams;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.CodecDecoder;
import org.redisson.client.protocol.decoder.GeoDistanceDecoder;
import org.redisson.client.protocol.decoder.GeoPositionDecoder;
import org.redisson.client.protocol.decoder.GeoPositionMapDecoder;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectMapReplayDecoder2;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.MapGetAllDecoder;

public class RedissonGeo<V>
extends RedissonScoredSortedSet<V>
implements RGeo<V> {
    private static final MultiDecoder<Map<Object, Object>> POSTITION_DECODER = new ListMultiDecoder2(new ObjectMapReplayDecoder2(), new CodecDecoder(), new GeoPositionDecoder());
    private static final MultiDecoder<Map<Object, Object>> DISTANCE_DECODER = new ListMultiDecoder2(new ObjectMapReplayDecoder2(), new GeoDistanceDecoder());
    private static final RedisCommand<Map<Object, Object>> GEORADIUS_RO_DISTANCE = new RedisCommand<Map<Object, Object>>("GEORADIUS_RO", DISTANCE_DECODER);
    private static final RedisCommand<Map<Object, Object>> GEOSEARCH_DISTANCE = new RedisCommand<Map<Object, Object>>("GEOSEARCH", DISTANCE_DECODER);
    private static final RedisCommand<Map<Object, Object>> GEOSEARCH_POS = new RedisCommand<Map<Object, Object>>("GEOSEARCH", POSTITION_DECODER);
    private static final RedisCommand<Map<Object, Object>> GEORADIUS_RO_POS = new RedisCommand<Map<Object, Object>>("GEORADIUS_RO", POSTITION_DECODER);
    private static final RedisCommand<Map<Object, Object>> GEORADIUSBYMEMBER_RO_DISTANCE = new RedisCommand<Map<Object, Object>>("GEORADIUSBYMEMBER_RO", DISTANCE_DECODER);
    private static final RedisCommand<Map<Object, Object>> GEORADIUSBYMEMBER_RO_POS = new RedisCommand<Map<Object, Object>>("GEORADIUSBYMEMBER_RO", POSTITION_DECODER);

    public RedissonGeo(CommandAsyncExecutor connectionManager, String name, RedissonClient redisson) {
        super(connectionManager, name, redisson);
    }

    public RedissonGeo(Codec codec, CommandAsyncExecutor connectionManager, String name, RedissonClient redisson) {
        super(codec, connectionManager, name, redisson);
    }

    @Override
    public RFuture<Long> addAsync(double longitude, double latitude, V member) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GEOADD, this.getRawName(), this.convert(longitude), this.convert(latitude), this.encode(member));
    }

    private String convert(double longitude) {
        return BigDecimal.valueOf(longitude).toPlainString();
    }

    @Override
    public long add(double longitude, double latitude, V member) {
        return this.get(this.addAsync(longitude, latitude, member));
    }

    @Override
    public long add(GeoEntry ... entries) {
        return this.get(this.addAsync(entries));
    }

    @Override
    public RFuture<Long> addAsync(GeoEntry ... entries) {
        return this.addAsync("", entries);
    }

    private RFuture<Long> addAsync(String subCommand, GeoEntry ... entries) {
        ArrayList<Object> params = new ArrayList<Object>(entries.length + 2);
        params.add(this.getRawName());
        if (!subCommand.isEmpty()) {
            params.add(subCommand);
        }
        for (GeoEntry entry : entries) {
            params.add(entry.getLongitude());
            params.add(entry.getLatitude());
            this.encode(params, entry.getMember());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.GEOADD, params.toArray());
    }

    @Override
    public Boolean addIfExists(double longitude, double latitude, V member) {
        return this.get(this.addIfExistsAsync(longitude, latitude, member));
    }

    @Override
    public long addIfExists(GeoEntry ... entries) {
        return this.get(this.addIfExistsAsync(entries));
    }

    @Override
    public RFuture<Boolean> addIfExistsAsync(double longitude, double latitude, V member) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('geopos', KEYS[1], ARGV[3]); if value[1] ~= false then redis.call('geoadd', KEYS[1], ARGV[1], ARGV[2], ARGV[3]); return 1; end; return 0; ", Collections.singletonList(this.getRawName()), this.convert(longitude), this.convert(latitude), this.encode(member));
    }

    @Override
    public RFuture<Long> addIfExistsAsync(GeoEntry ... entries) {
        return this.addAsync("XX", entries);
    }

    @Override
    public boolean tryAdd(double longitude, double latitude, V member) {
        return this.get(this.tryAddAsync(longitude, latitude, member));
    }

    @Override
    public long tryAdd(GeoEntry ... entries) {
        return this.get(this.tryAddAsync(entries));
    }

    @Override
    public RFuture<Boolean> tryAddAsync(double longitude, double latitude, V member) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GEOADD_BOOLEAN, this.getRawName(), "NX", this.convert(longitude), this.convert(latitude), this.encode(member));
    }

    @Override
    public RFuture<Long> tryAddAsync(GeoEntry ... entries) {
        return this.addAsync("NX", entries);
    }

    @Override
    public Double dist(V firstMember, V secondMember, GeoUnit geoUnit) {
        return this.get(this.distAsync(firstMember, secondMember, geoUnit));
    }

    @Override
    public RFuture<Double> distAsync(V firstMember, V secondMember, GeoUnit geoUnit) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.GEODIST, new Object[]{this.getRawName(), this.encode(firstMember), this.encode(secondMember), geoUnit});
    }

    @Override
    public Map<V, String> hash(V ... members) {
        return this.get(this.hashAsync(members));
    }

    @Override
    public RFuture<Map<V, String>> hashAsync(V ... members) {
        ArrayList<String> params = new ArrayList<String>(members.length + 1);
        params.add(this.getRawName());
        for (V member : members) {
            this.encode(params, member);
        }
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEOHASH", new MapGetAllDecoder(Arrays.asList(members), 0));
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, command, params.toArray());
    }

    @Override
    public Map<V, GeoPosition> pos(V ... members) {
        return this.get(this.posAsync(members));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> posAsync(V ... members) {
        ArrayList<String> params = new ArrayList<String>(members.length + 1);
        params.add(this.getRawName());
        for (V member : members) {
            this.encode(params, member);
        }
        ListMultiDecoder2 decoder = new ListMultiDecoder2(new GeoPositionMapDecoder(Arrays.asList(members)), new GeoPositionDecoder());
        RedisCommand<Object> command = new RedisCommand<Object>("GEOPOS", decoder);
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, command, params.toArray());
    }

    @Override
    public List<V> search(GeoSearchArgs args) {
        return this.get(this.searchAsync(args));
    }

    @Override
    public RFuture<List<V>> searchAsync(GeoSearchArgs args) {
        GeoSearchParams params = (GeoSearchParams)args;
        ArrayList<Object> commandParams = new ArrayList<Object>();
        commandParams.add(this.getRawName());
        RedisCommand<List<Object>> command = null;
        if (params.getLatitude() != null && params.getLongitude() != null) {
            command = RedisCommands.GEORADIUS_RO;
            if (params.getHeight() != null) {
                command = RedisCommands.GEOSEARCH;
                commandParams.add("FROMLONLAT");
            }
            commandParams.add(this.convert(params.getLongitude()));
            commandParams.add(this.convert(params.getLatitude()));
        }
        if (params.getMember() != null) {
            command = RedisCommands.GEORADIUSBYMEMBER_RO;
            if (params.getHeight() != null) {
                command = RedisCommands.GEOSEARCH;
                commandParams.add("FROMMEMBER");
            }
            commandParams.add(this.encode(params.getMember()));
        }
        if (params.getRadius() != null && params.getUnit() != null) {
            commandParams.add(params.getRadius());
            commandParams.add((Object)params.getUnit());
        }
        if (params.getHeight() != null && params.getUnit() != null) {
            commandParams.add("BYBOX");
            commandParams.add(params.getWidth());
            commandParams.add(params.getHeight());
            commandParams.add((Object)params.getUnit());
            if (params.getOrder() != null) {
                commandParams.add((Object)params.getOrder());
            }
        }
        if (params.getCount() != null) {
            commandParams.add("COUNT");
            commandParams.add(params.getCount());
            if (params.isCountAny()) {
                commandParams.add("ANY");
            }
        }
        if (params.getHeight() == null && params.getOrder() != null) {
            commandParams.add((Object)params.getOrder());
        }
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, command, commandParams.toArray());
    }

    @Override
    public Map<V, Double> searchWithDistance(GeoSearchArgs args) {
        return this.get(this.searchWithDistanceAsync(args));
    }

    @Override
    public RFuture<Map<V, Double>> searchWithDistanceAsync(GeoSearchArgs args) {
        GeoSearchParams params = (GeoSearchParams)args;
        ArrayList<Object> commandParams = new ArrayList<Object>();
        commandParams.add(this.getRawName());
        RedisCommand<Map<Object, Object>> command = null;
        if (params.getLatitude() != null && params.getLongitude() != null) {
            command = GEORADIUS_RO_DISTANCE;
            if (params.getHeight() != null) {
                command = GEOSEARCH_DISTANCE;
                commandParams.add("FROMLONLAT");
            }
            commandParams.add(this.convert(params.getLongitude()));
            commandParams.add(this.convert(params.getLatitude()));
        }
        if (params.getMember() != null) {
            command = GEORADIUSBYMEMBER_RO_DISTANCE;
            if (params.getHeight() != null) {
                command = GEOSEARCH_DISTANCE;
                commandParams.add("FROMMEMBER");
            }
            commandParams.add(this.encode(params.getMember()));
        }
        if (params.getRadius() != null && params.getUnit() != null) {
            commandParams.add(params.getRadius());
            commandParams.add((Object)params.getUnit());
        }
        if (params.getHeight() != null && params.getUnit() != null) {
            commandParams.add("BYBOX");
            commandParams.add(params.getWidth());
            commandParams.add(params.getHeight());
            commandParams.add((Object)params.getUnit());
            if (params.getOrder() != null) {
                commandParams.add((Object)params.getOrder());
            }
        }
        if (params.getHeight() == null) {
            commandParams.add("WITHDIST");
        }
        if (params.getCount() != null) {
            commandParams.add("COUNT");
            commandParams.add(params.getCount());
            if (params.isCountAny()) {
                commandParams.add("ANY");
            }
        }
        if (params.getHeight() == null && params.getOrder() != null) {
            commandParams.add((Object)params.getOrder());
        }
        if (params.getHeight() != null) {
            commandParams.add("WITHDIST");
        }
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, command, commandParams.toArray());
    }

    @Override
    public Map<V, GeoPosition> searchWithPosition(GeoSearchArgs args) {
        return this.get(this.searchWithPositionAsync(args));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> searchWithPositionAsync(GeoSearchArgs args) {
        GeoSearchParams params = (GeoSearchParams)args;
        ArrayList<Object> commandParams = new ArrayList<Object>();
        commandParams.add(this.getRawName());
        RedisCommand<Map<Object, Object>> command = null;
        if (params.getLatitude() != null && params.getLongitude() != null) {
            command = GEORADIUS_RO_POS;
            if (params.getHeight() != null) {
                command = GEOSEARCH_POS;
                commandParams.add("FROMLONLAT");
            }
            commandParams.add(this.convert(params.getLongitude()));
            commandParams.add(this.convert(params.getLatitude()));
        }
        if (params.getMember() != null) {
            command = GEORADIUSBYMEMBER_RO_POS;
            if (params.getHeight() != null) {
                command = GEOSEARCH_POS;
                commandParams.add("FROMMEMBER");
            }
            commandParams.add(this.encode(params.getMember()));
        }
        if (params.getRadius() != null && params.getUnit() != null) {
            commandParams.add(params.getRadius());
            commandParams.add((Object)params.getUnit());
        }
        if (params.getHeight() != null && params.getUnit() != null) {
            commandParams.add("BYBOX");
            commandParams.add(params.getWidth());
            commandParams.add(params.getHeight());
            commandParams.add((Object)params.getUnit());
            if (params.getOrder() != null) {
                commandParams.add((Object)params.getOrder());
            }
        }
        if (params.getHeight() == null) {
            commandParams.add("WITHCOORD");
        }
        if (params.getCount() != null) {
            commandParams.add("COUNT");
            commandParams.add(params.getCount());
            if (params.isCountAny()) {
                commandParams.add("ANY");
            }
        }
        if (params.getHeight() == null && params.getOrder() != null) {
            commandParams.add((Object)params.getOrder());
        }
        if (params.getHeight() != null) {
            commandParams.add("WITHCOORD");
        }
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, command, commandParams.toArray());
    }

    @Override
    public List<V> radius(double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusAsync(longitude, latitude, radius, geoUnit));
    }

    @Override
    public RFuture<List<V>> radiusAsync(double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUS_RO, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit});
    }

    @Override
    public List<V> radius(double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusAsync(longitude, latitude, radius, geoUnit, count));
    }

    @Override
    public RFuture<List<V>> radiusAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUS_RO, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "COUNT", count});
    }

    @Override
    public List<V> radius(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.get(this.radiusAsync(longitude, latitude, radius, geoUnit, geoOrder));
    }

    @Override
    public RFuture<List<V>> radiusAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUS_RO, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, geoOrder});
    }

    @Override
    public List<V> radius(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusAsync(longitude, latitude, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<List<V>> radiusAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUS_RO, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "COUNT", count, geoOrder});
    }

    @Override
    public Map<V, Double> radiusWithDistance(double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusWithDistanceAsync(longitude, latitude, radius, geoUnit));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUS_RO_DISTANCE, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHDIST"});
    }

    @Override
    public Map<V, Double> radiusWithDistance(double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusWithDistanceAsync(longitude, latitude, radius, geoUnit, count));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUS_RO_DISTANCE, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHDIST", "COUNT", count});
    }

    @Override
    public Map<V, Double> radiusWithDistance(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.get(this.radiusWithDistanceAsync(longitude, latitude, radius, geoUnit, geoOrder));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUS_RO_DISTANCE, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHDIST", geoOrder});
    }

    @Override
    public Map<V, Double> radiusWithDistance(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusWithDistanceAsync(longitude, latitude, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUS_RO_DISTANCE, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHDIST", "COUNT", count, geoOrder});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusWithPositionAsync(longitude, latitude, radius, geoUnit));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUS_RO_POS, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHCOORD"});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusWithPositionAsync(longitude, latitude, radius, geoUnit, count));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUS_RO_POS, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHCOORD", "COUNT", count});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.get(this.radiusWithPositionAsync(longitude, latitude, radius, geoUnit, geoOrder));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUS_RO_POS, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHCOORD", geoOrder});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusWithPositionAsync(longitude, latitude, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUS_RO_POS, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHCOORD", "COUNT", count, geoOrder});
    }

    @Override
    public List<V> radius(V member, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusAsync(member, radius, geoUnit));
    }

    @Override
    public RFuture<List<V>> radiusAsync(V member, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_RO, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit});
    }

    @Override
    public List<V> radius(V member, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusAsync(member, radius, geoUnit, count));
    }

    @Override
    public RFuture<List<V>> radiusAsync(V member, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_RO, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "COUNT", count});
    }

    @Override
    public List<V> radius(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.get(this.radiusAsync(member, radius, geoUnit, geoOrder));
    }

    @Override
    public RFuture<List<V>> radiusAsync(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_RO, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, geoOrder});
    }

    @Override
    public List<V> radius(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusAsync(member, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<List<V>> radiusAsync(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_RO, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "COUNT", count, geoOrder});
    }

    @Override
    public Map<V, Double> radiusWithDistance(V member, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusWithDistanceAsync(member, radius, geoUnit));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(V member, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUSBYMEMBER_RO_DISTANCE, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "WITHDIST"});
    }

    @Override
    public Map<V, Double> radiusWithDistance(V member, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusWithDistanceAsync(member, radius, geoUnit, count));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(V member, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUSBYMEMBER_RO_DISTANCE, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "WITHDIST", "COUNT", count});
    }

    @Override
    public Map<V, Double> radiusWithDistance(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.get(this.radiusWithDistanceAsync(member, radius, geoUnit, geoOrder));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUSBYMEMBER_RO_DISTANCE, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "WITHDIST", geoOrder});
    }

    @Override
    public Map<V, Double> radiusWithDistance(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusWithDistanceAsync(member, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUSBYMEMBER_RO_DISTANCE, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "WITHDIST", "COUNT", count, geoOrder});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(V member, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusWithPositionAsync(member, radius, geoUnit));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(V member, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUSBYMEMBER_RO_POS, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "WITHCOORD"});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(V member, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusWithPositionAsync(member, radius, geoUnit, count));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(V member, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUSBYMEMBER_RO_POS, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "WITHCOORD", "COUNT", count});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.get(this.radiusWithPositionAsync(member, radius, geoUnit, geoOrder));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUSBYMEMBER_RO_POS, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "WITHCOORD", geoOrder});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusWithPositionAsync(member, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, GEORADIUSBYMEMBER_RO_POS, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "WITHCOORD", "COUNT", count, geoOrder});
    }

    @Override
    public long radiusStoreTo(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusStoreToAsync(destName, longitude, latitude, radius, geoUnit));
    }

    @Override
    public RFuture<Long> radiusStoreToAsync(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.GEORADIUS_STORE, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "STORE", destName});
    }

    @Override
    public long storeSearchTo(String destName, GeoSearchArgs args) {
        return this.get(this.storeSearchToAsync(destName, args));
    }

    @Override
    public RFuture<Long> storeSearchToAsync(String destName, GeoSearchArgs args) {
        GeoSearchParams params = (GeoSearchParams)args;
        ArrayList<Object> commandParams = new ArrayList<Object>();
        if (params.getHeight() != null) {
            commandParams.add(destName);
        }
        commandParams.add(this.getRawName());
        RedisCommand<Object> command = null;
        if (params.getLatitude() != null && params.getLongitude() != null) {
            command = RedisCommands.GEORADIUS_STORE;
            if (params.getHeight() != null) {
                command = RedisCommands.GEOSEARCHSTORE_STORE;
                commandParams.add("FROMLONLAT");
            }
            commandParams.add(this.convert(params.getLongitude()));
            commandParams.add(this.convert(params.getLatitude()));
        }
        if (params.getMember() != null) {
            command = RedisCommands.GEORADIUSBYMEMBER_STORE;
            if (params.getHeight() != null) {
                command = RedisCommands.GEOSEARCHSTORE_STORE;
                commandParams.add("FROMMEMBER");
            }
            commandParams.add(this.encode(params.getMember()));
        }
        if (params.getRadius() != null && params.getUnit() != null) {
            commandParams.add(params.getRadius());
            commandParams.add((Object)params.getUnit());
        }
        if (params.getHeight() != null && params.getUnit() != null) {
            commandParams.add("BYBOX");
            commandParams.add(params.getWidth());
            commandParams.add(params.getHeight());
            commandParams.add((Object)params.getUnit());
            if (params.getOrder() != null) {
                commandParams.add((Object)params.getOrder());
            }
        }
        if (params.getCount() != null) {
            commandParams.add("COUNT");
            commandParams.add(params.getCount());
            if (params.isCountAny()) {
                commandParams.add("ANY");
            }
        }
        if (params.getHeight() == null && params.getOrder() != null) {
            commandParams.add((Object)params.getOrder());
        }
        if (params.getHeight() == null) {
            commandParams.add("STORE");
            commandParams.add(destName);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, command, commandParams.toArray());
    }

    @Override
    public long radiusStoreTo(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusStoreToAsync(destName, longitude, latitude, radius, geoUnit, count));
    }

    @Override
    public RFuture<Long> radiusStoreToAsync(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.GEORADIUS_STORE, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "COUNT", count, "STORE", destName});
    }

    @Override
    public long radiusStoreTo(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusStoreToAsync(destName, longitude, latitude, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<Long> radiusStoreToAsync(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.GEORADIUS_STORE, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, geoOrder, "COUNT", count, "STORE", destName});
    }

    @Override
    public long radiusStoreTo(String destName, V member, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusStoreToAsync(destName, member, radius, geoUnit));
    }

    @Override
    public RFuture<Long> radiusStoreToAsync(String destName, V member, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_STORE, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "STORE", destName});
    }

    @Override
    public long radiusStoreTo(String destName, V member, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusStoreToAsync(destName, member, radius, geoUnit, count));
    }

    @Override
    public RFuture<Long> radiusStoreToAsync(String destName, V member, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_STORE, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "COUNT", count, "STORE", destName});
    }

    @Override
    public long radiusStoreTo(String destName, V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusStoreToAsync(destName, member, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<Long> radiusStoreToAsync(String destName, V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_STORE, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, geoOrder, "COUNT", count, "STORE", destName});
    }

    @Override
    public long storeSortedSearchTo(String destName, GeoSearchArgs args) {
        return this.get(this.storeSortedSearchToAsync(destName, args));
    }

    @Override
    public RFuture<Long> storeSortedSearchToAsync(String destName, GeoSearchArgs args) {
        GeoSearchParams params = (GeoSearchParams)args;
        ArrayList<Object> commandParams = new ArrayList<Object>();
        if (params.getHeight() != null) {
            commandParams.add(destName);
        }
        commandParams.add(this.getRawName());
        RedisCommand<Object> command = null;
        if (params.getLatitude() != null && params.getLongitude() != null) {
            command = RedisCommands.GEORADIUS_STORE;
            if (params.getHeight() != null) {
                command = RedisCommands.GEOSEARCHSTORE_STORE;
                commandParams.add("FROMLONLAT");
            }
            commandParams.add(this.convert(params.getLongitude()));
            commandParams.add(this.convert(params.getLatitude()));
        }
        if (params.getMember() != null) {
            command = RedisCommands.GEORADIUSBYMEMBER_STORE;
            if (params.getHeight() != null) {
                command = RedisCommands.GEOSEARCHSTORE_STORE;
                commandParams.add("FROMMEMBER");
            }
            commandParams.add(this.encode(params.getMember()));
        }
        if (params.getRadius() != null && params.getUnit() != null) {
            commandParams.add(params.getRadius());
            commandParams.add((Object)params.getUnit());
        }
        if (params.getHeight() != null && params.getUnit() != null) {
            commandParams.add("BYBOX");
            commandParams.add(params.getWidth());
            commandParams.add(params.getHeight());
            commandParams.add((Object)params.getUnit());
            if (params.getOrder() != null) {
                commandParams.add((Object)params.getOrder());
            }
        }
        if (params.getCount() != null) {
            commandParams.add("COUNT");
            commandParams.add(params.getCount());
            if (params.isCountAny()) {
                commandParams.add("ANY");
            }
        }
        if (params.getHeight() == null && params.getOrder() != null) {
            commandParams.add((Object)params.getOrder());
        }
        commandParams.add("STOREDIST");
        if (params.getHeight() == null) {
            commandParams.add(destName);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, command, commandParams.toArray());
    }

    @Override
    public RFuture<Long> radiusStoreSortedToAsync(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.GEORADIUS_STORE, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "STOREDIST", destName});
    }

    @Override
    public RFuture<Long> radiusStoreSortedToAsync(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.GEORADIUS_STORE, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "COUNT", count, "STOREDIST", destName});
    }

    @Override
    public RFuture<Long> radiusStoreSortedToAsync(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.GEORADIUS_STORE, new Object[]{this.getRawName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, geoOrder, "COUNT", count, "STOREDIST", destName});
    }

    @Override
    public RFuture<Long> radiusStoreSortedToAsync(String destName, V member, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_STORE, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "STOREDIST", destName});
    }

    @Override
    public RFuture<Long> radiusStoreSortedToAsync(String destName, V member, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_STORE, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, "COUNT", count, "STOREDIST", destName});
    }

    @Override
    public RFuture<Long> radiusStoreSortedToAsync(String destName, V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_STORE, new Object[]{this.getRawName(), this.encode(member), radius, geoUnit, geoOrder, "COUNT", count, "STOREDIST", destName});
    }

    @Override
    public long radiusStoreSortedTo(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusStoreSortedToAsync(destName, longitude, latitude, radius, geoUnit));
    }

    @Override
    public long radiusStoreSortedTo(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusStoreSortedToAsync(destName, longitude, latitude, radius, geoUnit, count));
    }

    @Override
    public long radiusStoreSortedTo(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusStoreSortedToAsync(destName, longitude, latitude, radius, geoUnit, geoOrder, count));
    }

    @Override
    public long radiusStoreSortedTo(String destName, V member, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusStoreSortedToAsync(destName, member, radius, geoUnit));
    }

    @Override
    public long radiusStoreSortedTo(String destName, V member, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusStoreSortedToAsync(destName, member, radius, geoUnit));
    }

    @Override
    public long radiusStoreSortedTo(String destName, V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusStoreSortedToAsync(destName, member, radius, geoUnit));
    }
}

