/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.vendor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.pool.ValidConnectionChecker;
import com.alibaba.druid.pool.ValidConnectionCheckerAdapter;
import com.alibaba.druid.util.StringUtils;
import java.sql.Connection;

public class OceanBaseValidConnectionChecker
extends ValidConnectionCheckerAdapter
implements ValidConnectionChecker {
    private String commonValidateQuery = "SELECT 'x' FROM DUAL";
    private String mysqlValidateQuery = "/* ping */ SELECT 1";
    private DbType dbType;

    public OceanBaseValidConnectionChecker() {
        this.configFromProperties(System.getProperties());
        this.dbType = null;
    }

    public OceanBaseValidConnectionChecker(DbType dbType) {
        this.dbType = dbType;
        this.configFromProperties(System.getProperties());
    }

    @Override
    public boolean isValidConnection(Connection conn, String validateQuery, int validationQueryTimeout) throws Exception {
        if (conn.isClosed()) {
            return false;
        }
        if (StringUtils.isEmpty(validateQuery)) {
            validateQuery = DbType.mysql.equals((Object)this.dbType) ? this.mysqlValidateQuery : this.commonValidateQuery;
        }
        return ValidConnectionCheckerAdapter.execValidQuery(conn, validateQuery, validationQueryTimeout);
    }
}

