/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.SimpleProperty;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public class PropertySnapshot
implements SimpleProperty {
    private final Properties properties;

    public PropertySnapshot(Properties properties) {
        this.properties = this.copy(properties);
    }

    private Properties copy(Properties properties) {
        Objects.requireNonNull(properties, "properties");
        Set<String> keys = properties.stringPropertyNames();
        Properties copy = new Properties();
        for (String key : keys) {
            copy.setProperty(key, properties.getProperty(key));
        }
        return copy;
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    public Set<String> stringPropertyNames() {
        return this.properties.stringPropertyNames();
    }
}

