/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import jodd.bean.BeanUtil;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.util.StringUtil;

public class BeanVisitor {
    protected final Object source;
    protected boolean declared;
    protected boolean ignoreNullValues;
    protected boolean ignoreEmptyString;
    protected boolean includeFields;
    protected final boolean isSourceMap;

    public BeanVisitor(Object source) {
        this.source = source;
        this.isSourceMap = source instanceof Map;
    }

    public BeanVisitor ignoreNulls(boolean ignoreNulls) {
        this.ignoreNullValues = ignoreNulls;
        return this;
    }

    public BeanVisitor ignoreEmptyString(boolean ignoreEmptyString) {
        this.ignoreEmptyString = ignoreEmptyString;
        return this;
    }

    public BeanVisitor declared(boolean declared) {
        this.declared = declared;
        return this;
    }

    public BeanVisitor includeFields(boolean includeFields) {
        this.includeFields = includeFields;
        return this;
    }

    protected String[] getAllBeanPropertyNames(Class type, boolean declared) {
        ClassDescriptor classDescriptor = ClassIntrospector.get().lookup(type);
        PropertyDescriptor[] propertyDescriptors = classDescriptor.getAllPropertyDescriptors();
        ArrayList<String> names = new ArrayList<String>(propertyDescriptors.length);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            FieldDescriptor field;
            MethodDescriptor getter = propertyDescriptor.getReadMethodDescriptor();
            if (getter != null) {
                if (!getter.matchDeclared(declared)) continue;
                names.add(propertyDescriptor.getName());
                continue;
            }
            if (!this.includeFields || (field = propertyDescriptor.getFieldDescriptor()) == null || !field.matchDeclared(declared)) continue;
            names.add(field.getName());
        }
        return names.toArray(new String[0]);
    }

    protected String[] resolveProperties(Object bean, boolean declared) {
        String[] properties;
        if (bean instanceof Map) {
            Set keys = ((Map)bean).keySet();
            properties = new String[keys.size()];
            int ndx = 0;
            for (Object key : keys) {
                properties[ndx] = key.toString();
                ++ndx;
            }
        } else {
            properties = this.getAllBeanPropertyNames(bean.getClass(), declared);
        }
        return properties;
    }

    public void visit(BiConsumer<String, Object> propertyConsumer) {
        String[] properties;
        for (String name : properties = this.resolveProperties(this.source, this.declared)) {
            Object value;
            if (name == null) continue;
            String propertyName = name;
            if (this.isSourceMap) {
                propertyName = "[" + name + "]";
            }
            if ((value = this.declared ? BeanUtil.declared.getProperty(this.source, propertyName) : BeanUtil.pojo.getProperty(this.source, propertyName)) == null && this.ignoreNullValues || this.ignoreEmptyString && value instanceof String && StringUtil.isEmpty((String)value)) continue;
            propertyConsumer.accept(name, value);
        }
    }
}

