/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.util;

import com.navercorp.pinpoint.common.buffer.FixedBuffer;
import com.navercorp.pinpoint.common.profiler.util.TransactionId;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.BytesUtils;
import com.navercorp.pinpoint.common.util.IdValidateUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public final class TransactionIdUtils {
    public static final String TRANSACTION_ID_DELIMITER = "^";
    public static final byte VERSION = 0;
    private static final byte VERSION_SIZE = 1;

    private TransactionIdUtils() {
    }

    public static String formatString(TransactionId transactionId) {
        return TransactionIdUtils.formatString(transactionId.getAgentId(), transactionId.getAgentStartTime(), transactionId.getTransactionSequence());
    }

    public static String formatString(String agentId, long agentStartTime, long transactionSequence) {
        Objects.requireNonNull(agentId, "agentId");
        return agentId + TRANSACTION_ID_DELIMITER + agentStartTime + TRANSACTION_ID_DELIMITER + transactionSequence;
    }

    public static byte[] formatBytes(String agentId, long agentStartTime, long transactionSequence) {
        return TransactionIdUtils.writeTransactionId(agentId, agentStartTime, transactionSequence);
    }

    public static ByteBuffer formatByteBuffer(String agentId, long agentStartTime, long transactionSequence) {
        byte[] buffer = TransactionIdUtils.writeTransactionId(agentId, agentStartTime, transactionSequence);
        return ByteBuffer.wrap(buffer);
    }

    private static byte[] writeTransactionId(String agentId, long agentStartTime, long transactionSequence) {
        byte[] agentIdBytes = BytesUtils.toBytes((String)agentId);
        int agentIdLength = ArrayUtils.getLength((byte[])agentIdBytes, (int)-1);
        int zigZagAgentIdLength = BytesUtils.intToZigZag((int)agentIdLength);
        int agentIdPrefixSize = BytesUtils.computeVar32Size((int)zigZagAgentIdLength);
        int agentStartTimeSize = BytesUtils.computeVar64Size((long)agentStartTime);
        int transactionIdSequenceSize = BytesUtils.computeVar64Size((long)transactionSequence);
        int bufferSize = 1 + agentIdPrefixSize + ArrayUtils.getLength((byte[])agentIdBytes) + agentStartTimeSize + transactionIdSequenceSize;
        byte[] buffer = new byte[bufferSize];
        buffer[0] = 0;
        int offset = 1;
        offset = BytesUtils.writeVar32((int)zigZagAgentIdLength, (byte[])buffer, (int)offset);
        if (agentIdBytes != null) {
            offset = BytesUtils.writeBytes((byte[])buffer, (int)offset, (byte[])agentIdBytes);
        }
        offset = BytesUtils.writeVar64((long)agentStartTime, (byte[])buffer, (int)offset);
        BytesUtils.writeVar64((long)transactionSequence, (byte[])buffer, (int)offset);
        return buffer;
    }

    public static TransactionId parseTransactionId(byte[] transactionId, String defaultAgentId) {
        Objects.requireNonNull(transactionId, "transactionId");
        FixedBuffer buffer = new FixedBuffer(transactionId);
        byte version = buffer.readByte();
        if (version != 0) {
            throw new IllegalArgumentException("invalid Version");
        }
        String agentId = buffer.readPrefixedString();
        if (!IdValidateUtils.validateId((String)(agentId = StringUtils.defaultString((String)agentId, (String)defaultAgentId)))) {
            throw new IllegalArgumentException("invalid transactionId:" + Arrays.toString(transactionId));
        }
        long agentStartTime = buffer.readVLong();
        long transactionSequence = buffer.readVLong();
        return new TransactionId(agentId, agentStartTime, transactionSequence);
    }

    public static TransactionId parseTransactionId(String transactionId) {
        Objects.requireNonNull(transactionId, "transactionId");
        int agentIdIndex = TransactionIdUtils.nextIndex(transactionId, 0);
        if (agentIdIndex == -1) {
            throw new IllegalArgumentException("agentIndex not found:" + transactionId);
        }
        if (agentIdIndex > 24) {
            throw new IllegalArgumentException("invalid transactionId:" + transactionId);
        }
        if (!IdValidateUtils.checkId((String)transactionId, (int)0, (int)agentIdIndex)) {
            throw new IllegalArgumentException("invalid transactionId:" + transactionId);
        }
        String agentId = transactionId.substring(0, agentIdIndex);
        int agentStartTimeIndex = TransactionIdUtils.nextIndex(transactionId, agentIdIndex + 1);
        if (agentStartTimeIndex == -1) {
            throw new IllegalArgumentException("agentStartTimeIndex not found:" + transactionId);
        }
        long agentStartTime = TransactionIdUtils.parseLong(transactionId, agentIdIndex + 1, agentStartTimeIndex);
        int transactionSequenceIndex = TransactionIdUtils.nextIndex(transactionId, agentStartTimeIndex + 1);
        if (transactionSequenceIndex == -1) {
            transactionSequenceIndex = transactionId.length();
        }
        long transactionSequence = TransactionIdUtils.parseLong(transactionId, agentStartTimeIndex + 1, transactionSequenceIndex);
        return new TransactionId(agentId, agentStartTime, transactionSequence);
    }

    private static int nextIndex(String transactionId, int fromIndex) {
        return transactionId.indexOf(TRANSACTION_ID_DELIMITER, fromIndex);
    }

    private static long parseLong(String transactionId, int beginIndex, int endIndex) {
        String longString = transactionId.substring(beginIndex, endIndex);
        try {
            return Long.parseLong(longString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("parseLong Error. " + longString + " transactionId:" + transactionId);
        }
    }
}

