/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.type;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.eventmesh.connector.jdbc.table.type.EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;

public class MapType<K, V> {
    private static final List<SQLType> SUPPORTED_KEY_TYPES = Arrays.asList(SQLType.NULL, SQLType.BOOLEAN, SQLType.TINYINT, SQLType.SMALLINT, SQLType.INTEGER, SQLType.BIGINT, SQLType.DATE, SQLType.TIME, SQLType.TIMESTAMP, SQLType.FLOAT, SQLType.DOUBLE, SQLType.STRING, SQLType.DECIMAL);
    private final EventMeshDataType keyType;
    private final EventMeshDataType valueType;

    public MapType(EventMeshDataType keyType, EventMeshDataType valueType) {
        Objects.requireNonNull(keyType, "The key type is required.");
        Objects.requireNonNull(valueType, "The value type is required.");
        if (!SUPPORTED_KEY_TYPES.contains((Object)keyType.getSQLType())) {
            throw new IllegalArgumentException(String.format("Not support type: %s", new Object[]{keyType.getSQLType()}));
        }
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapType)) {
            return false;
        }
        MapType mapType = (MapType)o;
        return Objects.equals(this.keyType, mapType.keyType) && Objects.equals(this.valueType, mapType.valueType);
    }

    public int hashCode() {
        return Objects.hash(this.keyType, this.valueType);
    }

    public EventMeshDataType keyType() {
        return this.keyType;
    }

    public EventMeshDataType valueType() {
        return this.valueType;
    }
}

