/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.mysql;

import com.mysql.cj.MysqlType;
import java.sql.JDBCType;
import java.util.Map;
import java.util.Objects;
import org.apache.eventmesh.connector.jdbc.DataTypeConvertor;
import org.apache.eventmesh.connector.jdbc.exception.DataTypeConvertException;
import org.apache.eventmesh.connector.jdbc.table.type.EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.BooleanEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.BytesEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.DateEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.DateTimeEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.DecimalEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.Float32EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.Float64EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.Int16EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.Int32EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.Int64EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.Int8EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.NullEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.StringEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.TimeEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.YearEventMeshDataType;

public class MysqlDataTypeConvertor
implements DataTypeConvertor<MysqlType> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Integer DEFAULT_PRECISION = 10;
    public static final Integer DEFAULT_SCALE = 0;

    @Override
    public JDBCType toJDBCType(String connectorDataType) {
        MysqlType mysqlType = MysqlType.getByName((String)connectorDataType);
        return JDBCType.valueOf(mysqlType.getJdbcType());
    }

    @Override
    public EventMeshDataType<?> toEventMeshType(String connectorDataType) throws DataTypeConvertException {
        MysqlType mysqlType = MysqlType.getByName((String)connectorDataType);
        return this.toEventMeshType(mysqlType, (Map<String, Object>)null);
    }

    @Override
    public EventMeshDataType<?> toEventMeshType(JDBCType jdbcType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        return this.toEventMeshType(MysqlType.getByJdbcType((int)jdbcType.getVendorTypeNumber()), dataTypeProperties);
    }

    @Override
    public EventMeshDataType<?> toEventMeshType(MysqlType connectorDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        Objects.requireNonNull(connectorDataType, "MysqlType can't be null");
        switch (connectorDataType) {
            case NULL: {
                return NullEventMeshDataType.INSTANCE;
            }
            case BOOLEAN: {
                return BooleanEventMeshDataType.INSTANCE;
            }
            case BIT: {
                if (dataTypeProperties == null) {
                    return BytesEventMeshDataType.INSTANCE;
                }
                Integer precision = (Integer)dataTypeProperties.get(PRECISION);
                if (precision != null && precision == 1) {
                    return BooleanEventMeshDataType.INSTANCE;
                }
                return BytesEventMeshDataType.INSTANCE;
            }
            case TINYINT: {
                return Int8EventMeshDataType.INSTANCE;
            }
            case TINYINT_UNSIGNED: 
            case SMALLINT: {
                return Int16EventMeshDataType.INSTANCE;
            }
            case SMALLINT_UNSIGNED: 
            case INT: 
            case MEDIUMINT: 
            case MEDIUMINT_UNSIGNED: {
                return Int32EventMeshDataType.INSTANCE;
            }
            case INT_UNSIGNED: 
            case BIGINT: {
                return Int64EventMeshDataType.INSTANCE;
            }
            case FLOAT: 
            case FLOAT_UNSIGNED: {
                return Float32EventMeshDataType.INSTANCE;
            }
            case DOUBLE: 
            case DOUBLE_UNSIGNED: {
                return Float64EventMeshDataType.INSTANCE;
            }
            case TIME: {
                return TimeEventMeshDataType.INSTANCE;
            }
            case YEAR: {
                return YearEventMeshDataType.INSTANCE;
            }
            case DATE: {
                return DateEventMeshDataType.INSTANCE;
            }
            case TIMESTAMP: 
            case DATETIME: {
                return DateTimeEventMeshDataType.INSTANCE;
            }
            case CHAR: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case JSON: 
            case ENUM: 
            case SET: {
                return StringEventMeshDataType.INSTANCE;
            }
            case BINARY: 
            case VARBINARY: 
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case GEOMETRY: {
                return BytesEventMeshDataType.INSTANCE;
            }
            case BIGINT_UNSIGNED: 
            case DECIMAL: 
            case DECIMAL_UNSIGNED: {
                if (dataTypeProperties == null) {
                    return new DecimalEventMeshDataType(DEFAULT_PRECISION, DEFAULT_SCALE);
                }
                Integer precision = (Integer)dataTypeProperties.getOrDefault(PRECISION, DEFAULT_PRECISION);
                Integer scale = (Integer)dataTypeProperties.getOrDefault(SCALE, DEFAULT_SCALE);
                return new DecimalEventMeshDataType(precision, scale);
            }
        }
        throw new DataTypeConvertException(String.format("%s type is not supported", connectorDataType.getName()));
    }

    @Override
    public MysqlType toConnectorType(EventMeshDataType<?> eventMeshDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        Objects.requireNonNull(eventMeshDataType, "Parameter eventMeshDataType can not be null");
        SQLType sqlType = eventMeshDataType.getSQLType();
        switch (sqlType) {
            case BOOLEAN: {
                return MysqlType.BOOLEAN;
            }
            case TINYINT: {
                return MysqlType.TINYINT;
            }
            case SMALLINT: {
                return MysqlType.SMALLINT;
            }
            case INTEGER: {
                return MysqlType.INT;
            }
            case BIGINT: {
                return MysqlType.BIGINT;
            }
            case FLOAT: {
                return MysqlType.FLOAT;
            }
            case DOUBLE: {
                return MysqlType.DOUBLE;
            }
            case DECIMAL: {
                return MysqlType.DECIMAL;
            }
            case NULL: {
                return MysqlType.NULL;
            }
            case BINARY: {
                return MysqlType.BIT;
            }
            case DATE: {
                return MysqlType.DATE;
            }
            case TIME: {
                return MysqlType.DATETIME;
            }
            case TIMESTAMP: {
                return MysqlType.TIMESTAMP;
            }
            case ARRAY: 
            case STRING: {
                return MysqlType.VARCHAR;
            }
        }
        throw new DataTypeConvertException(String.format("%s type is not supported", sqlType.name()));
    }
}

