/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.TcpProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoodbyeProcessor
implements TcpProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GoodbyeProcessor.class);
    private EventMeshTCPServer eventMeshTCPServer;
    private final Acl acl;

    public GoodbyeProcessor(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.acl = eventMeshTCPServer.getAcl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Package pkg, ChannelHandlerContext ctx, long startTime) {
        Session session = this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx);
        long taskExecuteTime = System.currentTimeMillis();
        Package msg = new Package();
        try {
            if (pkg.getHeader().getCmd() == Command.SERVER_GOODBYE_RESPONSE) {
                log.info("client|address={}| has reject ", (Object)session.getContext().channel().remoteAddress());
            } else {
                msg.setHeader(new Header(Command.CLIENT_GOODBYE_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), pkg.getHeader().getSeq()));
            }
        }
        catch (Exception e) {
            log.error("GoodbyeTask failed|user={}|errMsg={}", (Object)session.getClient(), (Object)e);
            msg.setHeader(new Header(Command.CLIENT_GOODBYE_RESPONSE, OPStatus.FAIL.getCode().intValue(), Arrays.toString(e.getStackTrace()), pkg.getHeader().getSeq()));
        }
        finally {
            this.eventMeshTCPServer.getTcpThreadPoolGroup().getScheduler().submit(() -> Utils.writeAndFlush(msg, startTime, taskExecuteTime, session.getContext(), session));
        }
        EventMeshTcp2Client.closeSessionIfTimeout(this.eventMeshTCPServer.getTcpThreadPoolGroup(), session, this.eventMeshTCPServer.getClientSessionGroupMapping());
    }
}

