/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.runtime.boot.ThreadPoolGroup;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;

public class HTTPThreadPoolGroup
implements ThreadPoolGroup {
    private final EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    private ThreadPoolExecutor batchMsgExecutor;
    private ThreadPoolExecutor sendMsgExecutor;
    private ThreadPoolExecutor remoteMsgExecutor;
    private ThreadPoolExecutor replyMsgExecutor;
    private ThreadPoolExecutor pushMsgExecutor;
    private ThreadPoolExecutor clientManageExecutor;

    public HTTPThreadPoolGroup(EventMeshHTTPConfiguration eventMeshHttpConfiguration) {
        this.eventMeshHttpConfiguration = eventMeshHttpConfiguration;
    }

    @Override
    public void initThreadPool() {
        this.batchMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerBatchMsgThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerBatchMsgThreadNum(), new LinkedBlockingQueue(this.eventMeshHttpConfiguration.getEventMeshServerBatchBlockQSize()), (String)"eventMesh-batchMsg", (boolean)true);
        this.sendMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerSendMsgThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerSendMsgThreadNum(), new LinkedBlockingQueue(this.eventMeshHttpConfiguration.getEventMeshServerSendMsgBlockQSize()), (String)"eventMesh-sendMsg", (boolean)true);
        this.remoteMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerRemoteMsgThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerRemoteMsgThreadNum(), new LinkedBlockingQueue(this.eventMeshHttpConfiguration.getEventMeshServerRemoteMsgBlockQSize()), (String)"eventMesh-remoteMsg", (boolean)true);
        this.pushMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerPushMsgThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerPushMsgThreadNum(), new LinkedBlockingQueue(this.eventMeshHttpConfiguration.getEventMeshServerPushMsgBlockQSize()), (String)"eventMesh-pushMsg", (boolean)true);
        this.clientManageExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerClientManageThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerClientManageThreadNum(), new LinkedBlockingQueue(this.eventMeshHttpConfiguration.getEventMeshServerClientManageBlockQSize()), (String)"eventMesh-clientManage", (boolean)true);
        this.replyMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerReplyMsgThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerReplyMsgThreadNum(), new LinkedBlockingQueue(100), (String)"eventMesh-replyMsg", (boolean)true);
    }

    @Override
    public void shutdownThreadPool() {
        if (this.batchMsgExecutor != null) {
            this.batchMsgExecutor.shutdown();
        }
        if (this.clientManageExecutor != null) {
            this.clientManageExecutor.shutdown();
        }
        if (this.sendMsgExecutor != null) {
            this.sendMsgExecutor.shutdown();
        }
        if (this.remoteMsgExecutor != null) {
            this.remoteMsgExecutor.shutdown();
        }
        if (this.pushMsgExecutor != null) {
            this.pushMsgExecutor.shutdown();
        }
        if (this.replyMsgExecutor != null) {
            this.replyMsgExecutor.shutdown();
        }
    }

    @Generated
    public ThreadPoolExecutor getBatchMsgExecutor() {
        return this.batchMsgExecutor;
    }

    @Generated
    public ThreadPoolExecutor getSendMsgExecutor() {
        return this.sendMsgExecutor;
    }

    @Generated
    public ThreadPoolExecutor getRemoteMsgExecutor() {
        return this.remoteMsgExecutor;
    }

    @Generated
    public ThreadPoolExecutor getReplyMsgExecutor() {
        return this.replyMsgExecutor;
    }

    @Generated
    public ThreadPoolExecutor getPushMsgExecutor() {
        return this.pushMsgExecutor;
    }

    @Generated
    public ThreadPoolExecutor getClientManageExecutor() {
        return this.clientManageExecutor;
    }
}

