/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.service.status;

import com.google.protobuf.Any;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.grpc.adminserver.AdminServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Metadata;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Payload;
import org.apache.eventmesh.common.remote.JobState;
import org.apache.eventmesh.common.remote.request.ReportJobRequest;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatusService.class);
    private StreamObserver<Payload> requestObserver;
    private StreamObserver<Payload> responseObserver;
    private AdminServiceGrpc.AdminServiceStub adminServiceStub;
    private AdminServiceGrpc.AdminServiceBlockingStub adminServiceBlockingStub;

    public StatusService(AdminServiceGrpc.AdminServiceStub adminServiceStub, AdminServiceGrpc.AdminServiceBlockingStub adminServiceBlockingStub) {
        this.adminServiceStub = adminServiceStub;
        this.adminServiceBlockingStub = adminServiceBlockingStub;
        this.responseObserver = new StreamObserver<Payload>(){

            public void onNext(Payload response) {
                log.debug("health service receive message: {}|{} ", (Object)response.getMetadata(), (Object)response.getBody());
            }

            public void onError(Throwable t) {
                log.error("health service receive error message: {}", (Object)t.getMessage());
            }

            public void onCompleted() {
                log.info("health service finished receive message and completed");
            }
        };
        this.requestObserver = this.adminServiceStub.invokeBiStream(this.responseObserver);
    }

    public void reportJobStatus(String jobId, JobState jobState) {
        ReportJobRequest reportJobRequest = new ReportJobRequest();
        reportJobRequest.setJobID(jobId);
        reportJobRequest.setState(jobState);
        reportJobRequest.setAddress(IPUtils.getLocalAddress());
        Metadata metadata = Metadata.newBuilder().setType(ReportJobRequest.class.getSimpleName()).build();
        Payload payload = Payload.newBuilder().setMetadata(metadata).setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])Objects.requireNonNull(JsonUtils.toJSONBytes((Object)reportJobRequest)))).build()).build();
        log.info("report job state request: {}", (Object)JsonUtils.toJSONString((Object)reportJobRequest));
        this.requestObserver.onNext((Object)payload);
    }

    public void stop() {
        if (this.requestObserver != null) {
            this.requestObserver.onCompleted();
        }
    }
}

