/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaCompletableFuture;

public class KafkaFutureImpl<T>
extends KafkaFuture<T> {
    private final KafkaCompletableFuture<T> completableFuture;
    private final boolean isDependant;

    public KafkaFutureImpl() {
        this(false, new KafkaCompletableFuture());
    }

    private KafkaFutureImpl(boolean isDependant, KafkaCompletableFuture<T> completableFuture) {
        this.isDependant = isDependant;
        this.completableFuture = completableFuture;
    }

    @Override
    public CompletionStage<T> toCompletionStage() {
        return this.completableFuture;
    }

    @Override
    public <R> KafkaFuture<R> thenApply(KafkaFuture.BaseFunction<T, R> function) {
        CompletionStage appliedFuture = this.completableFuture.thenApply((T value) -> {
            try {
                return function.apply(value);
            }
            catch (Throwable t) {
                if (t instanceof CompletionException) {
                    throw new CompletionException(t);
                }
                throw t;
            }
        });
        return new KafkaFutureImpl(true, KafkaFutureImpl.toKafkaCompletableFuture(appliedFuture));
    }

    private static <U> KafkaCompletableFuture<U> toKafkaCompletableFuture(CompletableFuture<U> completableFuture) {
        if (completableFuture instanceof KafkaCompletableFuture) {
            return (KafkaCompletableFuture)completableFuture;
        }
        KafkaCompletableFuture result = new KafkaCompletableFuture();
        completableFuture.whenComplete((T x, U y) -> {
            if (y != null) {
                result.kafkaCompleteExceptionally((Throwable)y);
            } else {
                result.kafkaComplete(x);
            }
        });
        return result;
    }

    @Override
    @Deprecated
    public <R> KafkaFuture<R> thenApply(KafkaFuture.Function<T, R> function) {
        return this.thenApply((KafkaFuture.BaseFunction<T, R>)function);
    }

    @Override
    public KafkaFuture<T> whenComplete(KafkaFuture.BiConsumer<? super T, ? super Throwable> biConsumer) {
        CompletionStage tCompletableFuture = this.completableFuture.whenComplete((T a, U b) -> {
            try {
                biConsumer.accept((Object)a, (Throwable)b);
            }
            catch (Throwable t) {
                if (t instanceof CompletionException) {
                    throw new CompletionException(t);
                }
                throw t;
            }
        });
        return new KafkaFutureImpl(true, KafkaFutureImpl.toKafkaCompletableFuture(tCompletableFuture));
    }

    @Override
    public boolean complete(T newValue) {
        return this.completableFuture.kafkaComplete(newValue);
    }

    @Override
    public boolean completeExceptionally(Throwable newException) {
        return this.completableFuture.kafkaCompleteExceptionally(newException instanceof CompletionException ? new CompletionException(newException) : newException);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.completableFuture.cancel(mayInterruptIfRunning);
    }

    private void maybeThrowCancellationException(Throwable cause) {
        if (cause instanceof CancellationException) {
            throw (CancellationException)cause;
        }
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.completableFuture.get();
        }
        catch (CancellationException | ExecutionException e) {
            this.maybeThrowCancellationException(e.getCause());
            throw e;
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.completableFuture.get(timeout, unit);
        }
        catch (CancellationException | ExecutionException e) {
            this.maybeThrowCancellationException(e.getCause());
            throw e;
        }
    }

    @Override
    public T getNow(T valueIfAbsent) throws ExecutionException {
        try {
            return this.completableFuture.getNow(valueIfAbsent);
        }
        catch (CancellationException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw e;
        }
        catch (CompletionException e) {
            this.maybeThrowCancellationException(e.getCause());
            throw new ExecutionException(e.getCause());
        }
    }

    @Override
    public boolean isCancelled() {
        if (this.isDependant) {
            try {
                this.completableFuture.getNow(null);
                return false;
            }
            catch (Exception e) {
                return e instanceof CompletionException && e.getCause() instanceof CancellationException;
            }
        }
        return this.completableFuture.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.completableFuture.isCompletedExceptionally();
    }

    @Override
    public boolean isDone() {
        return this.completableFuture.isDone();
    }

    public String toString() {
        Object value = null;
        Throwable exception = null;
        try {
            value = this.completableFuture.getNow(null);
        }
        catch (CancellationException e) {
            exception = e.getCause() instanceof CancellationException ? e.getCause() : e;
        }
        catch (CompletionException e) {
            exception = e.getCause();
        }
        catch (Exception e) {
            exception = e;
        }
        return String.format("KafkaFuture{value=%s,exception=%s,done=%b}", value, exception, exception != null || value != null);
    }
}

