/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.k8s.overlord.execution.KubernetesTaskRunnerDynamicConfig;
import org.apache.druid.k8s.overlord.execution.PodTemplateSelectStrategy;

public class DefaultKubernetesTaskRunnerDynamicConfig
implements KubernetesTaskRunnerDynamicConfig {
    @Nullable
    private final PodTemplateSelectStrategy podTemplateSelectStrategy;
    @Nullable
    private final Integer capacity;

    @JsonCreator
    public DefaultKubernetesTaskRunnerDynamicConfig(@JsonProperty(value="podTemplateSelectStrategy") PodTemplateSelectStrategy podTemplateSelectStrategy, @JsonProperty(value="capacity") Integer capacity) {
        this.podTemplateSelectStrategy = podTemplateSelectStrategy;
        this.capacity = capacity;
    }

    @Override
    @JsonProperty
    public PodTemplateSelectStrategy getPodTemplateSelectStrategy() {
        return this.podTemplateSelectStrategy;
    }

    @Override
    @JsonProperty
    public Integer getCapacity() {
        return this.capacity;
    }

    @Override
    public KubernetesTaskRunnerDynamicConfig merge(KubernetesTaskRunnerDynamicConfig other) {
        if (other == null) {
            return this;
        }
        Integer mergeCapacity = this.getCapacity();
        if (other.getCapacity() != null) {
            mergeCapacity = other.getCapacity();
        }
        PodTemplateSelectStrategy mergePodTemplateSelectStrategy = this.getPodTemplateSelectStrategy();
        if (other.getPodTemplateSelectStrategy() != null) {
            mergePodTemplateSelectStrategy = other.getPodTemplateSelectStrategy();
        }
        return new DefaultKubernetesTaskRunnerDynamicConfig(mergePodTemplateSelectStrategy, mergeCapacity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultKubernetesTaskRunnerDynamicConfig that = (DefaultKubernetesTaskRunnerDynamicConfig)o;
        return Objects.equals(this.capacity, that.capacity) && Objects.equals(this.podTemplateSelectStrategy, that.podTemplateSelectStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.podTemplateSelectStrategy, this.capacity);
    }

    public String toString() {
        return "DefaultKubernetesTaskRunnerDynamicConfig{podTemplateSelectStrategy=" + String.valueOf(this.podTemplateSelectStrategy) + "capacity=" + this.capacity + "}";
    }
}

