/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.ContextAttribute;
import com.amazonaws.services.rds.model.RecommendedAction;
import com.amazonaws.services.rds.model.RecommendedActionParameter;
import com.amazonaws.services.rds.model.transform.ContextAttributeStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.IssueDetailsStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.RecommendedActionParameterStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class RecommendedActionStaxUnmarshaller
implements Unmarshaller<RecommendedAction, StaxUnmarshallerContext> {
    private static RecommendedActionStaxUnmarshaller instance;

    public RecommendedAction unmarshall(StaxUnmarshallerContext context) throws Exception {
        RecommendedAction recommendedAction = new RecommendedAction();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return recommendedAction;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ActionId", targetDepth)) {
                    recommendedAction.setActionId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Title", targetDepth)) {
                    recommendedAction.setTitle(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    recommendedAction.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Operation", targetDepth)) {
                    recommendedAction.setOperation(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    recommendedAction.withParameters(new ArrayList<RecommendedActionParameter>());
                    continue;
                }
                if (context.testExpression("Parameters/member", targetDepth)) {
                    recommendedAction.withParameters(RecommendedActionParameterStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ApplyModes", targetDepth)) {
                    recommendedAction.withApplyModes(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ApplyModes/member", targetDepth)) {
                    recommendedAction.withApplyModes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    recommendedAction.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IssueDetails", targetDepth)) {
                    recommendedAction.setIssueDetails(IssueDetailsStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ContextAttributes", targetDepth)) {
                    recommendedAction.withContextAttributes(new ArrayList<ContextAttribute>());
                    continue;
                }
                if (!context.testExpression("ContextAttributes/member", targetDepth)) continue;
                recommendedAction.withContextAttributes(ContextAttributeStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return recommendedAction;
    }

    public static RecommendedActionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RecommendedActionStaxUnmarshaller();
        }
        return instance;
    }
}

