/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskTuningConfig;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Period;

@JsonTypeName(value="KinesisTuningConfig")
public class KinesisIndexTaskTuningConfig
extends SeekableStreamIndexTaskTuningConfig {
    private static final int MAX_RECORD_BUFFER_MEMORY = 100000000;
    private static final double RECORD_BUFFER_MEMORY_MAX_HEAP_FRACTION = 0.1;
    private static final int DEFAULT_RECORD_BUFFER_OFFER_TIMEOUT = 5000;
    private static final int DEFAULT_RECORD_BUFFER_FULL_WAIT = 5000;
    private static final int DEFAULT_MAX_BYTES_PER_POLL = 1000000;
    private final Integer recordBufferSize;
    private final Integer recordBufferSizeBytes;
    private final int recordBufferOfferTimeout;
    private final int recordBufferFullWait;
    private final Integer fetchThreads;
    private final Integer maxRecordsPerPoll;
    private final Integer maxBytesPerPoll;

    public KinesisIndexTaskTuningConfig(@Nullable AppendableIndexSpec appendableIndexSpec, Integer maxRowsInMemory, Long maxBytesInMemory, @Nullable Boolean skipBytesInMemoryOverheadCheck, Integer maxRowsPerSegment, Long maxTotalRows, Period intermediatePersistPeriod, File basePersistDirectory, Integer maxPendingPersists, IndexSpec indexSpec, @Nullable IndexSpec indexSpecForIntermediatePersists, Boolean reportParseExceptions, Long handoffConditionTimeout, Boolean resetOffsetAutomatically, Boolean skipSequenceNumberAvailabilityCheck, @Deprecated @Nullable Integer recordBufferSize, @Nullable Integer recordBufferSizeBytes, Integer recordBufferOfferTimeout, Integer recordBufferFullWait, Integer fetchThreads, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @Nullable Boolean logParseExceptions, @Nullable Integer maxParseExceptions, @Nullable Integer maxSavedParseExceptions, @Deprecated @Nullable Integer maxRecordsPerPoll, @Nullable Integer maxBytesPerPoll, @Nullable Period intermediateHandoffPeriod, @Nullable Integer maxColumnsToMerge) {
        super(appendableIndexSpec, maxRowsInMemory, maxBytesInMemory, skipBytesInMemoryOverheadCheck, maxRowsPerSegment, maxTotalRows, intermediatePersistPeriod, basePersistDirectory, maxPendingPersists, indexSpec, indexSpecForIntermediatePersists, reportParseExceptions, handoffConditionTimeout, resetOffsetAutomatically, skipSequenceNumberAvailabilityCheck, segmentWriteOutMediumFactory, intermediateHandoffPeriod, logParseExceptions, maxParseExceptions, maxSavedParseExceptions, null, maxColumnsToMerge, Boolean.valueOf(false));
        this.recordBufferSize = recordBufferSize;
        this.recordBufferSizeBytes = recordBufferSizeBytes;
        this.recordBufferOfferTimeout = recordBufferOfferTimeout == null ? 5000 : recordBufferOfferTimeout;
        this.recordBufferFullWait = recordBufferFullWait == null ? 5000 : recordBufferFullWait;
        this.fetchThreads = fetchThreads;
        this.maxRecordsPerPoll = maxRecordsPerPoll;
        this.maxBytesPerPoll = maxBytesPerPoll;
        Preconditions.checkArgument((!super.isResetOffsetAutomatically() || !super.isSkipSequenceNumberAvailabilityCheck() ? 1 : 0) != 0, (Object)"resetOffsetAutomatically cannot be used if skipSequenceNumberAvailabilityCheck=true");
    }

    @JsonCreator
    private KinesisIndexTaskTuningConfig(@JsonProperty(value="appendableIndexSpec") @Nullable AppendableIndexSpec appendableIndexSpec, @JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") Long maxBytesInMemory, @JsonProperty(value="skipBytesInMemoryOverheadCheck") @Nullable Boolean skipBytesInMemoryOverheadCheck, @JsonProperty(value="maxRowsPerSegment") Integer maxRowsPerSegment, @JsonProperty(value="maxTotalRows") Long maxTotalRows, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="indexSpecForIntermediatePersists") @Nullable IndexSpec indexSpecForIntermediatePersists, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout, @JsonProperty(value="resetOffsetAutomatically") Boolean resetOffsetAutomatically, @JsonProperty(value="skipSequenceNumberAvailabilityCheck") Boolean skipSequenceNumberAvailabilityCheck, @JsonProperty(value="recordBufferSize") @Deprecated @Nullable Integer recordBufferSize, @JsonProperty(value="recordBufferSizeBytes") Integer recordBufferSizeBytes, @JsonProperty(value="recordBufferOfferTimeout") Integer recordBufferOfferTimeout, @JsonProperty(value="recordBufferFullWait") Integer recordBufferFullWait, @JsonProperty(value="fetchThreads") Integer fetchThreads, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions, @JsonProperty(value="maxRecordsPerPoll") @Deprecated @Nullable Integer maxRecordsPerPoll, @JsonProperty(value="maxBytesPerPoll") @Nullable Integer maxBytesPerPoll, @JsonProperty(value="intermediateHandoffPeriod") @Nullable Period intermediateHandoffPeriod, @JsonProperty(value="maxColumnsToMerge") @Nullable Integer maxColumnsToMerge) {
        this(appendableIndexSpec, maxRowsInMemory, maxBytesInMemory, skipBytesInMemoryOverheadCheck, maxRowsPerSegment, maxTotalRows, intermediatePersistPeriod, null, maxPendingPersists, indexSpec, indexSpecForIntermediatePersists, reportParseExceptions, handoffConditionTimeout, resetOffsetAutomatically, skipSequenceNumberAvailabilityCheck, recordBufferSize, recordBufferSizeBytes, recordBufferOfferTimeout, recordBufferFullWait, fetchThreads, segmentWriteOutMediumFactory, logParseExceptions, maxParseExceptions, maxSavedParseExceptions, maxRecordsPerPoll, maxBytesPerPoll, intermediateHandoffPeriod, maxColumnsToMerge);
    }

    @Nullable
    @JsonProperty(value="recordBufferSize")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getRecordBufferSizeConfigured() {
        return this.recordBufferSize;
    }

    @Nullable
    @JsonProperty(value="recordBufferSizeBytes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getRecordBufferSizeBytesConfigured() {
        return this.recordBufferSizeBytes;
    }

    public int getRecordBufferSizeBytesOrDefault(long maxHeapSize) {
        if (this.recordBufferSizeBytes != null) {
            return this.recordBufferSizeBytes;
        }
        return (int)Math.min(100000000L, (long)((double)maxHeapSize * 0.1));
    }

    @JsonProperty
    public int getRecordBufferOfferTimeout() {
        return this.recordBufferOfferTimeout;
    }

    @JsonProperty
    public int getRecordBufferFullWait() {
        return this.recordBufferFullWait;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getFetchThreads() {
        return this.fetchThreads;
    }

    @Nullable
    @JsonProperty(value="maxRecordsPerPoll")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaxRecordsPerPollConfigured() {
        return this.maxRecordsPerPoll;
    }

    @Nullable
    @JsonProperty(value="maxBytesPerPoll")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaxBytesPerPollConfigured() {
        return this.maxBytesPerPoll;
    }

    public int getMaxBytesPerPollOrDefault() {
        return this.maxBytesPerPoll != null ? this.maxBytesPerPoll : 1000000;
    }

    public KinesisIndexTaskTuningConfig withBasePersistDirectory(File dir) {
        return new KinesisIndexTaskTuningConfig(this.getAppendableIndexSpec(), this.getMaxRowsInMemory(), this.getMaxBytesInMemory(), this.isSkipBytesInMemoryOverheadCheck(), this.getMaxRowsPerSegment(), this.getMaxTotalRows(), this.getIntermediatePersistPeriod(), dir, this.getMaxPendingPersists(), this.getIndexSpec(), this.getIndexSpecForIntermediatePersists(), this.isReportParseExceptions(), this.getHandoffConditionTimeout(), this.isResetOffsetAutomatically(), this.isSkipSequenceNumberAvailabilityCheck(), this.getRecordBufferSizeConfigured(), this.getRecordBufferSizeBytesConfigured(), this.getRecordBufferOfferTimeout(), this.getRecordBufferFullWait(), this.getFetchThreads(), this.getSegmentWriteOutMediumFactory(), this.isLogParseExceptions(), this.getMaxParseExceptions(), this.getMaxSavedParseExceptions(), this.getMaxRecordsPerPollConfigured(), this.getMaxBytesPerPollConfigured(), this.getIntermediateHandoffPeriod(), this.getMaxColumnsToMerge());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KinesisIndexTaskTuningConfig that = (KinesisIndexTaskTuningConfig)((Object)o);
        return Objects.equals(this.recordBufferSize, that.recordBufferSize) && Objects.equals(this.recordBufferSizeBytes, that.recordBufferSizeBytes) && this.recordBufferOfferTimeout == that.recordBufferOfferTimeout && this.recordBufferFullWait == that.recordBufferFullWait && Objects.equals(this.maxRecordsPerPoll, that.maxRecordsPerPoll) && Objects.equals(this.maxBytesPerPoll, that.maxBytesPerPoll) && Objects.equals(this.fetchThreads, that.fetchThreads);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.recordBufferSize, this.recordBufferSizeBytes, this.recordBufferOfferTimeout, this.recordBufferFullWait, this.fetchThreads, this.maxRecordsPerPoll, this.maxBytesPerPoll);
    }

    public String toString() {
        return "KinesisIndexTaskTuningConfig{maxRowsInMemory=" + this.getMaxRowsInMemory() + ", maxBytesInMemory=" + this.getMaxBytesInMemory() + ", skipBytesInMemoryOverheadCheck=" + this.isSkipBytesInMemoryOverheadCheck() + ", maxRowsPerSegment=" + this.getMaxRowsPerSegment() + ", maxTotalRows=" + this.getMaxTotalRows() + ", intermediatePersistPeriod=" + String.valueOf(this.getIntermediatePersistPeriod()) + ", maxPendingPersists=" + this.getMaxPendingPersists() + ", indexSpec=" + String.valueOf(this.getIndexSpec()) + ", reportParseExceptions=" + this.isReportParseExceptions() + ", handoffConditionTimeout=" + this.getHandoffConditionTimeout() + ", resetOffsetAutomatically=" + this.isResetOffsetAutomatically() + ", skipSequenceNumberAvailabilityCheck=" + this.isSkipSequenceNumberAvailabilityCheck() + ", recordBufferSize=" + this.recordBufferSize + ", recordBufferSizeBytes=" + this.recordBufferSizeBytes + ", recordBufferOfferTimeout=" + this.recordBufferOfferTimeout + ", recordBufferFullWait=" + this.recordBufferFullWait + ", fetchThreads=" + this.fetchThreads + ", segmentWriteOutMediumFactory=" + String.valueOf(this.getSegmentWriteOutMediumFactory()) + ", logParseExceptions=" + this.isLogParseExceptions() + ", maxParseExceptions=" + this.getMaxParseExceptions() + ", maxSavedParseExceptions=" + this.getMaxSavedParseExceptions() + ", maxRecordsPerPoll=" + this.maxRecordsPerPoll + ", maxBytesPerPoll=" + this.maxBytesPerPoll + ", intermediateHandoffPeriod=" + String.valueOf(this.getIntermediateHandoffPeriod()) + ", maxColumnsToMerge=" + this.getMaxColumnsToMerge() + "}";
    }
}

